package ext.dom {

[Native("Ext.dom.Query", require)]
/**
 * Provides high performance selector/xpath processing by compiling queries
 * into reusable functions. New pseudo classes and matchers can be plugged. It works
 * on HTML and XML documents (if a content node is passed in).
 * <p>DomQuery supports most of the <a href="http://www.w3.org/TR/2005/WD-css3-selectors-20051215/#selectors">CSS3 selectors spec</a>, along with some custom selectors
 * and basic XPath.</p>
 * <p>All selectors, attribute filters and pseudos below can be combined infinitely in any order.
 * For example <code>div.foo:nth-child(odd)[&#64;foo=bar].bar:first</code> would be a perfectly valid selector.
 * Node filters are processed in the order in which they appear, which allows you to optimize
 * your queries for your document structure.</p>
 * <p><b><i>Simple Selectors</i></b></p>
 * <p>For performance reasons, some query methods accept selectors that are termed as
 * <b>simple selectors</b>. A simple selector is a selector that does not include contextual
 * information about any parent/sibling elements.</p>
 * <p>Some examples of valid simple selectors:</p>
 * <pre>
 * var simple = '.foo'; // Only asking for the class name on the element
 * var simple = 'div.bar'; // Only asking for the tag/class name on the element
 * var simple = '[href];' // Asking for an attribute on the element.
 * var simple = ':not(.foo)'; // Only asking for the non-matches against the class name
 * var simple = 'span:first-child'; // Doesn't require any contextual information about
 *                                  // the parent node
 * </pre>
 * <p>Simple examples of invalid simple selectors:</p>
 * <pre>
 * var notSimple = 'div.foo div.bar'; // Requires matching a parent node by class name
 * var notSimple = 'span + div'; //  Requires matching a sibling by tag name
 * </pre>
 * <p><b><i>Element Selectors:</i></b></p>
 * <ul>
 * <li><b><code>&#42;</code></b> any element</li>
 * <li><b><code>E</code></b> an element with the tag E</li>
 * <li><b><code>E F</code></b> All descendent elements of E that have the tag F</li>
 * <li><b><code>E &gt; F</code></b> or <b>E/F</b> all direct children elements of E that have the tag F</li>
 * <li><b><code>E + F</code></b> all elements with the tag F that are immediately preceded by an element
 * with the tag E</li>
 * <li><b><code>E ~ F</code></b> all elements with the tag F that are preceded by a sibling element with the tag E</li>
 * </ul>
 * <p><b><i>Attribute Selectors:</i></b></p>
 * <p>The use of <code>&#64;</code> and quotes are optional. For example, <code>div[&#64;foo='bar']</code> is also a valid attribute
 * selector.</p>
 * <ul>
 * <li><b><code>E[foo]</code></b> has an attribute "foo"</li>
 * <li><b><code>E[foo=bar]</code></b> has an attribute "foo" that equals "bar"</li>
 * <li><b><code>E[foo^=bar]</code></b> has an attribute "foo" that starts with "bar"</li>
 * <li><b><code>E[foo$=bar]</code></b> has an attribute "foo" that ends with "bar"</li>
 * <li><b><code>E[foo&#42;=bar]</code></b> has an attribute "foo" that contains the substring "bar"</li>
 * <li><b><code>E[foo%=2]</code></b> has an attribute "foo" that is evenly divisible by 2</li>
 * <li><b><code>E[foo!=bar]</code></b> attribute "foo" does not equal "bar"</li>
 * </ul>
 * <p><b><i>Pseudo Classes:</i></b></p>
 * <ul>
 * <li><b><code>E:first-child</code></b> E is the first child of its parent</li>
 * <li><b><code>E:last-child</code></b> E is the last child of its parent</li>
 * <li><b><code>E:nth-child(_n_)</code></b> E is the _n_th child of its parent (1 based as per the spec)</li>
 * <li><b><code>E:nth-child(odd)</code></b> E is an odd child of its parent</li>
 * <li><b><code>E:nth-child(even)</code></b> E is an even child of its parent</li>
 * <li><b><code>E:only-child</code></b> E is the only child of its parent</li>
 * <li><b><code>E:checked</code></b> E is an element that is has a checked attribute that is true
 * (e.g. a radio or checkbox)</li>
 * <li><b><code>E:first</code></b> the first E in the resultset</li>
 * <li><b><code>E:last</code></b> the last E in the resultset</li>
 * <li><b><code>E:nth(_n_)</code></b> the _n_th E in the resultset (1 based)</li>
 * <li><b><code>E:odd</code></b> shortcut for :nth-child(odd)</li>
 * <li><b><code>E:even</code></b> shortcut for :nth-child(even)</li>
 * <li><b><code>E:contains(foo)</code></b> E's innerHTML contains the substring "foo"</li>
 * <li><b><code>E:nodeValue(foo)</code></b> E contains a textNode with a nodeValue that equals "foo"</li>
 * <li><b><code>E:not(S)</code></b> an E element that does not match simple selector S</li>
 * <li><b><code>E:has(S)</code></b> an E element that has a descendent that matches simple selector S</li>
 * <li><b><code>E:next(S)</code></b> an E element whose next sibling matches simple selector S</li>
 * <li><b><code>E:prev(S)</code></b> an E element whose previous sibling matches simple selector S</li>
 * <li><b><code>E:any(S1|S2|S2)</code></b> an E element which matches any of the simple selectors S1, S2 or S3</li>
 * <li><b><code>E:visible(true)</code></b> an E element which is deeply visible according to
 * →<code>ext.dom.Element.isVisible()</code></li>
 * </ul>
 * <p><b><i>CSS Value Selectors:</i></b></p>
 * <ul>
 * <li><b><code>E{display=none}</code></b> css value "display" that equals "none"</li>
 * <li><b><code>E{display^=none}</code></b> css value "display" that starts with "none"</li>
 * <li><b><code>E{display$=none}</code></b> css value "display" that ends with "none"</li>
 * <li><b><code>E{display&#42;=none}</code></b> css value "display" that contains the substring "none"</li>
 * <li><b><code>E{display%=2}</code></b> css value "display" that is evenly divisible by 2</li>
 * <li><b><code>E{display!=none}</code></b> css value "display" that does not equal "none"</li>
 * </ul>
 * <p><b><i>XML Namespaces:</i></b></p>
 * <ul>
 * <li><b><code>ns|E</code></b> an element with tag E and namespace prefix ns</li>
 * </ul>
 * @see ext.dom.Element#isVisible()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Query.html Original Ext JS documentation of 'Ext.dom.Query'
 */
public const DomQuery:SDomQuery = new SDomQuery;
}