package ext.dom {
import ext.Component;
import ext.ElementLoader;
import ext.dd.DD;
import ext.dd.DDProxy;
import ext.dd.DDTarget;
import ext.dd.IDDScrollConfig;
import ext.fx.Anim;
import ext.mixin.Observable;
import ext.util.IPositionable;
import ext.util.KeyMap;
import ext.util.Region;

import js.HTMLElement;

[Native("Ext.dom.Element", require)]
/**
 * @see ext.dom.events.Element_e_tEvent.ABORT
 * @eventType ext.dom.events.Element_e_tEvent.ABORT
 */
[Event(name='onAbort', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.BLUR
 * @eventType ext.dom.events.Element_e_tEvent.BLUR
 */
[Event(name='onBlur', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.CHANGE
 * @eventType ext.dom.events.Element_e_tEvent.CHANGE
 */
[Event(name='onChange', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.CLICK
 * @eventType ext.dom.events.Element_e_tEvent.CLICK
 */
[Event(name='onClick', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.CONTEXT_MENU
 * @eventType ext.dom.events.Element_e_tEvent.CONTEXT_MENU
 */
[Event(name='onContextMenu', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DBLCLICK
 * @eventType ext.dom.events.Element_e_tEvent.DBLCLICK
 */
[Event(name='onDblclick', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_ACTIVATE
 * @eventType ext.dom.events.Element_e_tEvent.DOM_ACTIVATE
 */
[Event(name='onDOMActivate', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_ATTR_MODIFIED
 * @eventType ext.dom.events.Element_e_tEvent.DOM_ATTR_MODIFIED
 */
[Event(name='onDOMAttrModified', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_CHARACTER_DATA_MODIFIED
 * @eventType ext.dom.events.Element_e_tEvent.DOM_CHARACTER_DATA_MODIFIED
 */
[Event(name='onDOMCharacterDataModified', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_FOCUS_IN
 * @eventType ext.dom.events.Element_e_tEvent.DOM_FOCUS_IN
 */
[Event(name='onDOMFocusIn', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_FOCUS_OUT
 * @eventType ext.dom.events.Element_e_tEvent.DOM_FOCUS_OUT
 */
[Event(name='onDOMFocusOut', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_NODE_INSERTED
 * @eventType ext.dom.events.Element_e_tEvent.DOM_NODE_INSERTED
 */
[Event(name='onDOMNodeInserted', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_NODE_INSERTED_INTO_DOCUMENT
 * @eventType ext.dom.events.Element_e_tEvent.DOM_NODE_INSERTED_INTO_DOCUMENT
 */
[Event(name='onDOMNodeInsertedIntoDocument', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_NODE_REMOVED
 * @eventType ext.dom.events.Element_e_tEvent.DOM_NODE_REMOVED
 */
[Event(name='onDOMNodeRemoved', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_NODE_REMOVED_FROM_DOCUMENT
 * @eventType ext.dom.events.Element_e_tEvent.DOM_NODE_REMOVED_FROM_DOCUMENT
 */
[Event(name='onDOMNodeRemovedFromDocument', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.DOM_SUBTREE_MODIFIED
 * @eventType ext.dom.events.Element_e_tEvent.DOM_SUBTREE_MODIFIED
 */
[Event(name='onDOMSubtreeModified', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.DOUBLE_TAP
 * @eventType ext.dom.events.Element_event_node_optionsEvent.DOUBLE_TAP
 */
[Event(name='onDoubleTap', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.ERROR
 * @eventType ext.dom.events.Element_e_tEvent.ERROR
 */
[Event(name='onError', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.FOCUS
 * @eventType ext.dom.events.Element_e_tEvent.FOCUS
 */
[Event(name='onFocus', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.FOCUS_MOVE
 * @eventType ext.dom.events.Element_e_tEvent.FOCUS_MOVE
 */
[Event(name='onFocusMove', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.KEY_DOWN
 * @eventType ext.dom.events.Element_e_tEvent.KEY_DOWN
 */
[Event(name='onKeyDown', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.KEYPRESS
 * @eventType ext.dom.events.Element_e_tEvent.KEYPRESS
 */
[Event(name='onKeypress', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.KEY_UP
 * @eventType ext.dom.events.Element_e_tEvent.KEY_UP
 */
[Event(name='onKeyUp', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.LOAD
 * @eventType ext.dom.events.Element_e_tEvent.LOAD
 */
[Event(name='onLoad', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.LONG_PRESS
 * @eventType ext.dom.events.Element_event_node_optionsEvent.LONG_PRESS
 */
[Event(name='onLongPress', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_DOWN
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_DOWN
 */
[Event(name='onMouseDown', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_ENTER
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_ENTER
 */
[Event(name='onMouseEnter', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_LEAVE
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_LEAVE
 */
[Event(name='onMouseLeave', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_MOVE
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_MOVE
 */
[Event(name='onMouseMove', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_OUT
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_OUT
 */
[Event(name='onMouseOut', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_OVER
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_OVER
 */
[Event(name='onMouseOver', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.MOUSE_UP
 * @eventType ext.dom.events.Element_e_tEvent.MOUSE_UP
 */
[Event(name='onMouseUp', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.ElementEvent.PAINTED
 * @eventType ext.dom.events.ElementEvent.PAINTED
 */
[Event(name='onPainted', type='ext.dom.events.ElementEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.PINCH
 * @eventType ext.dom.events.Element_event_node_optionsEvent.PINCH
 */
[Event(name='onPinch', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.PINCH_END
 * @eventType ext.dom.events.Element_event_node_optionsEvent.PINCH_END
 */
[Event(name='onPinchEnd', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.PINCH_START
 * @eventType ext.dom.events.Element_event_node_optionsEvent.PINCH_START
 */
[Event(name='onPinchStart', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.RESET
 * @eventType ext.dom.events.Element_e_tEvent.RESET
 */
[Event(name='onReset', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_infoEvent.RESIZE
 * @eventType ext.dom.events.Element_infoEvent.RESIZE
 */
[Event(name='onResize', type='ext.dom.events.Element_infoEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.ROTATE
 * @eventType ext.dom.events.Element_event_node_optionsEvent.ROTATE
 */
[Event(name='onRotate', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.ROTATE_END
 * @eventType ext.dom.events.Element_event_node_optionsEvent.ROTATE_END
 */
[Event(name='onRotateEnd', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.ROTATE_START
 * @eventType ext.dom.events.Element_event_node_optionsEvent.ROTATE_START
 */
[Event(name='onRotateStart', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.SCROLL
 * @eventType ext.dom.events.Element_e_tEvent.SCROLL
 */
[Event(name='onScroll', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.SELECT
 * @eventType ext.dom.events.Element_e_tEvent.SELECT
 */
[Event(name='onSelect', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.SINGLE_TAP
 * @eventType ext.dom.events.Element_event_node_optionsEvent.SINGLE_TAP
 */
[Event(name='onSingleTap', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.SUBMIT
 * @eventType ext.dom.events.Element_e_tEvent.SUBMIT
 */
[Event(name='onSubmit', type='ext.dom.events.Element_e_tEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.SWIPE
 * @eventType ext.dom.events.Element_event_node_optionsEvent.SWIPE
 */
[Event(name='onSwipe', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_event_node_optionsEvent.TAP_HOLD
 * @eventType ext.dom.events.Element_event_node_optionsEvent.TAP_HOLD
 */
[Event(name='onTapHold', type='ext.dom.events.Element_event_node_optionsEvent')]
/**
 * @see ext.dom.events.Element_e_tEvent.UNLOAD
 * @eventType ext.dom.events.Element_e_tEvent.UNLOAD
 */
[Event(name='onUnload', type='ext.dom.events.Element_e_tEvent')]
/**
 * Encapsulates a DOM element, adding simple DOM manipulation facilities, normalizing for browser
 * differences.
 * <p><b>Note:</b> The events included in this Class are the ones we've found to be the most commonly
 * used. Many events are not listed here due to the expedient rate of change across browsers.
 * For a more comprehensive list, please visit the following resources:</p>
 * <ul>
 * <li><a href="https://developer.mozilla.org/en-US/docs/Web/Events">Mozilla Event Reference Guide</a></li>
 * <li><a href="http://www.w3.org/TR/pointerevents/">W3 Pointer Events</a></li>
 * <li><a href="http://www.w3.org/TR/touch-events/">W3 Touch Events</a></li>
 * <li><a href="http://www.w3.org/TR/DOM-Level-2-Events/">W3 DOM 2 Events</a></li>
 * <li><a href="http://www.w3.org/TR/DOM-Level-3-Events/">W3 DOM 3 Events</a></li>
 * </ul>
 * <p><b><i>Usage</i></b></p>
 * <pre>
 * // by id
 * var el = Ext.get("my-div");
 *
 * // by DOM element reference
 * var el = Ext.get(myDivElement);
 * </pre>
 * <p><b><i>Selecting Descendant Elements</i></b></p>
 * <p>Ext.dom.Element instances can be used to select descendant nodes using CSS selectors.
 * There are 3 methods that can be used for this purpose, each with a slightly different
 * twist:</p>
 * <ul>
 * <li>→<code>query()</code></li>
 * <li>→<code>selectNode()</code></li>
 * <li>→<code>select()</code></li>
 * </ul>
 * <p>These methods can accept any valid CSS selector since they all use
 * <a href="http://www.w3.org/TR/css3-selectors/">querySelectorAll</a> under the hood. The primary
 * difference between these three methods is their return type:</p>
 * <p>To get an array of HTMLElement instances matching the selector '.foo' use the query
 * method:</p>
 * <pre>
 * element.query('.foo');
 * </pre>
 * <p>This can easily be transformed into an array of Ext.dom.Element instances by setting
 * the <code>asDom</code> parameter to <code>false</code>:</p>
 * <pre>
 * element.query('.foo', false);
 * </pre>
 * <p>If the desired result is only the first matching HTMLElement use the selectNode method:</p>
 * <pre>
 * element.selectNode('.foo');
 * </pre>
 * <p>Once again, the dom node can be wrapped in an Ext.dom.Element by setting the <code>asDom</code>
 * parameter to <code>false</code>:</p>
 * <pre>
 * element.selectNode('.foo', false);
 * </pre>
 * <p>The <code>select</code> method is used when the desired return type is a →<code>ext.dom.CompositeElementLite</code> or a →<code>ext.dom.CompositeElement</code>. These are collections of elements that can be operated on as a
 * group using any of the methods of Ext.dom.Element. The only difference between the two
 * is that CompositeElementLite is a collection of HTMLElement instances, while
 * CompositeElement is a collection of Ext.dom.Element instances. To retrieve a
 * CompositeElementLite that represents a collection of HTMLElements for selector '.foo':</p>
 * <pre>
 * element.select('.foo');
 * </pre>
 * <p>For a →<code>ext.dom.CompositeElement</code> simply pass <code>true</code> as the
 * <code>composite</code> parameter:</p>
 * <pre>
 * element.select('.foo', true);
 * </pre>
 * <p>The query selection methods can be used even if you don't have a Ext.dom.Element to
 * start with For example to select an array of all HTMLElements in the document that match the
 * selector '.foo', simply wrap the document object in an Ext.dom.Element instance using
 * →<code>ext.Ext.fly()</code>:</p>
 * <pre>
 * Ext.fly(document).query('.foo');
 * </pre>
 * <p><b>Animations</b></p>
 * <p>When an element is manipulated, by default there is no animation.</p>
 * <pre>
 * var el = Ext.get("my-div");
 *
 * // no animation
 * el.setWidth(100);
 * </pre>
 * <p>specified as boolean (true) for default animation effects.</p>
 * <pre>
 * // default animation
 * el.setWidth(100, true);
 * </pre>
 * <p>To configure the effects, an object literal with animation options to use as the Element
 * animation configuration object can also be specified. Note that the supported Element animation
 * configuration options are a subset of the →<code>ext.fx.Anim</code> animation options specific to Fx
 * effects. The supported Element animation configuration options are:</p>
 * <pre>
 * Option    Default   Description
 * --------- --------  ---------------------------------------------
 * duration  350       The duration of the animation in milliseconds
 * easing    easeOut   The easing method
 * callback  none      A function to execute when the anim completes
 * scope     this      The scope (this) of the callback function
 * </pre>
 * <p>Usage:</p>
 * <pre>
 * // Element animation options object
 * var opt = {
 *     duration: 1000,
 *     easing: 'elasticIn',
 *     callback: this.foo,
 *     scope: this
 * };
 * // animation with some options set
 * el.setWidth(100, opt);
 * </pre>
 * <p>The Element animation object being used for the animation will be set on the options object
 * as "anim", which allows you to stop or manipulate the animation. Here is an example:</p>
 * <pre>
 * // using the "anim" property to get the Anim object
 * if(opt.anim.isAnimated()){
 *     opt.anim.stop();
 * }
 * </pre>
 * @see #query()
 * @see #selectNode()
 * @see #select()
 * @see ext.dom.CompositeElementLite
 * @see ext.dom.CompositeElement
 * @see ext.SExt#fly() ext.Ext.fly()
 * @see ext.fx.Anim
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html Original Ext JS documentation of 'Ext.dom.Element'
 */
public class Element extends Observable implements IPositionable {
  /**
   * Visibility mode constant for use with →<code>ext.dom.Element.setVisibilityMode()</code>.
   * Use CSS <code>→clip()</code> property to reduce element's dimensions to 0px by 0px, effectively
   * making it hidden while not being truly invisible. This is useful when an element
   * needs to be published to the Assistive Technologies such as screen readers.
   * @default 4
   * @see ext.dom.Element#setVisibilityMode()
   * @see #clip()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-property-CLIP Original Ext JS documentation of 'CLIP'
   */
  public static native function get CLIP():Number;

  /**
   * Visibility mode constant for use with →<code>ext.dom.Element.setVisibilityMode()</code>.
   * Use the CSS 'display' property to hide the element.
   * @default 2
   * @see ext.dom.Element#setVisibilityMode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-property-DISPLAY Original Ext JS documentation of 'DISPLAY'
   */
  public static native function get DISPLAY():Number;

  /**
   * Visibility mode constant for use with →<code>ext.dom.Element.setVisibilityMode()</code>.
   * Use CSS absolute positioning and top/left offsets to hide the element.
   * @default 3
   * @see ext.dom.Element#setVisibilityMode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-property-OFFSETS Original Ext JS documentation of 'OFFSETS'
   */
  public static native function get OFFSETS():Number;

  /**
   * Visibility mode constant for use with →<code>ext.dom.Element.setVisibilityMode()</code>.
   * Use CSS <code>opacity</code> property to reduce element's opacity to 0
   * @default 5
   * @see ext.dom.Element#setVisibilityMode()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-property-OPACITY Original Ext JS documentation of 'OPACITY'
   */
  public static native function get OPACITY():Number;

  /**
   * Visibility mode constant for use with →<code>ext.dom.Element.setVisibilityMode()</code>.
   * Use the CSS 'visibility' property to hide the element.
   * <p>Note that in this mode, →<code>ext.dom.Element.isVisible()</code> may return true
   * for an element even though it actually has a parent element that is hidden. For this
   * reason, and in most cases, using the →<code>OFFSETS</code> mode is a better choice.</p>
   * @default 1
   * @see ext.dom.Element#setVisibilityMode()
   * @see ext.dom.Element#isVisible()
   * @see #OFFSETS
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-property-VISIBILITY Original Ext JS documentation of 'VISIBILITY'
   */
  public static native function get VISIBILITY():Number;

  /**
   * Determines the maximum size for all ripples
   * @default 75
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-property-maxRippleDiameter Original Ext JS documentation of 'maxRippleDiameter'
   */
  public static native function get maxRippleDiameter():*;

  /**
   * @private
   */
  public static native function set maxRippleDiameter(value:*):void;

  /**
   * Gets the globally shared flyweight Element, with the passed node as the active
   * element. Do not store a reference to this element - the dom node can be overwritten
   * by other code. →<code>ext.Ext.fly()</code> is alias for →<code>ext.dom.Element.fly()</code>.
   * <p>Use this to make one-time references to DOM elements which are not going to be
   * accessed again either by application code, or by Ext's classes. If accessing an
   * element which will be processed regularly, then →<code>ext.Ext.get()</code> will be
   * more appropriate to take advantage of the caching provided by the
   * →<code>ext.dom.Element</code> class.</p>
   * <p>If this method is called with and id or element that has already been cached by
   * a previous call to Ext.get() it will return the cached Element instead of the
   * flyweight instance.</p>
   * @param dom The DOM node or <code>→id</code>.
   * @return The shared Element object (or <code>null</code> if no matching
   * element was found).
   * @see ext.SExt#fly() ext.Ext.fly()
   * @see ext.dom.Element#fly()
   * @see ext.SExt#get() ext.Ext.get()
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-fly Original Ext JS documentation of 'fly'
   * @see #id
   */
  public static native function fly(dom:*, named:String = undefined):Element;

  /**
   * Returns the top Element that is located at the passed coordinates taking into account
   * the scroll position of the document.
   * @since 6.2.0
   * @param x The x coordinate
   * @param y The y coordinate
   * @param asDom <code>true</code> to return a DOM element.
   * @default false
   * @return The found element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-fromPagePoint Original Ext JS documentation of 'fromPagePoint'
   */
  public static native function fromPagePoint(x:Number, y:Number, asDom:Boolean = false):*;

  /**
   * Returns the top Element that is located at the passed coordinates in the current
   * viewport.
   * @param x The x coordinate
   * @param y The y coordinate
   * @param asDom <code>true</code> to return a DOM element.
   * @default false
   * @return The found element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-fromPoint Original Ext JS documentation of 'fromPoint'
   */
  public static native function fromPoint(x:Number, y:Number, asDom:Boolean = false):*;

  /**
   * Retrieves <code>ext.dom.Element</code> objects. →<code>ext.Ext.get()</code> is alias for
   * →<code>ext.dom.Element.get()</code>.
   * <p><b>This method does not retrieve →<code>ext.Component</code>s.</b> This method
   * retrieves Ext.dom.Element objects which encapsulate DOM elements. To retrieve
   * a Component by its ID, use →<code>ext.ComponentManager.get()</code>.</p>
   * <p>When passing an id, it should not include the <code>#</code> character that is used for a css
   * selector.</p>
   * <pre>
   * // For an element with id 'foo'
   * Ext.get('foo'); // Correct
   * Ext.get('#foo'); // Incorrect
   * </pre>
   * <p>Uses simple caching to consistently return the same object. Automatically fixes
   * if an object was recreated with the same id via AJAX or DOM.</p>
   * @param el The <code>→id</code> of the node, a DOM Node
   * or an existing Element.
   * @return The Element object (or <code>null</code> if no matching element
   * was found).
   * @see ext.SExt#get() ext.Ext.get()
   * @see ext.dom.Element#get()
   * @see ext.Component
   * @see ext.SComponentManager#get() ext.ComponentManager.get()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-get Original Ext JS documentation of 'get'
   * @see #id
   */
  public static native function get(el:*):Element;

  /**
   * Returns the active element in the DOM. If the browser supports activeElement
   * on the document, this is returned. If not, the focus is tracked and the active
   * element is maintained internally.
   * @param asElement Return Ext.Element instance instead of DOM node.
   * @return The active (focused) element in the document.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getActiveElement Original Ext JS documentation of 'getActiveElement'
   */
  public static native function getActiveElement(asElement:Boolean):HTMLElement;

  /**
   * Returns the common ancestor of the two passed elements.
   * @param nodeA
   * @param nodeB
   * @param returnDom Pass <code>true</code> to return a DOM element. Otherwise an
   * →<code>ext.dom.Element</code> will be returned.
   * @return The common ancestor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getCommonAncestor Original Ext JS documentation of 'getCommonAncestor'
   * @see ext.dom.Element
   */
  public static native function getCommonAncestor(nodeA:*, nodeB:*, returnDom:Boolean):*;

  /**
   * Retrieves the document height
   * @return documentHeight
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getDocumentHeight Original Ext JS documentation of 'getDocumentHeight'
   */
  public static native function getDocumentHeight():Number;

  /**
   * Retrieves the document width
   * @return documentWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getDocumentWidth Original Ext JS documentation of 'getDocumentWidth'
   */
  public static native function getDocumentWidth():Number;

  /**
   * Retrieves the current orientation of the window. This is calculated by
   * determining if the height is greater than the width.
   * @return Orientation of window: 'portrait' or 'landscape'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getOrientation Original Ext JS documentation of 'getOrientation'
   */
  public static native function getOrientation():String;

  /**
   * Retrieves the viewport size of the window.
   * @return object containing width and height properties
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getViewSize Original Ext JS documentation of 'getViewSize'
   */
  public static native function getViewSize():Object;

  /**
   * Retrieves the viewport height of the window.
   * @return viewportHeight
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getViewportHeight Original Ext JS documentation of 'getViewportHeight'
   */
  public static native function getViewportHeight():Number;

  /**
   * Retrieves the viewport width of the window.
   * @return viewportWidth
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-getViewportWidth Original Ext JS documentation of 'getViewportWidth'
   */
  public static native function getViewportWidth():Number;

  /**
   * Checks if the passed size has a css unit attached.
   * @since 6.2.1
   * @param size The size.
   * @return <code>true</code> if the size has a css unit.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-hasUnit Original Ext JS documentation of 'hasUnit'
   */
  public static native function hasUnit(size:String):Boolean;

  /**
   * Checks if the passed css unit is a relative unit. This includes:
   * <ul>
   * <li><code>auto</code></li>
   * <li><code>%</code></li>
   * <li><code>em</code></li>
   * <li><code>rem</code></li>
   * <li><code>auto</code></li>
   * <li><code>vh</code></li>
   * <li><code>vw</code></li>
   * <li><code>vmin</code></li>
   * <li><code>vmax</code></li>
   * <li>`ex</li>
   * <li><code>ch</code></li>
   * </ul>
   * @since 6.2.0
   * @param size The css unit and value.
   * @return <code>true</code> if the value is relative.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-isRelativeUnit Original Ext JS documentation of 'isRelativeUnit'
   */
  public static native function isRelativeUnit(size:String):Boolean;

  /**
   * Normalizes CSS property keys from dash delimited to camel case JavaScript Syntax.
   * For example:
   * <ul>
   * <li>border-width -&gt; borderWidth</li>
   * <li>padding-top -&gt; paddingTop</li>
   * </ul>
   * @param prop The property to normalize
   * @return The normalized string
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-normalize Original Ext JS documentation of 'normalize'
   */
  public static native function normalize(prop:String):String;

  /**
   * Parses a number or string representing margin sizes into an object. Supports
   * CSS-style margin declarations (e.g. 10, "10", "10 10", "10 10 10" and "10 10 10 10"
   * are all valid options and would return the same result)
   * @param box The encoded margins
   * @return An object with margin sizes for top, right, bottom and left
   * containing the unit
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-parseBox Original Ext JS documentation of 'parseBox'
   */
  public static native function parseBox(box:*):Object;

  /**
   * Converts a CSS string into an object with a property for each style.
   * <p>The sample code below would return an object with 2 properties, one
   * for background-color and one for color.</p>
   * <pre>
   * var css = 'background-color: red; color: blue;';
   * console.log(Ext.dom.Element.parseStyles(css));
   * </pre>
   * @param styles A CSS string
   * @return styles
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-parseStyles Original Ext JS documentation of 'parseStyles'
   */
  public static native function parseStyles(styles:String):Object;

  /**
   * Selects child nodes of a given root based on the passed CSS selector.
   * @param selector The CSS selector.
   * @param asDom <code>false</code> to return an array of Ext.dom.Element
   * @default true
   * @param root The root element of the query or id of
   * the root
   * @return An Array of elements that match
   * the selector. If there are no matches, an empty Array is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-query Original Ext JS documentation of 'query'
   */
  public static native function query(selector:String, asDom:Boolean = true, root:* = undefined):Array;

  /**
   * Selects elements based on the passed CSS selector to enable
   * →<code>ext.dom.Element</code> methods to be applied to many related
   * elements in one statement through the returned
   * →<code>ext.dom.CompositeElementLite</code> object.
   * @param selector The CSS selector or an array of
   * elements
   * @param composite Return a CompositeElement as opposed to
   * a CompositeElementLite. Defaults to false.
   * @default false
   * @param root The root element of the query or id of
   * the root
   * @see ext.dom.Element
   * @see ext.dom.CompositeElementLite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-select Original Ext JS documentation of 'select'
   */
  public static native function select(selector:*, composite:Boolean = false, root:* = undefined):CompositeElementLite;

  /**
   * Serializes a DOM form into a url encoded string
   * @param form The form
   * @return The url encoded form
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-serializeForm Original Ext JS documentation of 'serializeForm'
   */
  public static native function serializeForm(form:Object):String;

  /**
   * Parses a number or string representing margin sizes into an object. Supports
   * CSS-style margin declarations (e.g. 10, "10", "10 10", "10 10 10" and "10 10 10 10"
   * are all valid options and would return the same result)
   * @param box The encoded margins, or an object with top, right,
   * @param units The type of units to add
   * @return An string with unitized (px if units is not specified) metrics for
   * top, right, bottom and left
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#static-method-unitizeBox Original Ext JS documentation of 'unitizeBox'
   */
  public static native function unitizeBox(box:*, units:String):String;

  /**
   * Creates new Element directly by passing an id or the HTMLElement. This
   * constructor should not be called directly. Always use →<code>ext.Ext.get()</code>
   * or →<code>ext.Ext.fly()</code> instead.
   * <p>In older versions of Ext JS and Sencha Touch this constructor checked to see if
   * there was already an instance of this element in the cache and if so, returned
   * the same instance. As of version 5 this behavior has been removed in order to
   * avoid a redundant cache lookup since the most common path is for the Element
   * constructor to be called from →<code>ext.Ext.get()</code>, which has already
   * checked for a cache entry.</p>
   * <p>Correct way of creating a new Ext.dom.Element (or retrieving it from the cache):</p>
   * <pre>
   * var el = Ext.get('foo'); // by id
   *
   * var el = Ext.get(document.getElementById('foo')); // by DOM reference
   * </pre>
   * <p>Incorrect way of creating a new Ext.dom.Element</p>
   * <pre>
   * var el = new Ext.dom.Element('foo');
   * </pre>
   * <p>For quick and easy access to Ext.dom.Element methods use a flyweight:</p>
   * <pre>
   * Ext.fly('foo').addCls('foo-hovered');
   * </pre>
   * <p>This simply attaches the DOM node with id='foo' to the global flyweight Element
   * instance to avoid allocating an extra Ext.dom.Element instance. If, however,
   * the Element instance has already been cached by a previous call to Ext.get(),
   * then Ext.fly() will return the cached Element instance. For more info see
   * →<code>ext.Ext.fly()</code>.</p>
   * @see ext.SExt#get() ext.Ext.get()
   * @see ext.SExt#fly() ext.Ext.fly()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Element(idOrHtmlElement:Object) {
    super();
  }

  /**
   * A reference to the <code>Component</code> that owns this element. This is <code>null</code> if there
   * is no direct owner.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#property-component Original Ext JS documentation of 'component'
   */
  public native function get component():Component;

  /**
   * @private
   */
  public native function set component(value:Component):void;

  /**
   * The individual DD scroll config of this Element. If not set, the default
   * settings of <code>ScrollManager</code> are used.
   * <p>Ext AS introduces an interface for scroll configs to improve IDE support of setting
   * individual values. For example, to configure the scrolling behavior of an element <code>el</code>,
   * you could do the following:
   * </p>
   * <pre>
   *   el.ddScrollConfig = IDDScrollConfig({});
   *   scrollConfig.animate = true;
   *   scrollConfig.animDuration = 1.5;
   *   ext.dd.ScrollManager.register(el);
   * </pre>
   * Note that we cast an empty Object to the interface, which would fail in real ActionScript,
   * but does the job of convincing the IDE that the Object can be assigned to property <code>ddScrollConfig</code>
   * and saves us from providing a boiler-plate implementation of the interface.
   * @see ext.dd.ScrollManager
   */
  public native function get ddScrollConfig():IDDScrollConfig;

  /**
   * @private
   */
  public native function set ddScrollConfig(value:IDDScrollConfig):void;

  /**
   * The DOM element
   * @default dom
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#property-dom Original Ext JS documentation of 'dom'
   */
  public native function get dom():HTMLElement;

  /**
   * @private
   */
  public native function set dom(value:HTMLElement):void;

  /**
   * The DOM element ID
   * @default id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#property-id Original Ext JS documentation of 'id'
   */
  public native function get id():String;

  /**
   * @private
   */
  public native function set id(value:String):void;

  /**
   * The shadow created by →<code>#enableShadow()</code>.
   * @see #enableShadow()
   */
  public native function get shadow():Shadow;

  /**
   * Starts a custom animation on this Element.
   * <p>The following properties may be specified in <code>from</code>, <code>to</code>, and <code>keyframe</code> objects:</p>
   * <ul>
   * <li><code>x</code> - The page X position in pixels.</li>
   * <li><code>y</code> - The page Y position in pixels</li>
   * <li><code>left</code> - The element's CSS <code>left</code> value. Units must be supplied.</li>
   * <li><code>top</code> - The element's CSS <code>top</code> value. Units must be supplied.</li>
   * <li><code>width</code> - The element's CSS <code>width</code> value. Units must be supplied.</li>
   * <li><code>height</code> - The element's CSS <code>height</code> value. Units must be supplied.</li>
   * <li><code>scrollLeft</code> - The element's <code>scrollLeft</code> value.</li>
   * <li><code>scrollTop</code> - The element's <code>scrollTop</code> value.</li>
   * <li><code>opacity</code> - The element's <code>opacity</code> value (between <code>0</code> and <code>1</code>).</li>
   * </ul>
   * <p><b>Be aware</b> that animating an Element which is being used by an Ext Component
   * without in some way informing the Component about the changed element state will
   * result in incorrect Component behaviour. This is because the Component will be
   * using the old state of the element. To avoid this problem, it is now possible
   * to directly animate certain properties of Components.</p>
   * @param config Configuration for →<code>ext.fx.Anim</code>.
   * Note that the →<code>ext.fx.Anim.to</code> config is required.
   * @return The new animation.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addAnimation Original Ext JS documentation of 'addAnimation'
   * @see ext.fx.Anim
   * @see ext.fx.Anim#to
   */
  public native function addAnimation(config:Object):Anim;

  /**
   * Adds the given CSS class(es) to this Element.
   * @param names The CSS classes to add separated by space,
   * or an array of classes
   * @param prefix Prefix to prepend to each class. The separator <code>-</code> will be
   * appended to the prefix.
   * @param suffix Suffix to append to each class. The separator <code>-</code> will be
   * prepended to the suffix.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addCls Original Ext JS documentation of 'addCls'
   */
  public native function addCls(names:*, prefix:String = null, suffix:String = null):Element;

  /**
   * Sets up event handlers to add and remove a css class when the mouse is down and then up
   * on this element (a click effect)
   * @param className The class to add
   * @param testFn A test function to execute before adding the class. The passed
   * parameter will be the Element instance. If this functions returns false, the class
   * will not be added.
   * @param scope The scope to execute the testFn in.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addClsOnClick Original Ext JS documentation of 'addClsOnClick'
   */
  public native function addClsOnClick(className:String, testFn:Function = null, scope:Object = null):Element;

  /**
   * Sets up event handlers to add and remove a css class when this element has the focus
   * @param className The class to add
   * @param testFn A test function to execute before adding the class. The passed
   * parameter will be the Element instance. If this functions returns false, the class
   * will not be added.
   * @param scope The scope to execute the testFn in.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addClsOnFocus Original Ext JS documentation of 'addClsOnFocus'
   */
  public native function addClsOnFocus(className:String, testFn:Function = null, scope:Object = null):Element;

  /**
   * Sets up event handlers to add and remove a css class when the mouse is over this element
   * @param className The class to add
   * @param testFn A test function to execute before adding the class. The passed
   * parameter will be the Element instance. If this functions returns false, the class
   * will not be added.
   * @param scope The scope to execute the testFn in.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addClsOnOver Original Ext JS documentation of 'addClsOnOver'
   */
  public native function addClsOnOver(className:String, testFn:Function = null, scope:Object = null):Element;

  /**
   * Convenience method for constructing a KeyMap
   * @param key Either a string with the keys to listen for,
   * the numeric key code, array of key codes or an object with the following options:
   * <ul>
   * <li><code>key</code> (optional)</li>
   * <li><code>shift:Boolean</code> (optional)</li>
   * <li><code>ctrl:Boolean</code> (optional)</li>
   * <li><code>alt:Boolean</code> (optional)</li>
   * </ul>
   * @param fn The function to call
   * @param scope The scope (<code>this</code> reference) in which the specified function
   * is executed. Defaults to this Element.
   * @return The KeyMap created
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addKeyListener Original Ext JS documentation of 'addKeyListener'
   */
  public native function addKeyListener(key:*, fn:Function, scope:Object = null):KeyMap;

  /**
   * Creates a KeyMap for this element
   * @param config The KeyMap config. See →<code>ext.util.KeyMap</code> for more details
   * @return The KeyMap created
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-addKeyMap Original Ext JS documentation of 'addKeyMap'
   * @see ext.util.KeyMap
   */
  public native function addKeyMap(config:Object):KeyMap;

  /**
   * @inheritDoc
   */
  public native function alignTo(anchorToEl:*, alignment:String = "tl-bl?", offsets:Array = null, animate:* = undefined):void;

  /**
   * @inheritDoc
   */
  public native function anchorTo(anchorToEl:*, alignment:String = "tl-bl?", offsets:Array = null, animate:* = undefined, monitorScroll:* = 50, callback:Function = null):void;

  /**
   * Calls <code>→addAnimation()</code> and returns this Element (for call chaining). For
   * details, see <code>→addAnimation()</code>.
   * @param config Configuration for →<code>ext.fx.Anim</code>.
   * Note that the →<code>ext.fx.Anim.to</code> config is required.
   * @return this
   * @see #addAnimation()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-animate Original Ext JS documentation of 'animate'
   * @see ext.fx.Anim
   * @see ext.fx.Anim#to
   */
  public native function animate(config:Object):Element;

  /**
   * Appends the passed element(s) to this element
   * @param el The id or element to insert
   * or a DomHelper config
   * @param returnDom True to return the raw DOM element instead
   * of Ext.dom.Element
   * @default false
   * @return The inserted Ext.dom.Element (or
   * HTMLElement if <i>returnDom</i> is <i>true</i>).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-appendChild Original Ext JS documentation of 'appendChild'
   */
  public native function appendChild(el:*, returnDom:Boolean = false):Element;

  /**
   * Appends this element to the passed element.
   * @param el The new parent element.
   * The id of the node, a DOM Node or an existing Element.
   * @return This element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-appendTo Original Ext JS documentation of 'appendTo'
   */
  public native function appendTo(el:*):Element;

  /**
   * More flexible version of →<code>setStyle()</code> for setting style properties.
   * <p>Styles in object form should be a valid DOM element style property.
   * <a href="http://www.w3schools.com/jsref/dom_obj_style.asp">Valid style property names</a>
   * (<i>along with the supported CSS version for each</i>)</p>
   * <pre>
   * // &lt;div id="my-el"&gt;Phineas Flynn&lt;/div&gt;
   *
   * var el = Ext.get('my-el');
   *
   * el.applyStyles('color: white;');
   *
   * el.applyStyles({
   *     fontWeight: 'bold',
   *     backgroundColor: 'gray',
   *     padding: '10px'
   * });
   *
   * el.applyStyles(function () {
   *     if (name.initialConfig.html === 'Phineas Flynn') {
   *         return 'font-style: italic;';
   *         // OR return { fontStyle: 'italic' };
   *     }
   * });
   * </pre>
   * @param styles A style specification string, e.g.
   * "width:100px", or object in the form <code>{width:"100px"}</code>, or a function which returns
   * such a specification.
   * @return this
   * @see #setStyle()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-applyStyles Original Ext JS documentation of 'applyStyles'
   */
  public native function applyStyles(styles:*):Element;

  /**
   * Tries to blur the element. Any exceptions are caught and ignored.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-blur Original Ext JS documentation of 'blur'
   */
  public native function blur():Element;

  /**
   * Wraps the specified element with a special 9 element markup/CSS block that renders
   * by default as a gray container with a gradient background, rounded corners
   * and a 4-way shadow.
   * <p>This special markup is used throughout Ext when box wrapping elements
   * (→<code>ext.button.Button</code>, →<code>ext.panel.Panel</code> when
   * <i>frame=true</i> (→<code>ext.panel.Panel.frame</code>), →<code>ext.window.Window</code>).
   * The markup is of this form:</p>
   * <pre>
   * &lt;div class="{0}-tl"&gt;&lt;div class="{0}-tr"&gt;&lt;div class="{0}-tc"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;
   * &lt;div class="{0}-ml"&gt;&lt;div class="{0}-mr"&gt;&lt;div class="{0}-mc"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;
   * &lt;div class="{0}-bl"&gt;&lt;div class="{0}-br"&gt;&lt;div class="{0}-bc"&gt;&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;
   * </pre>
   * <p>Example usage:</p>
   * <pre>
   * // Basic box wrap
   * Ext.get("foo").boxWrap();
   *
   * // You can also add a custom class and use CSS inheritance rules to customize
   * // the box look.
   * // 'x-box-blue' is a built-in alternative -- look at the related CSS definitions
   * // as an example for how to create a custom box wrap style.
   * Ext.get("foo").boxWrap().addCls("x-box-blue");
   * </pre>
   * @param cls A base CSS class to apply to the containing wrapper
   * element. Note that there are a number of CSS rules that are dependent on this name
   * to make the overall effect work, so if you supply an alternate base class, make sure
   * you also supply all of the necessary rules.
   * @default 'x-box'
   * @return The outermost wrapping element of the created box structure.
   * @see ext.button.Button
   * @see ext.panel.Panel
   * @see ext.panel.Panel#frame
   * @see ext.window.Window
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-boxWrap Original Ext JS documentation of 'boxWrap'
   */
  public native function boxWrap(cls:String = 'x-box'):Element;

  /**
   * When an element is moved around in the DOM, or is hidden using <code>display:none</code>, it loses
   * layout, and therefore all scroll positions of all descendant elements are lost.
   * <p>This function caches them, and returns a function, which when run will restore the cached
   * positions. In the following example, the Panel is moved from one Container to another
   * which will cause it to lose all scroll positions:</p>
   * <pre>
   * var restoreScroll = myPanel.el.cacheScrollValues();
   * myOtherContainer.add(myPanel);
   * restoreScroll();
   * </pre>
   * @return A function which will restore all descendant elements of this Element
   * to their scroll positions recorded when this function was executed. Be aware that the
   * returned function is a closure which has captured the scope of <code>→cacheScrollValues()</code>, so
   * take care to dereference it as soon as not needed - if is it is a <code>var</code> it will drop out
   * of scope, and the reference will be freed.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-cacheScrollValues Original Ext JS documentation of 'cacheScrollValues'
   * @see #cacheScrollValues()
   */
  public native function cacheScrollValues():Function;

  /**
   * Centers the Element in either the viewport, or another Element.
   * @param centerIn element in
   * which to center the element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-center Original Ext JS documentation of 'center'
   */
  public native function center(centerIn:*):Element;

  /**
   * Selects a single <i>direct</i> child based on the passed CSS selector (the selector
   * should not contain an id).
   * @param selector The CSS selector.
   * @param returnDom <code>true</code> to return the DOM node instead of
   * Ext.dom.Element.
   * @default false
   * @return The child Ext.dom.Element (or DOM node
   * if <code>returnDom</code> is <code>true</code>)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-child Original Ext JS documentation of 'child'
   */
  public native function child(selector:String, returnDom:Boolean = false):*;

  /**
   * Removes Empty, or whitespace filled text nodes. Combines adjacent text nodes.
   * @param forceReclean By default the element keeps track if it has been
   * cleaned already so you can call this over and over. However, if you update the element
   * and need to force a re-clean, you can pass true.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-clean Original Ext JS documentation of 'clean'
   */
  public native function clean(forceReclean:Boolean = false):void;

  /**
   * Clears any opacity settings from this element. Required in some cases for IE.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-clearOpacity Original Ext JS documentation of 'clearOpacity'
   */
  public native function clearOpacity():Element;

  /**
   * Clears positioning back to the default when the document was loaded.
   * @param value The value to use for the left, right, top, bottom.
   * You could use 'auto'.
   * @default ''
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-clearPositioning Original Ext JS documentation of 'clearPositioning'
   */
  public native function clearPositioning(value:String = ''):Element;

  /**
   * Store the current overflow setting and clip overflow on the element - use →<code>unclip()</code>
   * to remove
   * @return this
   * @see #unclip()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-clip Original Ext JS documentation of 'clip'
   */
  public native function clip():Element;

  /**
   * Clone this element.
   * @param deep <code>true</code> if the children of the node should also be cloned.
   * @default false
   * @param returnDom <code>true</code> to return the DOM node instead of
   * Ext.dom.Element.
   * @default false
   * @return The newly cloned Ext.dom.Element (or DOM node
   * if <code>returnDom</code> is <code>true</code>).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone(deep:Boolean = false, returnDom:Boolean = false):*;

  /**
   * Returns <code>true</code> if this element is an ancestor of the passed element, or is
   * the element.
   * @param element The dom element,
   * Ext.dom.Element, or id (string) of the dom element to check.
   * @return True if this element is an ancestor of el or the el itself, else false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(element:*):Boolean;

  /**
   * Creates the passed DomHelper config and appends it to this element or optionally
   * inserts it before the passed child element.
   * @param config DomHelper element config object. If no tag is specified
   * (e.g., {tag:'input'}) then a div will be automatically generated with the specified
   * attributes.
   * @param insertBefore a child element of this element
   * @param returnDom true to return the dom node instead of creating
   * an Element
   * @default false
   * @return The new child element (or HTMLElement if
   * <i>returnDom</i> is <i>true</i>)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-createChild Original Ext JS documentation of 'createChild'
   */
  public native function createChild(config:Object, insertBefore:HTMLElement = null, returnDom:Boolean = false):*;

  /**
   * Creates a proxy element of this element
   * @param config The class name of the proxy element or a DomHelper config
   * object
   * @param renderTo The element or element id to render the proxy to.
   * Defaults to: document.body.
   * @param matchBox True to align and size the proxy to this element now.
   * @default false
   * @return The new proxy element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-createProxy Original Ext JS documentation of 'createProxy'
   */
  public native function createProxy(config:*, renderTo:* = undefined, matchBox:Boolean = false):Element;

  /**
   * Destroys this element by removing it from the cache, removing its DOM reference,
   * and removing all of its event listeners.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Disables the shadow element created by →<code>enableShadow()</code>.
   * @see #enableShadow()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-disableShadow Original Ext JS documentation of 'disableShadow'
   */
  public native function disableShadow():void;

  /**
   * Selects a single child at any depth below this element based on the passed
   * CSS selector (the selector should not contain an id).
   * <p>Use →<code>getById()</code> if you need to get a reference to a child element via id.</p>
   * @param selector The CSS selector
   * @param returnDom <code>true</code> to return the DOM node instead of
   * Ext.dom.Element
   * @default false
   * @return The child Ext.dom.Element (or DOM node
   * if <code>returnDom</code> is <code>true</code>)
   * @see #getById()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-down Original Ext JS documentation of 'down'
   */
  public native function down(selector:String, returnDom:Boolean = false):*;

  /**
   * Empties this element. Removes all child nodes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-empty Original Ext JS documentation of 'empty'
   */
  public native function empty():void;

  /**
   * Convenience method for setVisibilityMode(Element.DISPLAY).
   * @param display What to set display to when visible
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-enableDisplayMode Original Ext JS documentation of 'enableDisplayMode'
   */
  public native function enableDisplayMode(display:String = null):Element;

  /**
   * Enables a shadow element that will always display behind this element
   * @param options Configuration options for the shadow
   * <ul>
   * <li><code>offset:Number</code> (default = <code>4</code>) —
   * Number of pixels to offset the shadow
   * </li>
   * <li><code>mode:String</code> (default = <code>'sides'</code>) —
   * The shadow display mode. Supports the following
   * options:
   * <pre>
   * - `'sides'`: Shadow displays on both sides and bottom only
   * - `'frame'`: Shadow displays equally on all four sides
   * - `'drop'`: Traditional bottom-right drop shadow
   * - `'bottom'`: Shadow is offset to the bottom
   * </pre>
   * </li>
   * <li><code>animate:Boolean</code> (default = <code>false</code>) —
   * <code>true</code> to animate the shadow while
   * the element is animating. By default the shadow will be hidden during animation.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-enableShadow Original Ext JS documentation of 'enableShadow'
   */
  public native function enableShadow(options:Object = null, isVisible:* = undefined):void;

  /**
   * Fade an element in (from transparent to opaque). The ending opacity can be specified
   * using the <code>opacity</code> config option. Usage:
   * <pre>
   * // default: fade in from opacity 0 to 100%
   * el.fadeIn();
   *
   * // custom: fade in from opacity 0 to 75% over 2 seconds
   * el.fadeIn({ opacity: .75, duration: 2000});
   *
   * // common config options shown with default values
   * el.fadeIn({
   *     opacity: 1, //can be any value between 0 and 1 (e.g. .5)
   *     easing: 'easeOut',
   *     duration: 500
   * });
   * </pre>
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-fadeIn Original Ext JS documentation of 'fadeIn'
   * @see ext.fx.Anim
   */
  public native function fadeIn(options:Object = null):Element;

  /**
   * Fade an element out (from opaque to transparent). The ending opacity can be specified
   * using the <code>opacity</code> config option. Note that IE may require <code>useDisplay: true</code> in order
   * to redisplay correctly. Usage:
   * <pre>
   * // default: fade out from the element's current opacity to 0
   * el.fadeOut();
   *
   * // custom: fade out from the element's current opacity to 25% over 2 seconds
   * el.fadeOut({ opacity: .25, duration: 2000});
   *
   * // common config options shown with default values
   * el.fadeOut({
   *     opacity: 0, //can be any value between 0 and 1 (e.g. .5)
   *     easing: 'easeOut',
   *     duration: 500,
   *     remove: false,
   *     useDisplay: false
   * });
   * </pre>
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-fadeOut Original Ext JS documentation of 'fadeOut'
   * @see ext.fx.Anim
   */
  public native function fadeOut(options:Object = null):Element;

  /**
   * Looks at this node and then at parent nodes for a match of the passed simple selector.
   * @param simpleSelector The simple selector to test. See →<code>ext.dom.DomQuery</code>
   * for information about simple selectors.
   * @param limit The max depth to search as a number or an element which causes the upward traversal
   * to stop and is <b>not</b> considered for inclusion as the result.
   * (defaults to 50 || document.documentElement)
   * @param returnEl True to return a Ext.dom.Element object instead of
   * DOM node
   * @default false
   * @return The matching DOM node (or
   * Ext.dom.Element if <i>returnEl</i> is <i>true</i>). Or null if no match was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-findParent Original Ext JS documentation of 'findParent'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function findParent(simpleSelector:String, limit:* = undefined, returnEl:Boolean = false):*;

  /**
   * Looks at parent nodes for a match of the passed simple selector.
   * @param simpleSelector The simple selector to test. See →<code>ext.dom.DomQuery</code>
   * for information about simple selectors.
   * @param limit The max depth to search as a number or an element which causes the upward traversal
   * to stop and is <b>not</b> considered for inclusion as the result.
   * (defaults to 50 || document.documentElement)
   * @param returnEl True to return a Ext.dom.Element object instead of
   * DOM node
   * @default false
   * @return The matching DOM node (or
   * Ext.dom.Element if <i>returnEl</i> is <i>true</i>). Or null if no match was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-findParentNode Original Ext JS documentation of 'findParentNode'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function findParentNode(simpleSelector:String, limit:* = undefined, returnEl:Boolean = false):*;

  /**
   * Gets the first child, skipping text nodes
   * @param selector Find the next sibling that matches the passed simple selector.
   * See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom <code>true</code> to return a raw DOM node instead of
   * an Ext.dom.Element
   * @default false
   * @return The first child or null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-first Original Ext JS documentation of 'first'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function first(selector:String = null, returnDom:Boolean = false):*;

  /**
   * Try to focus the element either immediately or after a timeout
   * if <code>defer</code> argument is specified.
   * @param defer Milliseconds to defer the focus
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-focus Original Ext JS documentation of 'focus'
   */
  public native function focus(defer:Number = NaN):Element;

  [Deprecated(replacement="isFocusable", since="5.0.0")]
  /**
   * Checks whether this element can be focused.
   * @return True if the element is focusable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-focusable Original Ext JS documentation of 'focusable'
   */
  public native function focusable():Boolean;

  /**
   * Shows a ripple of exploding, attenuating borders to draw attention to an Element. Usage:
   * <pre>
   * // default: a single light blue ripple
   * el.frame();
   *
   * // custom: 3 red ripples lasting 3 seconds total
   * el.frame("#ff0000", 3, { duration: 3000 });
   *
   * // common config options shown with default values
   * el.frame("#C3DAF9", 1, {
   *     duration: 1000 // duration of each individual ripple.
   *     // Note: Easing is not configurable and will be ignored if included
   * });
   * </pre>
   * @param color The hex color value for the border.
   * @default '#C3DAF9'
   * @param count The number of ripples to display.
   * @default 1
   * @param obj Object literal with any of the →<code>ext.fx.Anim</code> config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-frame Original Ext JS documentation of 'frame'
   * @see ext.fx.Anim
   */
  public native function frame(color:String = '#C3DAF9', count:Number = 1, obj:Object = null):Element;

  /**
   * @inheritDoc
   */
  public native function getAlignToXY(alignToEl:*, position:String = "tl-bl?", offsets:Array = null):Array;

  /**
   * @inheritDoc
   */
  public native function getAnchorXY(anchor:String = 'tl', local:Boolean = false, size:Object = null):Array;

  /**
   * Returns the value of an attribute from the element's underlying DOM node.
   * @param name The attribute name.
   * @param namespace The namespace in which to look for the attribute.
   * @return The attribute value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getAttribute Original Ext JS documentation of 'getAttribute'
   */
  public native function getAttribute(name:String, namespace:String = null):String;

  [Deprecated(replacement="getAttribute", since="5.0.0")]
  /**
   * Returns the value of a namespaced attribute from the element's underlying
   * DOM node.
   * @param namespace The namespace in which to look for the attribute
   * @param name The attribute name
   * @return The attribute value
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getAttributeNS Original Ext JS documentation of 'getAttributeNS'
   */
  public native function getAttributeNS(namespace:String, name:String):String;

  /**
   * Returns an object containing a map of all attributes of this element's DOM node.
   * @return Key/value pairs of attribute names and their values.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getAttributes Original Ext JS documentation of 'getAttributes'
   */
  public native function getAttributes():Object;

  /**
   * Gets the width of the border(s) for the specified side(s)
   * @param side Can be t, l, r, b or any combination of those to add
   * multiple values. For example, passing <code>'lr'</code> would get the border <b>l</b>eft
   * width + the border <b>r</b>ight width.
   * @return The width of the sides passed added together
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getBorderWidth Original Ext JS documentation of 'getBorderWidth'
   */
  public native function getBorderWidth(side:String):Number;

  /**
   * Gets the bottom Y coordinate of the element (element Y position + element height)
   * @param local True to get the local css position instead of page
   * coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getBottom Original Ext JS documentation of 'getBottom'
   */
  public native function getBottom(local:Boolean = false):Number;

  /**
   * @inheritDoc
   */
  public native function getBox(contentBox:Boolean = false, local:Boolean = false):Object;

  /**
   * Returns a child element of this element given its <code>→id</code>.
   * @param id The id of the desired child element.
   * @param asDom True to return the DOM element, false to return a
   * wrapped Element object.
   * @default false
   * @return The child element (or HTMLElement if
   * <i>asDom</i> is <i>true</i>). Or null if no match was found.
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getById Original Ext JS documentation of 'getById'
   */
  public native function getById(id:String, asDom:Boolean = false):*;

  [ArrayElementType("Number")]
  [Deprecated(replacement="getAlignToXY", since="5.0.0")]
  /**
   * Calculates the x, y to center this element on the screen
   * @return The x, y values [x, y]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getCenterXY Original Ext JS documentation of 'getCenterXY'
   */
  public native function getCenterXY():Array;

  /**
   * Returns an object holding as properties this element's CSS classes. The object
   * can be modified to effect arbitrary class manipulations that won't immediately
   * go to the DOM. When completed, the DOM node can be updated by calling
   * →<code>setClassMap()</code>. The values of the properties should either
   * be set to truthy values (such as <code>1</code> or <code>true</code>) or removed via <code>delete</code>.
   * <pre>
   *  var classes = el.getClassMap();
   *
   *  // Add the 'foo' class:
   *  classes.foo = 1;
   *
   *  // Remove the 'bar' class:
   *  delete classes.bar;
   *
   *  // Update the DOM in one step:
   *  el.setClassMap(classes);
   * </pre>
   * @since 6.5.0
   * @see #setClassMap()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getClassMap Original Ext JS documentation of 'getClassMap'
   */
  public native function getClassMap():Object;

  /**
   * @inheritDoc
   */
  public native function getClientRegion():Region;

  [Deprecated(replacement="getHeight", since="5.0.0")]
  /**
   * Returns either the offsetHeight or the height of this element based on CSS
   * height adjusted by padding or borders when needed to simulate offsetHeight
   * when offsets aren't available. This may not work on display:none elements
   * if a height has not been set using CSS.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getComputedHeight Original Ext JS documentation of 'getComputedHeight'
   */
  public native function getComputedHeight():Number;

  [Deprecated(replacement="getWidth", since="5.0.0")]
  /**
   * Returns either the offsetWidth or the width of this element based on CSS
   * width adjusted by padding or borders when needed to simulate offsetWidth
   * when offsets aren't available. This may not work on display:none elements
   * if a width has not been set using CSS.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getComputedWidth Original Ext JS documentation of 'getComputedWidth'
   */
  public native function getComputedWidth():Number;

  /**
   * @inheritDoc
   */
  public native function getConstrainRegion():Region;

  /**
   * @inheritDoc
   */
  public native function getConstrainVector(constrainTo:* = undefined, proposedPosition:Array = null, proposedSize:Array = null):*;

  [Deprecated(replacement="getHtml", since="5.0.0")]
  /**
   * Returns the <code>innerHTML</code> of an Element or an empty string if the element's
   * dom no longer exists.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getHTML Original Ext JS documentation of 'getHTML'
   */
  public native function getHTML():String;

  /**
   * Returns the offset height of the element.
   * @param contentHeight <code>true</code> to get the height minus borders and padding.
   * @param preciseHeight <code>true</code> to get the precise height
   * @return The element's height.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getHeight Original Ext JS documentation of 'getHeight'
   */
  public native function getHeight(contentHeight:Boolean = false, preciseHeight:Boolean = false):Number;

  /**
   * Returns the <code>innerHTML</code> of an Element or an empty string if the element's
   * dom no longer exists.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getHtml Original Ext JS documentation of 'getHtml'
   */
  public native function getHtml():String;

  /**
   * Gets the left X coordinate
   * @param local True to get the local css position instead of
   * page coordinate
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getLeft Original Ext JS documentation of 'getLeft'
   */
  public native function getLeft(local:Boolean = false):Number;

  /**
   * Gets this element's →<code>ext.ElementLoader</code>
   * @return The loader
   * @see ext.ElementLoader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getLoader Original Ext JS documentation of 'getLoader'
   */
  public native function getLoader():ElementLoader;

  /**
   * @inheritDoc
   */
  public native function getLocalX():Number;

  /**
   * @inheritDoc
   */
  public native function getLocalXY():Array;

  /**
   * @inheritDoc
   */
  public native function getLocalY():Number;

  /**
   * Returns an object with properties top, left, right and bottom representing the margins
   * of this element unless sides is passed, then it returns the calculated width
   * of the sides (see →<code>getPadding()</code>).
   * @param sides Any combination of 'l', 'r', 't', 'b' to get the sum
   * of those sides.
   * @see #getPadding()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getMargin Original Ext JS documentation of 'getMargin'
   */
  public native function getMargin(sides:String = null):*;

  /**
   * @inheritDoc
   */
  public native function getOffsetsTo(offsetsTo:*):Array;

  /**
   * Gets the width of the padding(s) for the specified side(s).
   * @param side Can be t, l, r, b or any combination of those to add
   * multiple values. For example, passing <code>'lr'</code> would get the padding <b>l</b>eft +
   * the padding <b>r</b>ight.
   * @return The padding of the sides passed added together.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getPadding Original Ext JS documentation of 'getPadding'
   */
  public native function getPadding(side:String):Number;

  [Deprecated(replacement="getBox", since="5.0.0")]
  /**
   * Returns an object defining the area of this Element which can be passed to
   * →<code>ext.util.Positionable.setBox()</code> to set another Element's size/location
   * to match this element.
   * @param getRegion If true an Ext.util.Region will be returned
   * @return box An object in the following format:
   * <pre>
   * {
   *     left: &lt;Element's X position&gt;,
   *     top: &lt;Element's Y position&gt;,
   *     width: &lt;Element's width&gt;,
   *     height: &lt;Element's height&gt;,
   *     bottom: &lt;Element's lower bound&gt;,
   *     right: &lt;Element's rightmost bound&gt;
   * }
   * </pre>
   * <p>The returned object may also be addressed as an Array where index 0 contains
   * the X position and index 1 contains the Y position. So the result may also be
   * used for →<code>setXY()</code></p>
   * @see ext.util.Positionable#setBox()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getPageBox Original Ext JS documentation of 'getPageBox'
   * @see #setXY()
   */
  public native function getPageBox(getRegion:Boolean = false):*;

  /**
   * Gets an object with all CSS positioning properties. Useful along with
   * <code>→setPositioning()</code> to get snapshot before performing an update and then restoring
   * the element.
   * @param autoPx true to return pixel values for "auto" styles.
   * @default false
   * @see #setPositioning()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getPositioning Original Ext JS documentation of 'getPositioning'
   */
  public native function getPositioning(autoPx:Boolean = false):Object;

  /**
   * @inheritDoc
   */
  public native function getRegion(contentBox:Boolean = false, local:Boolean = false):Region;

  /**
   * Gets the right X coordinate of the element (element X position + element width)
   * @param local True to get the local css position instead of page
   * coordinates
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getRight Original Ext JS documentation of 'getRight'
   */
  public native function getRight(local:Boolean = false):Number;

  /**
   * Returns the current scroll position of the element.
   * @return An object containing the scroll position in the format
   * <code>{left: (scrollLeft), top: (scrollTop)}</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getScroll Original Ext JS documentation of 'getScroll'
   */
  public native function getScroll():Object;

  /**
   * Gets the left scroll position
   * @return The left scroll position
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getScrollLeft Original Ext JS documentation of 'getScrollLeft'
   */
  public native function getScrollLeft():Number;

  /**
   * Gets the top scroll position
   * @return The top scroll position
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getScrollTop Original Ext JS documentation of 'getScrollTop'
   */
  public native function getScrollTop():Number;

  /**
   * Returns the size of the element.
   * @param contentSize <code>true</code> to get the width/size minus borders and padding.
   * @return An object containing the element's size:
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getSize Original Ext JS documentation of 'getSize'
   */
  public native function getSize(contentSize:Boolean = false):Object;

  /**
   * Returns a named style property based on computed/currentStyle (primary) and
   * inline-style if primary is not available.
   * @param property The style property (or multiple property names
   * in an array) whose value is returned.
   * @param inline if <code>true</code> only inline styles will be returned.
   * @default false
   * @return The current value of the style property for this element
   * (or a hash of named style values if multiple property arguments are requested).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getStyle Original Ext JS documentation of 'getStyle'
   */
  public native function getStyle(property:*, inline:Boolean = false):*;

  [Deprecated(replacement="getSize", since="5.0.0")]
  /**
   * Returns the dimensions of the element available to lay content out in.
   * <p>getStyleSize utilizes prefers style sizing if present, otherwise it chooses
   * the larger of offsetHeight/clientHeight and offsetWidth/clientWidth.
   * To obtain the size excluding scrollbars, use getViewSize.</p>
   * <p>Sizing of the document body is handled at the adapter level which handles
   * special cases for IE and strict modes, etc.</p>
   * @return Object describing width and height.
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getStyleSize Original Ext JS documentation of 'getStyleSize'
   */
  public native function getStyleSize():Object;

  /**
   * Returns the selection range of an input element as an array of three values...
   * <pre>
   *  [ start, end, direction ]
   * </pre>
   * <p>These have the same meaning as the parameters to <code>→selectText()</code>.</p>
   * @since 6.5.0
   * @see #selectText()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getTextSelection Original Ext JS documentation of 'getTextSelection'
   */
  public native function getTextSelection():Array;

  /**
   * Returns the width in pixels of the passed text, or the width of the text in this Element.
   * @param text The text to measure. Defaults to the innerHTML of the element.
   * @param min The minumum value to return.
   * @param max The maximum value to return.
   * @return The text width in pixels.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getTextWidth Original Ext JS documentation of 'getTextWidth'
   */
  public native function getTextWidth(text:String, min:Number = NaN, max:Number = NaN):Number;

  /**
   * Gets the top Y coordinate
   * @param local True to get the local css position instead of page
   * coordinates
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getTop Original Ext JS documentation of 'getTop'
   */
  public native function getTop(local:Boolean = false):Number;

  /**
   * Returns this element's touch action. (see →<code>setTouchAction()</code>)
   * <p>The returned object is shared and should not be mutated.</p>
   * @see #setTouchAction()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getTouchAction Original Ext JS documentation of 'getTouchAction'
   */
  public native function getTouchAction():Object;

  /**
   * Returns the value of the <code>value</code> attribute.
   * @param asNumber <code>true</code> to parse the value as a number.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getValue Original Ext JS documentation of 'getValue'
   */
  public native function getValue(asNumber:Boolean):*;

  /**
   * @inheritDoc
   */
  public native function getViewRegion():Region;

  /**
   * Returns the dimensions of the element available to lay content out in. For
   * most elements this is the clientHeight/clientWidth. If the element is
   * the document/document.body the window's innerHeight/innerWidth is returned
   * <p>If the element (or any ancestor element) has CSS style <code>display: none</code>, the
   * dimensions will be zero.</p>
   * @return Object describing width and height.
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getViewSize Original Ext JS documentation of 'getViewSize'
   */
  public native function getViewSize():Object;

  /**
   * Returns the offset width of the element.
   * @param contentWidth <code>true</code> to get the width minus borders and padding.
   * @param preciseWidth <code>true</code> to get the precise width
   * @return The element's width.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getWidth Original Ext JS documentation of 'getWidth'
   */
  public native function getWidth(contentWidth:Boolean = false, preciseWidth:Boolean = false):Number;

  /**
   * Gets element X position in page coordinates
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getX Original Ext JS documentation of 'getX'
   */
  public native function getX():Number;

  /**
   * Gets element X and Y positions in page coordinates
   * @return [x, y]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getXY Original Ext JS documentation of 'getXY'
   */
  public native function getXY():Array;

  /**
   * Gets element Y position in page coordinates
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getY Original Ext JS documentation of 'getY'
   */
  public native function getY():Number;

  /**
   * Returns this element's z-index
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-getZIndex Original Ext JS documentation of 'getZIndex'
   */
  public native function getZIndex():Number;

  /**
   * Slides the element while fading it out of view. An anchor point can be optionally passed
   * to set the ending point of the effect. Usage:
   * <pre>
   * // default: slide the element downward while fading out
   * el.ghost();
   *
   * // custom: slide the element out to the right with a 2-second duration
   * el.ghost('r', { duration: 2000 });
   *
   * // common config options shown with default values
   * el.ghost('b', {
   *     easing: 'easeOut',
   *     duration: 500
   * });
   * </pre>
   * @param anchor One of the valid →<code>ext.fx.Anim</code> anchor positions
   * (defaults to bottom: 'b')
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-ghost Original Ext JS documentation of 'ghost'
   * @see ext.fx.Anim
   */
  public native function ghost(anchor:String = null, options:Object = null):Element;

  /**
   * Checks if the specified CSS class exists on this element's DOM node.
   * @param name The CSS class to check for.
   * @return <code>true</code> if the class exists, else <code>false</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-hasCls Original Ext JS documentation of 'hasCls'
   */
  public native function hasCls(name:String):Boolean;

  /**
   * Hide this element - Uses display mode to determine whether to use "display",
   * "visibility", or "offsets". See →<code>setVisible()</code>.
   * @param animate true for the default animation or a standard
   * Element animation config object
   * @return this
   * @see #setVisible()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-hide Original Ext JS documentation of 'hide'
   */
  public native function hide(animate:* = undefined):Element;

  /**
   * Highlights the Element by setting a color (applies to the background-color by default,
   * but can be changed using the "attr" config option) and then fading back to the original
   * color. If no original color is available, you should provide the "endColor" config option
   * which will be cleared after the animation. Usage:
   * <pre>
   * // default: highlight background to yellow
   * el.highlight();
   *
   * // custom: highlight foreground text to blue for 2 seconds
   * el.highlight("0000ff", { attr: 'color', duration: 2000 });
   *
   * // common config options shown with default values
   * el.highlight("ffff9c", {
   *     // can be any valid CSS property (attribute) that supports a color value
   *     attr: "backgroundColor",
   *     endColor: (current color) or "ffffff",
   *     easing: 'easeIn',
   *     duration: 1000
   * });
   * </pre>
   * @param color The highlight color. Should be a 6 char hex color
   * without the leading # (defaults to yellow: 'ffff9c')
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-highlight Original Ext JS documentation of 'highlight'
   * @see ext.fx.Anim
   */
  public native function highlight(color:String = null, options:Object = null):Element;

  /**
   * Sets up event handlers to call the passed functions when the mouse is moved into and
   * out of the Element.
   * @param overFn The function to call when the mouse enters the Element.
   * @param outFn The function to call when the mouse leaves the Element.
   * @param scope The scope (<code>this</code> reference) in which the functions are executed.
   * Defaults to the Element's DOM element.
   * @param options Options for the listener. See
   * <i>the options parameter</i> (→<code>ext.util.Observable.addListener()</code>).
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-hover Original Ext JS documentation of 'hover'
   * @see ext.util.Observable#addListener()
   */
  public native function hover(overFn:Function, outFn:Function, scope:Object = null, options:Object = null):Element;

  /**
   * Returns the index of the given element in the <code>childNodes</code> of this element. If
   * not present, <code>-1</code> is returned.
   * @since 6.5.0
   * @param childEl The potential child element.
   * @return The index of <code>childEl</code> in <code>childNodes</code> or <code>-1</code> if not found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-indexOf Original Ext JS documentation of 'indexOf'
   */
  public native function indexOf(childEl:*):Number;

  /**
   * Initializes a →<code>ext.dd.DD</code> drag drop object for this element.
   * @param group The group the DD object is member of
   * @param config The DD config object
   * @param overrides An object containing methods to override/implement
   * on the DD object
   * @return The DD object
   * @see ext.dd.DD
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-initDD Original Ext JS documentation of 'initDD'
   */
  public native function initDD(group:String, config:Object, overrides:Object):DD;

  /**
   * Initializes a →<code>ext.dd.DDProxy</code> object for this element.
   * @param group The group the DDProxy object is member of
   * @param config The DDProxy config object
   * @param overrides An object containing methods to override/implement
   * on the DDProxy object
   * @return The DDProxy object
   * @see ext.dd.DDProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-initDDProxy Original Ext JS documentation of 'initDDProxy'
   */
  public native function initDDProxy(group:String, config:Object, overrides:Object):DDProxy;

  /**
   * Initializes a →<code>ext.dd.DDTarget</code> object for this element.
   * @param group The group the DDTarget object is member of
   * @param config The DDTarget config object
   * @param overrides An object containing methods to override/implement
   * on the DDTarget object
   * @return The DDTarget object
   * @see ext.dd.DDTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-initDDTarget Original Ext JS documentation of 'initDDTarget'
   */
  public native function initDDTarget(group:String, config:Object, overrides:Object):DDTarget;

  /**
   * Inserts this element after the passed element in the DOM.
   * @param el The element to insert after.
   * The <code>→id</code> of the node, a DOM Node or an existing Element.
   * @return This element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-insertAfter Original Ext JS documentation of 'insertAfter'
   * @see #id
   */
  public native function insertAfter(el:*):Element;

  /**
   * Inserts this element before the passed element in the DOM.
   * @param el The element before which this element
   * will be inserted. The id of the node, a DOM Node or an existing Element.
   * @return This element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-insertBefore Original Ext JS documentation of 'insertBefore'
   */
  public native function insertBefore(el:*):Element;

  /**
   * Inserts (or creates) an element as the first child of this element
   * @param el The id or element to insert
   * or a DomHelper config to create and insert
   * @param returnDom True to return the raw DOM element instead
   * of Ext.dom.Element
   * @default false
   * @return The new child element (or HTMLElement if
   * <i>returnDom</i> is <i>true</i>).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-insertFirst Original Ext JS documentation of 'insertFirst'
   */
  public native function insertFirst(el:*, returnDom:Boolean = false):*;

  /**
   * Inserts an html fragment into this element
   * @param where Where to insert the html in relation to this element - beforeBegin,
   * afterBegin, beforeEnd, afterEnd. See →<code>ext.dom.DomHelper.insertHtml()</code> for details.
   * @param html The HTML fragment
   * @param returnEl True to return an Ext.dom.Element
   * @default false
   * @return The inserted node (or nearest related if more than
   * 1 inserted)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-insertHtml Original Ext JS documentation of 'insertHtml'
   * @see ext.dom.SDomHelper#insertHtml() ext.dom.DomHelper.insertHtml()
   */
  public native function insertHtml(where:String, html:String, returnEl:Boolean = false):*;

  /**
   * Inserts (or creates) the passed element (or DomHelper config) as a sibling of this
   * element
   * @param el The id, element to insert
   * or a DomHelper config to create and insert <i>or</i> an array of any of those.
   * @param where 'before' or 'after'
   * @default 'before'
   * @param returnDom True to return the raw DOM element instead of
   * Ext.dom.Element
   * @default false
   * @return The inserted Ext.dom.Element (or
   * HTMLElement if <i>returnDom</i> is <i>true</i>). If an array is passed, the last
   * inserted element is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-insertSibling Original Ext JS documentation of 'insertSibling'
   */
  public native function insertSibling(el:*, where:String = 'before', returnDom:Boolean = false):*;

  /**
   * Returns <code>true</code> if this element is an ancestor of the passed element
   * @param el The element or id of the element
   * to search for in this elements descendants.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isAncestor Original Ext JS documentation of 'isAncestor'
   */
  public native function isAncestor(el:*):Boolean;

  [Deprecated(message="This method is deprecated.  Browsers that do not\nsupport border-box (IE6/7 strict mode) are no longer supported.\n", since="5.0.0")]
  /**
   * Returns true if this element uses the border-box-sizing model.
   * This method is deprecated as of version 5.0 because border-box sizing
   * is forced upon all elements via a style sheet rule, and the browsers
   * that do not support border-box (IE6/7 strict mode) are no longer supported.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isBorderBox Original Ext JS documentation of 'isBorderBox'
   */
  public native function isBorderBox():Boolean;

  [Deprecated(message="use element.isStyle(&#39;display&#39;, &#39;none&#39;);\n", since="5.0.0")]
  /**
   * Returns true if display is not "none"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isDisplayed Original Ext JS documentation of 'isDisplayed'
   */
  public native function isDisplayed():Boolean;

  /**
   * Checks whether this element can be focused programmatically or by clicking.
   * To check if an element is in the document tab flow, use →<code>isTabbable()</code>.
   * @return True if the element is focusable
   * @see #isTabbable()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isFocusable Original Ext JS documentation of 'isFocusable'
   */
  public native function isFocusable(skipVisibility:*):Boolean;

  /**
   * Returns <code>true</code> if this Element is an input field, or is editable in any way.
   * @return <code>true</code> if this Element is an input field, or is editable in any way.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isInputField Original Ext JS documentation of 'isInputField'
   */
  public native function isInputField():Boolean;

  /**
   * Returns true if this element is masked. Also re-centers any displayed message
   * within the mask.
   * @param deep Go up the DOM hierarchy to determine if any parent
   * element is masked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isMasked Original Ext JS documentation of 'isMasked'
   */
  public native function isMasked(deep:Boolean = false):Boolean;

  /**
   * Returns true if this element is scrollable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isScrollable Original Ext JS documentation of 'isScrollable'
   */
  public native function isScrollable():Boolean;

  /**
   * Checks if the current value of a style is equal to a given value.
   * @param style property whose value is returned.
   * @param val to check against.
   * @return <code>true</code> for when the current value equals the given value.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isStyle Original Ext JS documentation of 'isStyle'
   */
  public native function isStyle(style:String, val:String):Boolean;

  /**
   * Checks whether this element participates in the sequential focus navigation,
   * and can be reached by using Tab key.
   * @param includeHidden pass <code>true</code> if hidden, or unattached elements
   * should be returned.
   * @default false
   * @return True if the element is tabbable.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isTabbable Original Ext JS documentation of 'isTabbable'
   */
  public native function isTabbable(includeHidden:Boolean = false):Boolean;

  [Deprecated(message="This method is deprecated.\n", since="5.0.0")]
  /**
   * Returns <code>true</code> if the value of the given property is visually transparent.
   * This may be due to a 'transparent' style value or an rgba value with 0
   * in the alpha component.
   * @param prop The style property whose value is to be tested.
   * @return <code>true</code> if the style property is visually transparent.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isTransparent Original Ext JS documentation of 'isTransparent'
   */
  public native function isTransparent(prop:String):Boolean;

  /**
   * Checks whether the element is currently visible using both visibility and display
   * properties.
   * @param deep True to walk the dom and see if parent elements are hidden.
   * If false, the function only checks the visibility of the element itself and it may return
   * <code>true</code> even though a parent is not visible.
   * @default false
   * @param mode Bit flag indicating which CSS properties to test:
   * <ul>
   * <li><code>1</code> - check display only</li>
   * <li><code>2</code> - check visibility only</li>
   * <li><code>3</code> - check both visibility and display</li>
   * </ul>
   * @default 3
   * @return <code>true</code> if the element is currently visible, else <code>false</code>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-isVisible Original Ext JS documentation of 'isVisible'
   */
  public native function isVisible(deep:Boolean = false, mode:Number = 3):Boolean;

  /**
   * Gets the last child, skipping text nodes
   * @param selector Find the previous sibling that matches the passed simple
   * selector. See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom <code>true</code> to return a raw DOM node instead of an
   * Ext.dom.Element
   * @default false
   * @return The last child Ext.dom.Element (or
   * HTMLElement if <i>returnDom</i> is <i>true</i>). Or null if no match is found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-last Original Ext JS documentation of 'last'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function last(selector:String = null, returnDom:Boolean = false):*;

  /**
   * Direct access to the Ext.ElementLoader →<code>ext.ElementLoader.load()</code> method.
   * The method takes the same object parameter as →<code>ext.ElementLoader.load()</code>
   * @param options a options object for Ext.ElementLoader
   * →<code>ext.ElementLoader.load()</code>
   * @return this
   * @see ext.ElementLoader#load()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-load Original Ext JS documentation of 'load'
   */
  public native function load(options:*):Element;

  /**
   * Puts a mask over this element to disable user interaction.
   * This method can only be applied to elements which accept child nodes. Use
   * →<code>unmask()</code> to remove the mask.
   * @param msg A message to display in the mask
   * @param msgCls A css class to apply to the msg element
   * @return The mask element
   * @see #unmask()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-mask Original Ext JS documentation of 'mask'
   */
  public native function mask(msg:String = null, msgCls:String = null):Element;

  /**
   * Returns <code>true</code> if this element matches the passed simple selector
   * (e.g. 'div.some-class' or 'span:first-child').
   * @param selector The simple selector to test or a function
   * which is passed candidate nodes, and should return <code>true</code> for nodes which match.
   * @return <code>true</code> if this element matches the selector, else <code>false</code>.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-is Original Ext JS documentation of 'is'
   */
  public native function matches(selector:*):Boolean;

  /**
   * Monitors this Element for the mouse leaving. Calls the function after the specified delay
   * only if the mouse was not moved back into the Element within the delay. If the mouse
   * <i>was</i> moved back in, the function is not called.
   * @param delay The delay <b>in milliseconds</b> to wait for possible mouse re-entry
   * before calling the handler function.
   * @param handler The function to call if the mouse remains outside of this
   * Element for the specified time.
   * @param scope The scope (<code>this</code> reference) in which the handler function
   * executes. Defaults to this Element.
   * @return The listeners object which was added to this element so that monitoring
   * can be stopped. Example usage:
   * <pre>
   * // Hide the menu if the mouse moves out for 250ms or more
   * this.mouseLeaveMonitor = this.menuEl.monitorMouseLeave(250, this.hideMenu, this);
   *
   * ...
   * // Remove mouseleave monitor on menu destroy
   * this.mouseLeaveMonitor.destroy();
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-monitorMouseLeave Original Ext JS documentation of 'monitorMouseLeave'
   */
  public native function monitorMouseLeave(delay:Number, handler:Function, scope:Object = null):Object;

  /**
   * @inheritDoc
   */
  public native function move(direction:String, distance:Number, animate:* = undefined):void;

  [Deprecated(replacement="setXY", since="4.2.0")]
  /**
   * Sets the position of the element in page coordinates.
   * @param x X value for new position (coordinates are page-based)
   * @param y Y value for new position (coordinates are page-based)
   * @param animate True for the default animation,
   * or a standard Element animation config object
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-moveTo Original Ext JS documentation of 'moveTo'
   */
  public native function moveTo(x:Number, y:Number, animate:* = undefined):Element;

  /**
   * Gets the next sibling, skipping text nodes
   * @param selector Find the next sibling that matches the passed simple selector.
   * See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom <code>true</code> to return a raw dom node instead of an
   * Ext.dom.Element
   * @default false
   * @return The next sibling Ext.dom.Element (or
   * HTMLElement if <i>asDom</i> is <i>true</i>). Or null if no match is found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-next Original Ext JS documentation of 'next'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function next(selector:String = null, returnDom:Boolean = false):*;

  /**
   * Gets the parent node for this element, optionally chaining up trying to match a selector
   * @param selector Find a parent node that matches the passed simple selector.
   * See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom True to return a raw dom node instead of an
   * Ext.dom.Element
   * @default false
   * @return The parent node (Ext.dom.Element or
   * HTMLElement if <i>returnDom</i> is <i>true</i>). Or null if no match is found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-parent Original Ext JS documentation of 'parent'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function parent(selector:String = null, returnDom:Boolean = false):*;

  [Deprecated(replacement="animate", since="4.0")]
  /**
   * Creates a pause before any subsequent queued effects begin. If there are
   * no effects queued after the pause it will have no effect. Usage:
   * <pre>
   * el.pause(1);
   * </pre>
   * @param ms The length of time to pause (in milliseconds)
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-pause Original Ext JS documentation of 'pause'
   */
  public native function pause(ms:Number):Element;

  /**
   * Initializes positioning on this element. If a desired position is not passed,
   * it will make the the element positioned relative IF it is not already positioned.
   * @param pos Positioning to use "relative", "absolute" or "fixed"
   * @param zIndex The zIndex to apply
   * @param x Set the page X position
   * @param y Set the page Y position
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-position Original Ext JS documentation of 'position'
   */
  public native function position(pos:String = null, zIndex:Number = NaN, x:Number = NaN, y:Number = NaN):void;

  /**
   * Gets the previous sibling, skipping text nodes
   * @param selector Find the previous sibling that matches the passed simple
   * selector. See →<code>ext.dom.DomQuery</code> for information about simple selectors.
   * @param returnDom <code>true</code> to return a raw DOM node instead of an
   * Ext.dom.Element
   * @default false
   * @return The previous sibling (Ext.dom.Element or
   * HTMLElement if <i>returnDom</i> is <i>true</i>). Or null if no match is found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-prev Original Ext JS documentation of 'prev'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function prev(selector:String = null, returnDom:Boolean = false):*;

  /**
   * Fades the element out while slowly expanding it in all directions. When the effect
   * is completed, the element will be hidden (visibility = 'hidden') but block elements
   * will still take up space in the document. Usage:
   * <pre>
   * // default
   * el.puff();
   *
   * // common config options shown with default values
   * el.puff({
   *     easing: 'easeOut',
   *     duration: 500,
   *     useDisplay: false
   * });
   * </pre>
   * @param obj Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-puff Original Ext JS documentation of 'puff'
   * @see ext.fx.Anim
   */
  public native function puff(obj:Object = null):Element;

  [Deprecated(replacement="clearListeners", since="5.0.0")]
  /**
   * Removes all listeners for this object including the managed listeners
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-purgeAllListeners Original Ext JS documentation of 'purgeAllListeners'
   */
  public native function purgeAllListeners():Element;

  /**
   * Selects child nodes based on the passed CSS selector.
   * Delegates to document.querySelectorAll. More information can be found at
   * <a href="http://www.w3.org/TR/css3-selectors/">http://www.w3.org/TR/css3-selectors/</a>
   * <p>All selectors, attribute filters and pseudos below can be combined infinitely
   * in any order. For example <code>div.foo:nth-child(odd)[&#64;foo=bar].bar:first</code> would be
   * a perfectly valid selector.</p>
   * <p><b><i>Element Selectors:</i></b></p>
   * <ul>
   * <li>&#42; any element</li>
   * <li>E an element with the tag E</li>
   * <li>E F All descendant elements of E that have the tag F</li>
   * <li>E &gt; F or E/F all direct children elements of E that have the tag F</li>
   * <li>E + F all elements with the tag F that are immediately preceded by an element
   * with the tag E</li>
   * <li>E ~ F all elements with the tag F that are preceded by a sibling element with the tag E</li>
   * </ul>
   * <p><b><i>Attribute Selectors:</i></b></p>
   * <p>The use of &#64; and quotes are optional. For example, div[&#64;foo='bar'] is also a valid
   * attribute selector.</p>
   * <ul>
   * <li>E[foo] has an attribute "foo"</li>
   * <li>E[foo=bar] has an attribute "foo" that equals "bar"</li>
   * <li>E[foo^=bar] has an attribute "foo" that starts with "bar"</li>
   * <li>E[foo$=bar] has an attribute "foo" that ends with "bar"</li>
   * <li>E[foo&#42;=bar] has an attribute "foo" that contains the substring "bar"</li>
   * <li>E[foo%=2] has an attribute "foo" that is evenly divisible by 2</li>
   * <li>E[foo!=bar] has an attribute "foo" that does not equal "bar"</li>
   * </ul>
   * <p><b><i>Pseudo Classes:</i></b></p>
   * <ul>
   * <li>E:first-child E is the first child of its parent</li>
   * <li>E:last-child E is the last child of its parent</li>
   * <li>E:nth-child(n) E is the nth child of its parent (1 based as per the spec)</li>
   * <li>E:nth-child(odd) E is an odd child of its parent</li>
   * <li>E:nth-child(even) E is an even child of its parent</li>
   * <li>E:only-child E is the only child of its parent</li>
   * <li>E:checked E is an element that is has a checked attribute that is true (e.g. a radio
   * or checkbox)</li>
   * <li>E:first the first E in the resultset</li>
   * <li>E:last the last E in the resultset</li>
   * <li>E:nth(n) the nth E in the resultset (1 based)</li>
   * <li>E:odd shortcut for :nth-child(odd)</li>
   * <li>E:even shortcut for :nth-child(even)</li>
   * <li>E:not(S) an E element that does not match simple selector S</li>
   * <li>E:has(S) an E element that has a descendant that matches simple selector S</li>
   * <li>E:next(S) an E element whose next sibling matches simple selector S</li>
   * <li>E:prev(S) an E element whose previous sibling matches simple selector S</li>
   * <li>E:any(S1|S2|S2) an E element which matches any of the simple selectors S1, S2 or S3</li>
   * </ul>
   * <p><b><i>CSS Value Selectors:</i></b></p>
   * <ul>
   * <li>E{display=none} CSS value "display" that equals "none"</li>
   * <li>E{display^=none} CSS value "display" that starts with "none"</li>
   * <li>E{display$=none} CSS value "display" that ends with "none"</li>
   * <li>E{display&#42;=none} CSS value "display" that contains the substring "none"</li>
   * <li>E{display%=2} CSS value "display" that is evenly divisible by 2</li>
   * <li>E{display!=none} CSS value "display" that does not equal "none"</li>
   * </ul>
   * @param selector The CSS selector.
   * @param asDom <code>false</code> to return an array of Ext.dom.Element
   * @default true
   * @return An Array of elements (
   * HTMLElement or Ext.dom.Element if <i>asDom</i> is <i>false</i>) that match the selector.
   * If there are no matches, an empty Array is returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-query Original Ext JS documentation of 'query'
   */
  public native function query(selector:String, asDom:Boolean = true):Array;

  /**
   * Adds one or more CSS classes to this element and removes the same class(es) from
   * all siblings.
   * @param className The CSS class to add, or an array of classes.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-radioCls Original Ext JS documentation of 'radioCls'
   */
  public native function radioCls(className:*):Element;

  [Deprecated(replacement="destroy", since="5.0.0")]
  /**
   * Destroys this element by removing it from the cache, removing its DOM reference,
   * and removing all of its event listeners.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove():void;

  [Deprecated(replacement="clearListeners", since="5.0.0")]
  /**
   * Removes all listeners for this object including the managed listeners
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-removeAllListeners Original Ext JS documentation of 'removeAllListeners'
   */
  public native function removeAllListeners():Element;

  /**
   * @inheritDoc
   */
  public native function removeAnchor():void;

  /**
   * Removes the given CSS class(es) from this Element.
   * @param names The CSS classes to remove separated by space,
   * or an array of classes
   * @param prefix Prefix to prepend to each class. The separator <code>-</code> will be
   * appended to the prefix.
   * @param suffix Suffix to append to each class. The separator <code>-</code> will be
   * prepended to the suffix.
   * return {Ext.dom.Element} this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-removeCls Original Ext JS documentation of 'removeCls'
   */
  public native function removeCls(names:*, prefix:String = null, suffix:String = null):void;

  /**
   * Forces the browser to repaint this element.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-repaint Original Ext JS documentation of 'repaint'
   */
  public native function repaint(cls:*, state:*):Element;

  /**
   * Replaces the passed element with this element
   * @param el The element to replace.
   * The id of the node, a DOM Node or an existing Element.
   * @param destroy <code>false</code> to prevent destruction of the replaced
   * element
   * @default true
   * @return This element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-replace Original Ext JS documentation of 'replace'
   */
  public native function replace(el:*, destroy:Boolean = true):Element;

  /**
   * Replaces one or more CSS classes on this element with other classes. If the old
   * name does not exist, the new name will simply be added.
   * @param remove The CSS class(es) to be removed.
   * @param add The CSS class(es) to be added.
   * @param prefix The string to prepend to each class name.
   * @param suffix The string to append to each class name.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-replaceCls Original Ext JS documentation of 'replaceCls'
   */
  public native function replaceCls(remove:* = undefined, add:* = undefined, prefix:String = null, suffix:String = null):Element;

  /**
   * Replaces this element with the passed element
   * @param el The new element (id of the
   * node, a DOM Node or an existing Element) or a DomHelper config of an element to create
   * @return This element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-replaceWith Original Ext JS documentation of 'replaceWith'
   */
  public native function replaceWith(el:*):Element;

  /**
   * Creates a ripple effect over this element. The element should be positioned
   * (either <code>relative</code> or <code>absolute</code>) prior to calling this method.
   * @param event The event to use for ripple
   * positioning.
   * @param options Ripple options object or color to use for ripple
   * <ul>
   * <li><code>color:String</code> (optional) —
   * The color to use for the ripple effect or
   * <code>'default'</code> to use the stylesheet default color
   * →<code>null.style:$ripple-background-color</code>. When no <code>color</code> is given, the
   * element's <code>color</code> style is used.
   * </li>
   * <li><code>release:Boolean</code> (optional) —
   * Optional determines if the ripple should happen
   * on release. Defaults to down/start.
   * </li>
   * <li><code>delegate:String</code> (optional) —
   * Optional selector for which child to add the ripple
   * into
   * </li>
   * <li><code>measureSelector:String</code> (optional) —
   * Optional selector for which child to use
   * to measure for ripple size.
   * </li>
   * <li><code>position:Array</code> (optional) —
   * The [x,y] position in which to start the ripple.
   * </li>
   * <li><code>centered:Boolean</code> (optional) —
   * Set to <code>true</code> to override all position
   * information and forces the ripple to be centered inside its parent.
   * </li>
   * <li><code>bound</code> (optional) —
   * Determines if the ripple is bound to
   * the parent container (default). If false ripple will expand outside of container.
   * </li>
   * <li><code>diameterLimit</code> (optional) —
   * Maximum size, in pixels, that a ripple
   * can be.
   * A value of <code>false</code> or <code>0</code> will cause the ripple to fill its container. A value of <code>true</code>
   * will cause the ripple to use the default maximum size.
   * </li>
   * <li><code>fit</code> (default = <code>true</code>) —
   * For bound ripples only. Determines if
   * ripple should search up the dom for an element that will fit the ripple
   * without clipping. Setting to false will force the unbound ripple into the specified
   * container. Defaults to <code>true</code>.
   * </li>
   * <li><code>destroyTime:Number</code> (optional) —
   * The time (in milliseconds) to wait until
   * the ripple is destroyed.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-ripple Original Ext JS documentation of 'ripple'
   * @see null#style:$ripple-background-color
   */
  public native function ripple(event:* = undefined, options:* = undefined):void;

  [Deprecated(replacement="animate", since="4.0")]
  /**
   * Animates the transition of an element's dimensions from a starting
   * height/width to an ending height/width. This method is a convenience
   * implementation of →<code>shift()</code>. Usage:
   * <pre>
   * // change height and width to 100x100 pixels
   * el.scale(100, 100);
   *
   * // common config options shown with default values.
   * // The height and width will default to the element's existing values
   * // if passed as null.
   * el.scale(
   *     [element's width],
   *     [element's height], {
   *         easing: 'easeOut',
   *         duration: 350
   *     }
   * );
   * </pre>
   * @param width The new width (pass undefined to keep the original
   * width)
   * @param height The new height (pass undefined to keep the original
   * height)
   * @param options Object literal with any of the
   * →<code>ext.fx.Anim</code> config options
   * @return The Element
   * @see #shift()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-scale Original Ext JS documentation of 'scale'
   * @see ext.fx.Anim
   */
  public native function scale(width:Number, height:Number, options:Object = null):Element;

  /**
   * Scrolls this element the specified direction. Does bounds checking to make sure
   * the scroll is within this element's scrollable range.
   * @param direction Possible values are:
   * <ul>
   * <li><code>"l"</code> (or <code>"left"</code>)</li>
   * <li><code>"r"</code> (or <code>"right"</code>)</li>
   * <li><code>"t"</code> (or <code>"top"</code>, or <code>"up"</code>)</li>
   * <li><code>"b"</code> (or <code>"bottom"</code>, or <code>"down"</code>)</li>
   * </ul>
   * @param distance How far to scroll the element in pixels
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @return Returns true if a scroll was triggered or false if the element
   * was scrolled as far as it could go.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-scroll Original Ext JS documentation of 'scroll'
   */
  public native function scroll(direction:String, distance:Number, animate:* = undefined):Boolean;

  /**
   * Scrolls this element by the passed delta values, optionally animating.
   * <p>All of the following are equivalent:</p>
   * <pre>
   *  el.scrollBy(10, 10, true);
   *  el.scrollBy([10, 10], true);
   *  el.scrollBy({ x: 10, y: 10 }, true);
   * </pre>
   * @param deltaX Either the x delta, an Array specifying x and y
   * deltas or an object with "x" and "y" properties.
   * @param deltaY Either the y delta, or an animate flag or config
   * object.
   * @param animate Animate flag/config object if the delta values were
   * passed separately.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-scrollBy Original Ext JS documentation of 'scrollBy'
   */
  public native function scrollBy(deltaX:*, deltaY:*, animate:*):Element;

  /**
   * Scrolls this element into view within the passed container.
   * <pre>
   *   Ext.create('Ext.data.Store', {
   *       storeId:'simpsonsStore',
   *       fields:['name', 'email', 'phone'],
   *       data:{'items':[
   *           { 'name': 'Lisa',  "email":"lisa&#64;simpsons.com", "phone":"555-111-1224" },
   *           { 'name': 'Bart',  "email":"bart&#64;simpsons.com",  "phone":"555-222-1234" },
   *           { 'name': 'Homer', "email":"homer&#64;simpsons.com",  "phone":"555-222-1244" },
   *           { 'name': 'Marge', "email":"marge&#64;simpsons.com", "phone":"555-222-1254" },
   *           { 'name': 'Milhouse', "email":"milhouse&#64;simpsons.com",
   *             "phone":"555-222-1244" },
   *           { 'name': 'Willy', "email":"willy&#64;simpsons.com", "phone":"555-222-1254" },
   *           { 'name': 'Skinner', "email":"skinner&#64;simpsons.com",
   *             "phone":"555-222-1244" },
   *           { 'name': 'Hank (last row)', "email":"hank&#64;simpsons.com",
   *             "phone":"555-222-1254" }
   *       ]},
   *       proxy: {
   *           type: 'memory',
   *           reader: {
   *               type: 'json',
   *               rootProperty: 'items'
   *           }
   *       }
   *   });
   *
   *   var grid = Ext.create('Ext.grid.Panel', {
   *       title: 'Simpsons',
   *       store: Ext.data.StoreManager.lookup('simpsonsStore'),
   *       columns: [
   *           { text: 'Name',  dataIndex: 'name', width: 125 },
   *           { text: 'Email', dataIndex: 'email', flex: 1 },
   *           { text: 'Phone', dataIndex: 'phone' }
   *       ],
   *       height: 190,
   *       width: 400,
   *       renderTo: Ext.getBody(),
   *       tbar: [{
   *           text: 'Scroll row 7 into view',
   *           handler: function () {
   *               var view = grid.getView();
   *
   *               Ext.get(view.getRow(7)).scrollIntoView(view.getEl(), null, true);
   *           }
   *       }]
   *   });
   * </pre>
   * @param container (Default document.body) The container element
   * to scroll. Should be a string (id), dom node, or Ext.Element.
   * @default document.body
   * @param hscroll False to disable horizontal scroll.
   * @default true
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @param highlight true to →<code>highlight()</code> the element when it is
   * in view.
   * @default false
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-scrollIntoView Original Ext JS documentation of 'scrollIntoView'
   * @see #highlight()
   */
  public native function scrollIntoView(container:* = undefined, hscroll:Boolean = true, animate:* = undefined, highlight:Boolean = false):Element;

  /**
   * Scrolls this element the specified scroll point. It does NOT do bounds checking so
   * if you scroll to a weird value it will try to do it. For auto bounds checking,
   * use #scroll.
   * @param side Either "left" for scrollLeft values or "top" for scrollTop values.
   * @param value The new scroll value
   * @param animate true for the default animation or a standard Element
   * animation config object
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-scrollTo Original Ext JS documentation of 'scrollTo'
   */
  public native function scrollTo(side:String, value:Number, animate:* = undefined):Element;

  /**
   * Selects descendant elements of this element based on the passed CSS selector to
   * enable →<code>ext.dom.Element</code> methods to be applied to many related
   * elements in one statement through the returned
   * →<code>ext.dom.CompositeElementLite</code> object.
   * @param selector The CSS selector or an array of elements
   * @param composite Return a CompositeElement as opposed to a
   * CompositeElementLite. Defaults to false.
   * @see ext.dom.Element
   * @see ext.dom.CompositeElementLite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-select Original Ext JS documentation of 'select'
   */
  public native function select(selector:*, composite:Boolean = false):CompositeElementLite;

  /**
   * Selects a single descendant element of this element using a CSS selector
   * (see →<code>query()</code>).
   * @param selector The selector query
   * @param asDom <code>false</code> to return an Ext.dom.Element
   * @default true
   * @return The DOM element (or Ext.dom.Element if
   * <i>asDom</i> is <i>false</i>) which matched the selector.
   * @see #query()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-selectNode Original Ext JS documentation of 'selectNode'
   */
  public native function selectNode(selector:String, asDom:Boolean = true):*;

  /**
   * Selects the specified contents of the input element (all by default).
   * @since 6.5.0
   * @param start The starting index to select.
   * @default 0
   * @param end The end index to select (defaults to all remaining text).
   * @param direction Pass "f" for forward,
   * "b" for backwards.
   * @default "f"
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-selectText Original Ext JS documentation of 'selectText'
   */
  public native function selectText(start:Number = 0, end:Number = NaN, direction:String = "f"):Element;

  /**
   * Enable text selection for this element (normalized across browsers)
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-selectable Original Ext JS documentation of 'selectable'
   */
  public native function selectable():Element;

  /**
   * Sets the passed attributes as attributes of this element (a <code>style</code> attribute
   * can be a string, object or function).
   * <p>Example component (though any Ext.dom.Element would suffice):</p>
   * <pre>
   * var cmp = Ext.create({
   *     xtype: 'component',
   *     html: 'test',
   *     renderTo: Ext.getBody()
   * });
   * </pre>
   * <p>Once the component is rendered, you can fetch a reference to its outer
   * element to use <code>→set()</code>:</p>
   * <pre>
   * cmp.el.set({
   *     foo: 'bar'
   * });
   * </pre>
   * <p>This sets an attribute on the element of <b>foo="bar"</b>:</p>
   * <pre>
   * &lt;div class="x-component x-component-default x-border-box"
   *      id="component-1009" foo="bar"&gt;test&lt;/div&gt;
   * </pre>
   * <p>To remove the attribute pass a value of <b>undefined</b>:</p>
   * <pre>
   * cmp.el.set({
   *     foo: undefined
   * });
   * </pre>
   * <p><b>Note:</b></p>
   * <ul>
   * <li>You cannot remove an attribute by passing <code>undefined</code> when the
   * <code>expandos</code> param is set to <b>false</b>.</li>
   * <li>Passing an attribute of <code>style</code> results in the request being handed off to
   * →<code>applyStyles()</code>.</li>
   * <li>Passing an attribute of <code>cls</code> results in the element's dom's
   * <a href="http://www.w3schools.com/jsref/prop_html_classname.asp">className</a> property
   * being set directly. For additional flexibility when setting / removing
   * classes see:
   * <ul>
   * <li>→<code>addCls()</code></li>
   * <li>→<code>removeCls()</code></li>
   * <li>→<code>replaceCls()</code></li>
   * <li>→<code>setCls()</code></li>
   * <li>→<code>toggleCls()</code></li>
   * </ul>
   * </li>
   * </ul>
   * @param attributes The object with the attributes.
   * @param useSet <code>false</code> to override the default <code>setAttribute</code>
   * to use <a href="http://help.dottoro.com/ljvovanq.php">expandos</a>.
   * @default true
   * @return this
   * @see #set()
   * @see #applyStyles()
   * @see #addCls()
   * @see #removeCls()
   * @see #replaceCls()
   * @see #setCls()
   * @see #toggleCls()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-set Original Ext JS documentation of 'set'
   */
  public native function set(attributes:Object, useSet:Boolean = true):Element;

  /**
   * Sets the element's CSS bottom style.
   * @param bottom Number of pixels or CSS string value to set as
   * the bottom CSS property value
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setBottom Original Ext JS documentation of 'setBottom'
   */
  public native function setBottom(bottom:*):Element;

  [Deprecated(replacement="setBox", since="4.2.0")]
  /**
   * Sets the element's position and size in one shot. If animation is true then
   * width, height, x and y will be animated concurrently.
   * @param x X value for new position (coordinates are page-based)
   * @param y Y value for new position (coordinates are page-based)
   * @param width The new width. This may be one of:
   * <ul>
   * <li>A Number specifying the new width in pixels</li>
   * <li>A String used to set the CSS width style. Animation may <b>not</b> be used.</li>
   * </ul>
   * @param height The new height. This may be one of:
   * <ul>
   * <li>A Number specifying the new height in pixels</li>
   * <li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>
   * </ul>
   * @param animate true for the default animation or
   * a standard Element animation config object
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setBounds Original Ext JS documentation of 'setBounds'
   */
  public native function setBounds(x:Number, y:Number, width:*, height:*, animate:* = undefined):Element;

  /**
   * @inheritDoc
   */
  public native function setBox(box:Object, animate:Boolean = undefined):void;

  /**
   * Sets the CSS classes of this element to the keys of the given object. The
   * <code>classMap</code> object is typically returned by →<code>getClassMap()</code>. The values of
   * the properties in the <code>classMap</code> should be truthy (such as <code>1</code> or <code>true</code>).
   * @param classMap The object whose keys will be the CSS classes.
   * @param keep Pass <code>true</code> to indicate the the <code>classMap</code>
   * object can be kept (instead of copied).
   * @default false
   * @see #getClassMap()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setClassMap Original Ext JS documentation of 'setClassMap'
   */
  public native function setClassMap(classMap:Object, keep:Boolean = false):void;

  /**
   * Sets the specified CSS class on this element's DOM node.
   * @param className The CSS class to set on this element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setCls Original Ext JS documentation of 'setCls'
   */
  public native function setCls(className:*):void;

  /**
   * Sets the CSS display property. Uses originalDisplay if the specified value is a
   * boolean true.
   * @param value Boolean value to display the element using its
   * default display, or a string to set the display directly.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setDisplayed Original Ext JS documentation of 'setDisplayed'
   */
  public native function setDisplayed(value:*):Element;

  [Deprecated(replacement="setHtml", since="5.0.0")]
  /**
   * Updates the innerHTML of this element, optionally searching for and processing scripts.
   * @param html The new HTML
   * @param loadScripts Pass <code>true</code> to look for and process scripts.
   * @param callback For async script loading you can be notified
   * when the update completes.
   * @param scope (Default `this`) The scope (<code>this</code> reference) in which to execute
   * the callback.
   * <p>Also used as the scope for any <i>inline</i> script source if the <code>loadScripts</code> parameter
   * is <code>true</code>. Scripts with a <code>src</code> attribute cannot be executed in this scope.</p>
   * <p>Defaults to this Element.</p>
   * @default this
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setHTML Original Ext JS documentation of 'setHTML'
   */
  public native function setHTML(html:String, loadScripts:Boolean = false, callback:Function = null, scope:Object = null):Element;

  /**
   * Set the height of this Element.
   * @param height The new height. This may be one of:
   * <ul>
   * <li>A Number specifying the new height in pixels.</li>
   * <li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>
   * </ul>
   * @param animate a standard Element animation config object or <code>true</code>
   * for the default animation (<code>{duration: 350, easing: 'ease-in'}</code>)
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setHeight Original Ext JS documentation of 'setHeight'
   */
  public native function setHeight(height:*, animate:* = undefined):Element;

  /**
   * Sets the <code>innerHTML</code> of this element.
   * @param html The new HTML
   * @param loadScripts Pass <code>true</code> to look for and process scripts.
   * @param callback For async script loading you can be notified
   * when the update completes.
   * @param scope (Default `this`) The scope (<code>this</code> reference) in which to execute
   * the callback.
   * <p>Also used as the scope for any <i>inline</i> script source if the <code>loadScripts</code> parameter
   * is <code>true</code>. Scripts with a <code>src</code> attribute cannot be executed in this scope.</p>
   * <p>Defaults to this Element.</p>
   * @default this
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setHtml Original Ext JS documentation of 'setHtml'
   */
  public native function setHtml(html:String, loadScripts:Boolean = false, callback:Function = null, scope:Object = null):Element;

  /**
   * Sets the element's left position directly using CSS style
   * (instead of →<code>setX()</code>).
   * @param left Number of pixels or CSS string value to
   * set as the left CSS property value
   * @return this
   * @see #setX()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setLeft Original Ext JS documentation of 'setLeft'
   */
  public native function setLeft(left:*):Element;

  [Deprecated(replacement="setLocalXY", since="4.2.0")]
  /**
   * Sets the element's left and top positions directly using CSS style
   * @param left Number of pixels or CSS string value to
   * set as the left CSS property value
   * @param top Number of pixels or CSS string value to
   * set as the top CSS property value
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setLeftTop Original Ext JS documentation of 'setLeftTop'
   */
  public native function setLeftTop(left:String, top:String):Element;

  /**
   * @inheritDoc
   */
  public native function setLocalX(x:Number):void;

  /**
   * @inheritDoc
   */
  public native function setLocalXY(x:*, y:Number = NaN):void;

  /**
   * @inheritDoc
   */
  public native function setLocalY(y:Number):void;

  [Deprecated(replacement="setXY", since="4.2.0")]
  /**
   * Sets the position of the element in page coordinates.
   * @param x X value for new position
   * @param y Y value for new position
   * @param animate True for the default animation,
   * or a standard Element animation config object
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setLocation Original Ext JS documentation of 'setLocation'
   */
  public native function setLocation(x:Number, y:Number, animate:* = undefined):Element;

  /**
   * Set the maximum height of this Element.
   * @param height The new maximum height.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setMaxHeight Original Ext JS documentation of 'setMaxHeight'
   */
  public native function setMaxHeight(height:*):Element;

  /**
   * Set the maximum width of this Element.
   * @param width The new maximum width.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setMaxWidth Original Ext JS documentation of 'setMaxWidth'
   */
  public native function setMaxWidth(width:*):Element;

  /**
   * Set the minimum height of this Element.
   * @param height The new minimum height.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setMinHeight Original Ext JS documentation of 'setMinHeight'
   */
  public native function setMinHeight(height:*):Element;

  /**
   * Set the minimum width of this Element.
   * @param width The new minimum width.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setMinWidth Original Ext JS documentation of 'setMinWidth'
   */
  public native function setMinWidth(width:*):Element;

  /**
   * Set the opacity of the element
   * @param opacity The new opacity. 0 = transparent, .5 = 50% visible,
   * 1 = fully visible, etc
   * @param animate a standard Element animation config object or <code>true</code>
   * for the default animation (<code>{duration: 350, easing: 'ease-in'}</code>)
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setOpacity Original Ext JS documentation of 'setOpacity'
   */
  public native function setOpacity(opacity:Number, animate:* = undefined):Element;

  /**
   * Set positioning with an object returned by <code>→getPositioning()</code>.
   * @return this
   * @see #getPositioning()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setPositioning Original Ext JS documentation of 'setPositioning'
   */
  public native function setPositioning(pc:Object):Element;

  /**
   * Sets the element's CSS right style.
   * @param right Number of pixels or CSS string value to
   * set as the right CSS property value
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setRight Original Ext JS documentation of 'setRight'
   */
  public native function setRight(right:*):Element;

  /**
   * Sets the left scroll position
   * @param left The left scroll position
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setScrollLeft Original Ext JS documentation of 'setScrollLeft'
   */
  public native function setScrollLeft(left:Number):Element;

  /**
   * Sets the top scroll position
   * @param top The top scroll position
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setScrollTop Original Ext JS documentation of 'setScrollTop'
   */
  public native function setScrollTop(top:Number):Element;

  /**
   * Set the size of this Element.
   * @param width The new width. This may be one of:
   * <ul>
   * <li>A Number specifying the new width in pixels.</li>
   * <li>A String used to set the CSS width style. Animation may <b>not</b> be used.</li>
   * <li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>
   * </ul>
   * @param height The new height. This may be one of:
   * <ul>
   * <li>A Number specifying the new height in pixels.</li>
   * <li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>
   * </ul>
   * @param animate a standard Element animation config object or <code>true</code>
   * for the default animation (<code>{duration: 350, easing: 'ease-in'}</code>)
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setSize Original Ext JS documentation of 'setSize'
   */
  public native function setSize(width:*, height:*, animate:* = undefined):Element;

  /**
   * Wrapper for setting style properties, also takes single object parameter of
   * multiple styles.
   * <p>Styles should be a valid DOM element style property.
   * <a href="http://www.w3schools.com/jsref/dom_obj_style.asp">Valid style property names</a>
   * (<i>along with the supported CSS version for each</i>)</p>
   * <pre>
   * // &lt;div id="my-el"&gt;Phineas Flynn&lt;/div&gt;
   *
   * var el = Ext.get('my-el');
   *
   * // two-param syntax
   * el.setStyle('color', 'white');
   *
   * // single-param syntax
   * el.setStyle({
   *     fontWeight: 'bold',
   *     backgroundColor: 'gray',
   *     padding: '10px'
   * });
   * </pre>
   * @param prop The style property to be set, or an object of
   * multiple styles.
   * @param value The value to apply to the given property, or null if
   * an object was passed.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setStyle Original Ext JS documentation of 'setStyle'
   */
  public native function setStyle(prop:*, value:String = null):Element;

  /**
   * Sets the element's top position directly using CSS style
   * (instead of →<code>setY()</code>).
   * @param top Number of pixels or CSS string value to
   * set as the top CSS property value
   * @return this
   * @see #setY()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setTop Original Ext JS documentation of 'setTop'
   */
  public native function setTop(top:*):Element;

  /**
   * Sets the CSS <a href="https://www.w3.org/TR/pointerevents/#the-touch-action-css-property">touch-action</a>
   * property on this element and emulates its behavior on browsers where touch-action
   * is not supported.
   * @param touchAction An object with touch-action names as the keys, and
   * boolean values to enable or disable specific touch actions. Accepted keys are:
   * <ul>
   * <li><code>panX</code></li>
   * <li><code>panY</code></li>
   * <li><code>pinchZoom</code></li>
   * <li><code>doubleTapZoom</code></li>
   * </ul>
   * <p>All touch actions are enabled (<code>true</code>) by default, so it is usually only necessary
   * to specify which touch actions to disable. For example, the following disables
   * only vertical scrolling and double-tap-zoom on an element</p>
   * <pre>
   * element.setTouchAction({
   *     panY: false,
   *     doubleTapZoom: false
   * });
   * </pre>
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setTouchAction Original Ext JS documentation of 'setTouchAction'
   */
  public native function setTouchAction(touchAction:Object):Element;

  /**
   * Use this to change the visibility mode between →<code>VISIBILITY</code>,
   * →<code>DISPLAY</code>, →<code>OFFSETS</code>, →<code>CLIP</code>, or →<code>OPACITY</code>.
   * @param mode The method by which the element will be <i>hidden</i> (→<code>hide()</code>) (you can
   * also use the →<code>setVisible()</code> or →<code>toggle()</code> method to toggle element
   * visibility).
   * @return this
   * @see #VISIBILITY
   * @see #DISPLAY
   * @see #OFFSETS
   * @see #CLIP
   * @see #OPACITY
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setVisibilityMode Original Ext JS documentation of 'setVisibilityMode'
   * @see #hide()
   * @see #setVisible()
   * @see #toggle()
   */
  public native function setVisibilityMode(mode:Number):Element;

  /**
   * Sets the visibility of the element based on the current visibility mode. Use
   * →<code>setVisibilityMode()</code> to switch between the following visibility modes:
   * <ul>
   * <li>→<code>DISPLAY</code> (the default)</li>
   * <li>→<code>VISIBILITY</code></li>
   * <li>→<code>OFFSETS</code></li>
   * <li>→<code>CLIP</code></li>
   * <li>→<code>OPACITY</code></li>
   * </ul>
   * @param visible Whether the element is visible
   * @param animate True for the default animation,
   * or a standard Element animation config object.
   * @return this
   * @see #setVisibilityMode()
   * @see #DISPLAY
   * @see #VISIBILITY
   * @see #OFFSETS
   * @see #CLIP
   * @see #OPACITY
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setVisible Original Ext JS documentation of 'setVisible'
   */
  public native function setVisible(visible:Boolean, animate:* = undefined):Element;

  /**
   * Set the width of this Element.
   * @param width The new width. This may be one of:
   * <ul>
   * <li>A Number specifying the new width in pixels.</li>
   * <li>A String used to set the CSS width style. Animation may <b>not</b> be used.</li>
   * </ul>
   * @param animate a standard Element animation config object or <code>true</code>
   * for the default animation (<code>{duration: 350, easing: 'ease-in'}</code>)
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setWidth Original Ext JS documentation of 'setWidth'
   */
  public native function setWidth(width:*, animate:* = undefined):Element;

  /**
   * Sets this Element's page-level x coordinate
   * @param x The X position
   * @param animate True for the default animation, or a standard
   * Element animation config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setX Original Ext JS documentation of 'setX'
   */
  public native function setX(x:Number, animate:* = undefined):void;

  /**
   * Sets this Element's page-level x and y coordinates
   * @param pos Contains X &amp; Y [x, y] values for new position (coordinates
   * are page-based)
   * @param animate True for the default animation, or a standard
   * Element animation config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setXY Original Ext JS documentation of 'setXY'
   */
  public native function setXY(pos:Array, animate:* = undefined):void;

  /**
   * Sets this Element's page-level y coordinate
   * @param y The Y position
   * @param animate True for the default animation, or a standard
   * Element animation config object
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setY Original Ext JS documentation of 'setY'
   */
  public native function setY(y:Number, animate:* = undefined):void;

  /**
   * Sets the z-index of this Element and synchronizes the z-index of shadow and/or
   * shim if present.
   * @param zindex The new z-index to set
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-setZIndex Original Ext JS documentation of 'setZIndex'
   */
  public native function setZIndex(zindex:Number):Element;

  [Deprecated(replacement="animate", since="4.0")]
  /**
   * Animates the transition of any combination of an element's dimensions,
   * xy position and/or opacity. Any of these properties not specified in the
   * config object will not be changed. This effect requires that at least one new
   * dimension, position or opacity setting must be passed in on the config object
   * in order for the function to have any effect. Usage:
   * <pre>
   * // slide the element horizontally to x position 200
   * // while changing the height and opacity
   * el.shift({ x: 200, height: 50, opacity: .8 });
   *
   * // common config options shown with default values.
   * el.shift({
   *     width: [element's width],
   *     height: [element's height],
   *     x: [element's x position],
   *     y: [element's y position],
   *     opacity: [element's opacity],
   *     easing: 'easeOut',
   *     duration: 350
   * });
   * </pre>
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-shift Original Ext JS documentation of 'shift'
   * @see ext.fx.Anim
   */
  public native function shift(options:Object):Element;

  /**
   * Show this element - Uses display mode to determine whether to use "display",
   * "visibility", "offsets", or "clip". See →<code>setVisible()</code>.
   * @param animate true for the default animation or a standard
   * Element animation config object.
   * @return this
   * @see #setVisible()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-show Original Ext JS documentation of 'show'
   */
  public native function show(animate:* = undefined):Element;

  /**
   * Slides the element into view. An anchor point can be optionally passed to set the point
   * of origin for the slide effect. This function automatically handles wrapping the element
   * with a fixed-size container if needed. See the →<code>ext.fx.Anim</code> class overview
   * for valid anchor point options. Usage:
   * <pre>
   * // default: slide the element in from the top
   * el.slideIn();
   *
   * // custom: slide the element in from the right with a 2-second duration
   * el.slideIn('r', { duration: 2000 });
   *
   * // common config options shown with default values
   * el.slideIn('t', {
   *     easing: 'easeOut',
   *     duration: 500
   * });
   * </pre>
   * @param anchor One of the valid →<code>ext.fx.Anim</code> anchor positions
   * (defaults to top: 't')
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * <ul>
   * <li><code>preserveScroll:Boolean</code> (optional) —
   * Set to true if preservation of any descendant
   * elements' <code>scrollTop</code> values is required. By default the DOM wrapping operation
   * performed by <code>→slideIn()</code> and <code>→slideOut()</code> causes the browser to lose all scroll positions.
   * </li>
   * </ul>
   * @return The Element
   * @see ext.fx.Anim
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-slideIn Original Ext JS documentation of 'slideIn'
   * @see #slideIn()
   * @see #slideOut()
   */
  public native function slideIn(anchor:String = null, options:Object = null, slideOut:Boolean = false):Element;

  /**
   * Slides the element out of view. An anchor point can be optionally passed to set the end
   * point for the slide effect. When the effect is completed, the element will be hidden
   * (visibility = 'hidden') but block elements will still take up space in the document.
   * The element must be removed from the DOM using the 'remove' config option if
   * desired. This function automatically handles wrapping the element with a fixed-size
   * container if needed. See the →<code>ext.fx.Anim</code> class overview for valid anchor point
   * options. Usage:
   * <pre>
   * // default: slide the element out to the top
   * el.slideOut();
   *
   * // custom: slide the element out to the right with a 2-second duration
   * el.slideOut('r', { duration: 2000 });
   *
   * // common config options shown with default values
   * el.slideOut('t', {
   *     easing: 'easeOut',
   *     duration: 500,
   *     remove: false,
   *     useDisplay: false
   * });
   * </pre>
   * @param anchor One of the valid →<code>ext.fx.Anim</code> anchor positions
   * (defaults to top: 't')
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see ext.fx.Anim
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-slideOut Original Ext JS documentation of 'slideOut'
   */
  public native function slideOut(anchor:String = null, options:Object = null):Element;

  /**
   * Stops the specified event(s) from bubbling and optionally prevents the default action...
   * <pre>
   * var store = Ext.create('Ext.data.Store', {
   *     fields: ['name', 'email'],
   *     data: [{
   *         'name': 'Finn',
   *         "email": "finn&#64;adventuretime.com"
   *     }]
   * });
   *
   * Ext.create('Ext.grid.Panel', {
   *     title: 'Land of Ooo',
   *     store: store,
   *     columns: [{
   *         text: 'Name',
   *         dataIndex: 'name'
   *     }, {
   *         text: 'Email &lt;img style="vertical-align:middle;" src="{some-image-src}" /&gt;',
   *         dataIndex: 'email',
   *         flex: 1,
   *         listeners: {
   *             render: function(col) {
   *                 // Swallow the click event when the click occurs on the
   *                 // help icon - preventing the sorting of data by that
   *                 // column and instead performing an action specific to
   *                 // the help icon
   *                 var img = col.getEl().down('img');
   *                 img.swallowEvent(['click', 'mousedown'], true);
   *                 col.on('click', function() {
   *                     // logic to show a help dialog
   *                     console.log('image click handler');
   *                 }, col);
   *             }
   *         }
   *     }],
   *     height: 200,
   *     width: 400,
   *     renderTo: document.body
   * });
   * </pre>
   * @param eventName an event / array of events to stop from bubbling
   * @param preventDefault true to prevent the default action too
   * @return Object with a destroy method to unswallow events
   * <ul>
   * <li><code>destroy:Function</code> (optional) —
   * method to clean up any listeners that are swallowing
   * events
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-swallowEvent Original Ext JS documentation of 'swallowEvent'
   */
  public native function swallowEvent(eventName:*, preventDefault:Boolean = false):Object;

  /**
   * Blinks the element as if it was clicked and then collapses on its center (similar to
   * switching off a television). When the effect is completed, the element will be hidden
   * (visibility = 'hidden') but block elements will still take up space in the document.
   * The element must be removed from the DOM using the 'remove' config option if desired.
   * Usage:
   * <pre>
   * // default
   * el.switchOff();
   *
   * // all config options shown with default values
   * el.switchOff({
   *     easing: 'easeIn',
   *     duration: .3,
   *     remove: false,
   *     useDisplay: false
   * });
   * </pre>
   * @param options Object literal with any of the →<code>ext.fx.Anim</code>
   * config options
   * @return The Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-switchOff Original Ext JS documentation of 'switchOff'
   * @see ext.fx.Anim
   */
  public native function switchOff(options:Object = null):Element;

  /**
   * Toggles the element's visibility, depending on visibility mode.
   * @param animate True for the default animation, or a standard Element
   * animation config object
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-toggle Original Ext JS documentation of 'toggle'
   */
  public native function toggle(animate:* = undefined):Element;

  /**
   * Toggles the specified CSS class on this element (removes it if it already exists,
   * otherwise adds it).
   * @param className The CSS class to toggle.
   * @param state If specified as <code>true</code>, causes the class to be added.
   * If specified as <code>false</code>, causes the class to be removed.
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-toggleCls Original Ext JS documentation of 'toggleCls'
   */
  public native function toggleCls(className:String, state:Boolean = false):Element;

  /**
   * @inheritDoc
   */
  public native function translatePoints(x:*, y:Number = NaN):Object;

  /**
   * Return clipping (overflow) to original clipping before →<code>clip()</code> was called
   * @return this
   * @see #clip()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-unclip Original Ext JS documentation of 'unclip'
   */
  public native function unclip():Element;

  /**
   * Hides a previously applied mask.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-unmask Original Ext JS documentation of 'unmask'
   */
  public native function unmask():void;

  /**
   * Disables text selection for this element (normalized across browsers)
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-unselectable Original Ext JS documentation of 'unselectable'
   */
  public native function unselectable():Element;

  /**
   * Walks up the dom looking for a parent node that matches the passed simple selector
   * (e.g. 'div.some-class' or 'span:first-child').
   * This is a shortcut for findParentNode() that always returns an Ext.dom.Element.
   * @param simpleSelector The simple selector to test. See →<code>ext.dom.DomQuery</code>
   * for information about simple selectors.
   * @param limit The max depth to search as a number or an element that causes the upward
   * traversal to stop and is <b>not</b> considered for inclusion as the result.
   * (defaults to 50 || document.documentElement)
   * @param returnDom True to return the DOM node instead of Ext.dom.Element
   * @default false
   * @return The matching DOM node (or HTMLElement if
   * <i>returnDom</i> is <i>true</i>). Or null if no match was found.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-up Original Ext JS documentation of 'up'
   * @see ext.dom.#DomQuery ext.dom.DomQuery
   */
  public native function up(simpleSelector:String, limit:* = undefined, returnDom:Boolean = false):*;

  [Deprecated(replacement="setHtml", since="5.0.0")]
  /**
   * Updates the innerHTML of this element, optionally searching for and processing scripts.
   * @param html The new HTML
   * @return this
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-update Original Ext JS documentation of 'update'
   */
  public native function update(html:String):Element;

  /**
   * Updates the <i>text</i> value of this element.
   * Replaces the content of this element with a <i>single text node</i> containing
   * the passed text.
   * @param text The text to display in this Element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-updateText Original Ext JS documentation of 'updateText'
   */
  public native function updateText(text:String):void;

  /**
   * Creates and wraps this element with another element
   * @param config DomHelper element config object for the wrapper element or null
   * for an empty div
   * @param returnDom True to return the raw DOM element instead of
   * Ext.dom.Element
   * @default false
   * @param selector A CSS selector to select a descendant node within the created
   * element to use as the wrapping element.
   * @return The newly created wrapper element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#method-wrap Original Ext JS documentation of 'wrap'
   */
  public native function wrap(config:Object = null, returnDom:Boolean = false, selector:String = null):*;
}
}