package ext.dom {

[Native("Ext.dom.Fly", require)]
/**
 * A flyweight Ext.dom.Element that can be dynamically attached to a DOM node.
 * In general this class should not be instantiated directly. Use →<code>ext.Ext.fly()</code>
 * to create and retrieve Fly instances.
 * @see ext.SExt#fly() ext.Ext.fly()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Fly.html Original Ext JS documentation of 'Ext.dom.Fly'
 */
public class Fly extends Element {
  /**
   * @inheritDoc
   */
  public function Fly(idOrHtmlElement:Object) {
    super(idOrHtmlElement);
  }

  /**
   * This is <code>true</code> to identify Element flyweights
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Fly.html#property-isFly Original Ext JS documentation of 'isFly'
   */
  public native function get isFly():Boolean;

  /**
   * @private
   */
  public native function set isFly(value:Boolean):void;
}
}