package ext.dom {

[Deprecated(replacement="enableShadow", since="5.1.0")]
[Native("Ext.dom.Layer", require)]
/**
 * An extended →<code>ext.dom.Element</code> object that supports a shadow and shim
 * @see ext.dom.Element
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html Original Ext JS documentation of 'Ext.dom.Layer'
 */
public class Layer extends Element {
  /**
   * Creates new Layer.
   * @param config An object with config options.
   * @param existingEl Uses an existing DOM element.
   * If the element is not found it creates it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Layer(config:Layer = null, existingEl:* = undefined) {
    super(existingEl);
  }

  [ExtConfig]
  /**
   * CSS class to add to the element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-cls Original Ext JS documentation of 'cls'
   * @see #setCls()
   */
  public native function get cls():String;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set cls(value:String):void;

  [ExtConfig]
  /**
   * False to disable constrain to viewport.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  public native function get constrain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set constrain(value:Boolean):void;

  [ExtConfig]
  /**
   * DomHelper object config to create element with.
   * @default {tag: 'div', cls: 'x-layer'}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-dh Original Ext JS documentation of 'dh'
   */
  public native function get dh():Object;

  [ExtConfig]
  /**
   * @private
   */
  public native function set dh(value:Object):void;

  [ExtConfig]
  /**
   * A String which specifies how this Layer will be hidden.
   * Values may be:
   * <ul>
   * <li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>
   * <li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>
   * <li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the
   * visible area of the document. This is useful when a hidden Component must maintain
   * measurable dimensions. Hiding using <code>display</code> results in a Component having zero dimensions.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-hideMode Original Ext JS documentation of 'hideMode'
   */
  public native function get hideMode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideMode(value:String):void;

  [ExtConfig]
  /**
   * Number of pixels to offset the shadow
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-shadowOffset Original Ext JS documentation of 'shadowOffset'
   */
  public native function get shadowOffset():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shadowOffset(value:Number):void;

  [ExtConfig("shadow")]
  /**
   * True to automatically create an →<code>ext.dom.Shadow</code>, or a string indicating the
   * shadow's display →<code>ext.dom.Shadow#mode</code>. False to disable the shadow.
   * @default false
   * @see ext.dom.Shadow
   * @see ext.dom.Shadow#mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  public native function get shadow_():*;

  [ExtConfig("shadow")]
  /**
   * @private
   */
  public native function set shadow_(value:*):void;

  [ExtConfig]
  /**
   * True to automatically create a →<code>null</code>.
   * @default false
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-shim Original Ext JS documentation of 'shim'
   */
  public native function get shim():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set shim(value:*):void;

  [ExtConfig]
  /**
   * Defaults to use css offsets to hide the Layer. Specify <tt>true</tt>
   * to use css style <tt>'display:none;'</tt> to hide the Layer.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-useDisplay Original Ext JS documentation of 'useDisplay'
   */
  public native function get useDisplay():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useDisplay(value:Boolean):void;

  [ExtConfig]
  /**
   * The CSS class name to add in order to hide this Layer if this layer
   * is configured with <code>→hideMode: 'asclass'</code>
   * @see #hideMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-visibilityCls Original Ext JS documentation of 'visibilityCls'
   */
  public native function get visibilityCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set visibilityCls(value:String):void;

  [ExtConfig]
  /**
   * Starting z-index.
   * @default 11000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Layer.html#cfg-zindex Original Ext JS documentation of 'zindex'
   */
  public native function get zindex():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set zindex(value:Number):void;
}
}