package ext.dom {

[Native("Ext.dom.Shadow", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>Simple class that can provide a shadow effect for any absolutely positioned →<code>ext.dom.Element</code>.</p>
 * <p>Not meant to be used directly. To apply a shadow to an Element use the
 * →<code>ext.dom.Element.enableShadow()</code> method.</p>
 * @see ext.dom.Element
 * @see ext.dom.Element#enableShadow()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html Original Ext JS documentation of 'Ext.dom.Shadow'
 */
public class Shadow extends Underlay {
  /**
   * Creates new Shadow.
   * @param config Config object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Shadow(config:Object = null) {
    super();
  }

  [ExtConfig]
  /**
   * The shadow display mode. Supports the following options:
   * <ul>
   * <li>sides : Shadow displays on both sides and bottom only</li>
   * <li>frame : Shadow displays equally on all four sides</li>
   * <li>drop : Traditional bottom-right drop shadow</li>
   * </ul>
   * @default 'drop'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html#cfg-mode Original Ext JS documentation of 'mode'
   */
  public native function get mode():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set mode(value:String):void;

  [ExtConfig]
  /**
   * The number of pixels to offset the shadow from the element
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html#cfg-offset Original Ext JS documentation of 'offset'
   */
  public native function get offset():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set offset(value:Number):void;

  /**
   * The offsets used for positioning the shadow element
   * relative to its target element
   * @default offsets
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html#property-offsets Original Ext JS documentation of 'offsets'
   */
  public native function get offsets():Object;

  /**
   * @private
   */
  public native function set offsets(value:Object):void;

  /**
   * Offsets that represent the union of the areas
   * of the target element and the shadow combined. Used by Ext.dom.Element for
   * ensuring that the shim (if present) extends under the full area of both elements.
   * @default outerOffsets
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html#property-outerOffsets Original Ext JS documentation of 'outerOffsets'
   */
  public native function get outerOffsets():Object;

  /**
   * @private
   */
  public native function set outerOffsets(value:Object):void;

  /**
   * Sets the opacity of the shadow
   * @param opacity The opacity
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Shadow.html#method-setOpacity Original Ext JS documentation of 'setOpacity'
   */
  public native function setOpacity(opacity:Number):void;
}
}