package ext.dom {
import ext.Base;

[Native("Ext.dom.Underlay", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * <p>A class that provides an underlay element which displays behind an absolutely positioned
 * target element and tracks its size and position. Abstract base class for
 * →<code>ext.dom.Shadow</code> and →<code>null</code></p>
 * @see ext.dom.Shadow
 * @see null
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html Original Ext JS documentation of 'Ext.dom.Underlay'
 */
public class Underlay extends Base {
  /**
   * This Underlay's current element.
   */
  public native function get el():Element;

  [ExtConfig]
  /**
   * The target element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#cfg-target Original Ext JS documentation of 'target'
   */
  public native function get target():Element;

  [ExtConfig]
  /**
   * @private
   */
  public native function set target(value:Element):void;

  [ExtConfig]
  /**
   * The CSS z-index to use for this underlay. Defaults to the z-index of →<code>target</code>.
   * @see #target
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#cfg-zIndex Original Ext JS documentation of 'zIndex'
   * @see #setZIndex()
   */
  public native function get zIndex():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  public native function set zIndex(value:Number):void;

  /**
   * Called before the underlay is shown, immediately after its element is retrieved
   * from the pool
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-beforeShow Original Ext JS documentation of 'beforeShow'
   */
  protected native function beforeShow():void;

  /**
   * Returns the dom element that this underlay should be inserted before.
   * Defaults to the target element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-getInsertionTarget Original Ext JS documentation of 'getInsertionTarget'
   */
  protected native function getInsertionTarget():Element;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-getPool Original Ext JS documentation of 'getPool'
   */
  protected native function getPool():Base;

  /**
   * Hides the underlay
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-hide Original Ext JS documentation of 'hide'
   */
  public native function hide():void;

  /**
   * Aligns the underlay to its target element
   * @param x The x position of the target element. If not provided, the
   * x position will be read from the DOM.
   * @param y The y position of the target element. If not provided, the
   * y position will be read from the DOM.
   * @param width The width of the target element. If not provided, the
   * width will be read from the DOM.
   * @param height The height of the target element. If not provided, the
   * height will be read from the DOM.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-realign Original Ext JS documentation of 'realign'
   */
  public native function realign(x:Number = NaN, y:Number = NaN, width:Number = NaN, height:Number = NaN):void;

  /**
   * Adjust the z-index of this underlay
   * @param zIndex The new z-index
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-setZIndex Original Ext JS documentation of 'setZIndex'
   */
  public native function setZIndex(zIndex:Number):void;

  /**
   * Shows the underlay
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Underlay.html#method-show Original Ext JS documentation of 'show'
   */
  public native function show():void;
}
}