package ext.dom.events {
import ext.dom.Element;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.dom.events.ElementEvent")]
public class ElementEvent extends FlExtEvent {
  /**
   * Fires whenever this Element actually becomes visible (painted) on the screen. This is
   * useful when you need to perform 'read' operations on the DOM element, i.e: calculating
   * natural sizes and positioning.
   * <p><b>Note:</b> This event is not available to be used with event delegation. Instead <code>→event:onPainted</code>
   * only fires if you explicitly add at least one listener to it, for performance reasons.</p>
   * @see ext.dom.Element#event:onPainted
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#event-painted Original Ext JS documentation of 'painted'
   * @see ext.dom.Element
   * @eventType onPainted
   */
  public static const PAINTED:String = "onPainted";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function ElementEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The component instance.
   */
  public native function get source():Element;
}
}