package ext.dom.events {
import ext.dom.Element;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.dom.events.Element_infoEvent")]
public class Element_infoEvent extends FlExtEvent {
  /**
   * Important note: For the best performance on mobile devices, use this only when you
   * absolutely need to monitor a Element's size.
   * <p><b>Note:</b> This event is not available to be used with event delegation. Instead <code>→event:onResize</code>
   * only fires if you explicitly add at least one listener to it, for performance reasons.</p>
   * @see ext.dom.Element#event:onResize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.dom.Element.html#event-resize Original Ext JS documentation of 'resize'
   * @see ext.dom.Element
   * @eventType onResize
   */
  public static const RESIZE:String = "onResize";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "info", "eOpts"];

  public function Element_infoEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The element's new size parameters.
   */
  public native function get info():Object;

  /**
   * The component instance.
   */
  public native function get source():Element;
}
}