package ext.drag {
import ext.Base;
import ext.mixin.IFactoryable;
import ext.util.Region;

[Native("Ext.drag.Constraint", require)]
/**
 * Provides constraining behavior for a →<code>ext.drag.DragSource</code>.
 * @see ext.drag.DragSource
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html Original Ext JS documentation of 'Ext.drag.Constraint'
 */
public class DragConstraint extends Base implements IFactoryable {
  [ExtConfig]
  [Bindable]
  /**
   * The element to constrain to...
   * <ul>
   * <li><code>true</code> to constrain to the parent of the →<code>ext.drag.DragSource.element</code>.</li>
   * <li>The id, DOM element or Ext.dom.Element to constrain to.</li>
   * </ul>
   * @default null
   * @see ext.drag.DragSource#element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-element Original Ext JS documentation of 'element'
   * @see #getElement()
   * @see #setElement()
   */
  public native function get element():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set element(value:*):void;

  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to limit dragging to the horizontal axis.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-horizontal Original Ext JS documentation of 'horizontal'
   * @see #getHorizontal()
   * @see #setHorizontal()
   */
  public native function get horizontal():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set horizontal(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The region to constrain to.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-region Original Ext JS documentation of 'region'
   * @see #getRegion()
   * @see #setRegion()
   */
  public native function get region():Region;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set region(value:Region):void;

  [ExtConfig]
  [Bindable]
  /**
   * The interval to move this drag target during a drag in both dimensions.
   * <ul>
   * <li><code>{x: 30}</code>, snap only x</li>
   * <li><code>{y: 30}</code>, snap only y</li>
   * <li><code>{x: 30, y: 40}</code>, snap both</li>
   * <li><code>40</code>, snap both to <code>40</code>.</li>
   * </ul>
   * <p>The snap may also be a function to calculate the snap value on each tick.</p>
   * <pre>
   *  snap: {
   *      x: function(info, x) {
   *          return x &lt; 300 ? 150 : 500;
   *      }
   *  }
   * </pre>
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-snap Original Ext JS documentation of 'snap'
   * @see #getSnap()
   * @see #setSnap()
   */
  public native function get snap():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set snap(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * The <i>source</i> (→<code>ext.drag.DragSource</code>) for the constraint. This will be
   * set automatically when constructed via the source.
   * @see ext.drag.DragSource
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-source Original Ext JS documentation of 'source'
   * @see #getSource()
   * @see #setSource()
   */
  public native function get source():DragSource;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set source(value:DragSource):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to limit dragging to the vertical axis.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-vertical Original Ext JS documentation of 'vertical'
   * @see #getVertical()
   * @see #setVertical()
   */
  public native function get vertical():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set vertical(value:Boolean):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  [Bindable]
  /**
   * The minimum and maximum x position. Use <code>null</code> to
   * not set a constraint:
   * <ul>
   * <li><code>[100, null]</code>, constrain only the minimum</li>
   * <li><code>[null, 100]</code>, constrain only the maximum</li>
   * <li><code>[200, 200]</code>, constrain both.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-x Original Ext JS documentation of 'x'
   * @see #getX()
   * @see #setX()
   */
  public native function get x():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set x(value:Array):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  [Bindable]
  /**
   * The minimum and maximum y position. Use <code>null</code> to
   * not set a constraint:
   * <ul>
   * <li><code>[100, null]</code>, constrain only the minimum</li>
   * <li><code>[null, 100]</code>, constrain only the maximum</li>
   * <li><code>[200, 200]</code>, constrain both.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#cfg-y Original Ext JS documentation of 'y'
   * @see #getY()
   * @see #setY()
   */
  public native function get y():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set y(value:Array):void;

  [ArrayElementType("Number")]
  /**
   * Constrain the position of the drag proxy using the configured rules.
   * @param xy The position.
   * @param info The drag information.
   * @return The xy position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Constraint.html#method-constrain Original Ext JS documentation of 'constrain'
   */
  public native function constrain(xy:Array, info:DragInfo):Array;

  /**
   * Returns the value of <code>element</code>.
   * @see #element
   */
  public native function getElement():*;

  /**
   * Returns the value of <code>horizontal</code>.
   * @see #horizontal
   */
  public native function getHorizontal():Boolean;

  /**
   * Returns the value of <code>region</code>.
   * @see #region
   */
  public native function getRegion():Region;

  /**
   * Returns the value of <code>snap</code>.
   * @see #snap
   */
  public native function getSnap():*;

  /**
   * Returns the value of <code>source</code>.
   * @see #source
   */
  public native function getSource():DragSource;

  /**
   * Returns the value of <code>vertical</code>.
   * @see #vertical
   */
  public native function getVertical():Boolean;

  [ArrayElementType("Number")]
  /**
   * Returns the value of <code>x</code>.
   * @see #x
   */
  public native function getX():Array;

  [ArrayElementType("Number")]
  /**
   * Returns the value of <code>y</code>.
   * @see #y
   */
  public native function getY():Array;

  /**
   * Sets the value of <code>element</code>.
   * @param element The new value.
   * @see #element
   */
  public native function setElement(element:*):void;

  /**
   * Sets the value of <code>horizontal</code>.
   * @param horizontal The new value.
   * @see #horizontal
   */
  public native function setHorizontal(horizontal:Boolean):void;

  /**
   * Sets the value of <code>region</code>.
   * @param region The new value.
   * @see #region
   */
  public native function setRegion(region:Region):void;

  /**
   * Sets the value of <code>snap</code>.
   * @param snap The new value.
   * @see #snap
   */
  public native function setSnap(snap:*):void;

  /**
   * Sets the value of <code>source</code>.
   * @param source The new value.
   * @see #source
   */
  public native function setSource(source:DragSource):void;

  /**
   * Sets the value of <code>vertical</code>.
   * @param vertical The new value.
   * @see #vertical
   */
  public native function setVertical(vertical:Boolean):void;

  [ArrayElementType("Number")]
  /**
   * Sets the value of <code>x</code>.
   * @param x The new value.
   * @see #x
   */
  public native function setX(x:Array):void;

  [ArrayElementType("Number")]
  /**
   * Sets the value of <code>y</code>.
   * @param y The new value.
   * @see #y
   */
  public native function setY(y:Array):void;
}
}