package ext.drag {
import ext.Base;
import ext.Promise;

import js.HTMLElement;

[Native("Ext.drag.Info", require)]
/**
 * This class is used to unify information for a specific drag instance.
 * This object is passed to template methods and events to obtain
 * details about the current operation.
 * <p>It is not expected that this class will be created by user code.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html Original Ext JS documentation of 'Ext.drag.Info'
 */
public class DragInfo extends Base {
  /**
   * Information about the cursor position. Not available when
   * →<code>isNative</code> is <code>true</code>.
   * <ul>
   * <li><code>current:Object</code> (optional) —
   * The current cursor position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The current x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The current y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>delta:Object</code> (optional) —
   * The change in cursor position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The change in x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The change in y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>initial:Object</code> (optional) —
   * The intial cursor position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The initial x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The initial y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>offset:Object</code> (optional) —
   * The offset from the cursor to the top/left of
   * the →<code>ext.drag.DragSource.element</code>.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The x offset.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The y offset.
   * </li>
   * </ul>
   * </li>
   * </ul>
   * @see #isNative
   * @see ext.drag.DragSource#element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-cursor Original Ext JS documentation of 'cursor'
   */
  public native function get cursor():Object;

  /**
   * @private
   */
  public native function set cursor(value:Object):void;

  /**
   * Information about the →<code>ext.drag.DragSource.element</code> position.
   * Not available when →<code>isNative</code> is <code>true</code>.
   * <ul>
   * <li><code>current:Object</code> (optional) —
   * The current element position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The current x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The current y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>delta:Object</code> (optional) —
   * The change in element position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The change in x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The change in y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>initial:Object</code> (optional) —
   * The intial element position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The initial x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The initial y position.
   * </li>
   * </ul>
   * </li>
   * </ul>
   * @see ext.drag.DragSource#element
   * @see #isNative
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-element Original Ext JS documentation of 'element'
   */
  public native function get element():Object;

  /**
   * @private
   */
  public native function set element(value:Object):void;

  /**
   * The event target that the drag started on.
   * <p>Not available when →<code>isNative</code> is <code>true</code>.</p>
   * @see #isNative
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-eventTarget Original Ext JS documentation of 'eventTarget'
   */
  public native function get eventTarget():HTMLElement;

  /**
   * @private
   */
  public native function set eventTarget(value:HTMLElement):void;

  /**
   * A list of files included for this drag. See:
   * https://developer.mozilla.org/en/docs/Web/API/FileList
   * <p>Only available when →<code>isNative</code> is <code>true</code>.</p>
   * @see #isNative
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-files Original Ext JS documentation of 'files'
   */
  public native function get files():Object;

  /**
   * @private
   */
  public native function set files(value:Object):void;

  /**
   * <code>true</code> if the drag is a native drag event, for example
   * a file draggedi nto the browser.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-isNative Original Ext JS documentation of 'isNative'
   */
  public native function get isNative():Boolean;

  /**
   * @private
   */
  public native function set isNative(value:Boolean):void;

  /**
   * Information about the →<code>ext.drag.DragSource.proxy</code> position.
   * This may be the actual →<code>ext.drag.DragSource.element</code>.
   * Not available when →<code>isNative</code> is <code>true</code>.
   * <ul>
   * <li><code>current:Object</code> (optional) —
   * The current proxy position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The current x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The current y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>delta:Object</code> (optional) —
   * The change in proxy position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The change in x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The change in y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>initial:Object</code> (optional) —
   * The intial proxy position.
   * <ul>
   * <li><code>x:Number</code> (optional) —
   * The initial x position.
   * </li>
   * <li><code>y:Number</code> (optional) —
   * The initial y position.
   * </li>
   * </ul>
   * </li>
   * <li><code>element:ext.dom.Element</code> (optional) —
   * The proxy element.
   * </li>
   * <li><code>isElement:Boolean</code> (optional) —
   * <code>true</code> if the proxy is the →<code>ext.drag.DragSource.element</code>.
   * </li>
   * <li><code>isUnderCursor:Boolean</code> (optional) —
   * <code>true</code> if the alignment causes the proxy to be under the cursor.
   * </li>
   * </ul>
   * @see ext.drag.DragSource#proxy
   * @see ext.drag.DragSource#element
   * @see #isNative
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-proxy Original Ext JS documentation of 'proxy'
   */
  public native function get proxy():Object;

  /**
   * @private
   */
  public native function set proxy(value:Object):void;

  /**
   * The drag source. Not available when →<code>isNative</code> is <code>true</code>.
   * @see #isNative
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-source Original Ext JS documentation of 'source'
   */
  public native function get source():DragSource;

  /**
   * @private
   */
  public native function set source(value:DragSource):void;

  /**
   * The active target. <code>null</code> if not over a target.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-target Original Ext JS documentation of 'target'
   */
  public native function get target():DragTarget;

  /**
   * @private
   */
  public native function set target(value:DragTarget):void;

  [ArrayElementType("String")]
  /**
   * The data types this drag provides. Added via →<code>setData()</code>.
   * @see #setData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-types Original Ext JS documentation of 'types'
   */
  public native function get types():Array;

  /**
   * @private
   */
  public native function set types(value:Array):void;

  /**
   * <code>true</code> if the →<code>target</code> is valid. See →<code>ext.drag.DragTarget</code> for
   * information about validity. <code>false</code> if there is no target.
   * @default false
   * @see #target
   * @see ext.drag.DragTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#property-valid Original Ext JS documentation of 'valid'
   */
  public native function get valid():Boolean;

  /**
   * @private
   */
  public native function set valid(value:Boolean):void;

  /**
   * Clear the data for a particular type.
   * @param type The type.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#method-clearData Original Ext JS documentation of 'clearData'
   */
  public native function clearData(type:String):void;

  /**
   * Create a copy of this object with the current state.
   * @return A copy of this object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():DragInfo;

  /**
   * Get data for this drag. This method may only be called once the drop completes.
   * @param type The type of data to retrieve. Must be in the →<code>types</code>.
   * See also →<code>setData()</code>.
   * @return The data. If the produced data is not a →<code>ext.Promise</code>,
   * it will be wrapped in one.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#method-getData Original Ext JS documentation of 'getData'
   * @see #types
   * @see #setData()
   * @see ext.Promise
   */
  public native function getData(type:String):Promise;

  /**
   * Set data for this drag. Multiple types may be registered. Each type will be
   * added to →<code>types</code>.
   * @param type The type of data being registered.
   * @param value The value being registered. If a function
   * is provided it will be evaluated if requested when the drop completes. The
   * function should return a value or a →<code>ext.Promise</code> that will produce a value.
   * @see #types
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Info.html#method-setData Original Ext JS documentation of 'setData'
   * @see ext.Promise
   */
  public native function setData(type:String, value:*):void;
}
}