package ext.drag {
import ext.mixin.IIdentifiable;
import ext.mixin.Observable;

[Native("Ext.drag.Item", require)]
/**
 * A base class for draggable and droppable items that wrap a DOM element.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html Original Ext JS documentation of 'Ext.drag.Item'
 */
public class DragItem extends Observable implements IIdentifiable {
  /**
   * @inheritDoc
   */
  public function DragItem(config:Observable = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to destroy the →<code>element</code> when this item is destroyed.
   * @default true
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html#cfg-autoDestroy Original Ext JS documentation of 'autoDestroy'
   * @see #getAutoDestroy()
   * @see #setAutoDestroy()
   */
  public native function get autoDestroy():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set autoDestroy(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The id, dom or Element reference for this item.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html#cfg-element Original Ext JS documentation of 'element'
   * @see #getElement()
   * @see #setElement()
   */
  public native function get element():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set element(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * A group controls which <i>sources</i> (→<code>ext.drag.DragSource</code>) and →<code>ext.drag.DragTarget</code>
   * targets can interact with each other. Only items that have the same (or intersecting)
   * groups will react to each other. Items with no groups will be in the default pool.
   * @default null
   * @see ext.drag.DragSource
   * @see ext.drag.DragTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html#cfg-groups Original Ext JS documentation of 'groups'
   * @see #getGroups()
   * @see #setGroups()
   */
  public native function get groups():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set groups(value:*):void;

  /**
   * Disable the current item to disallow it from participating
   * in drag/drop operations.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html#method-disable Original Ext JS documentation of 'disable'
   */
  public native function disable():void;

  /**
   * Enable the current item to allow it to participate in
   * drag/drop operations.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html#method-enable Original Ext JS documentation of 'enable'
   */
  public native function enable():void;

  /**
   * Returns the value of <code>autoDestroy</code>.
   * @see #autoDestroy
   */
  public native function getAutoDestroy():Boolean;

  /**
   * Returns the value of <code>element</code>.
   * @see #element
   */
  public native function getElement():*;

  /**
   * Returns the value of <code>groups</code>.
   * @see #groups
   */
  public native function getGroups():*;

  /**
   * Checks whether this item is currently disabled.
   * @return <code>true</code> if this item is disabled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Item.html#method-isDisabled Original Ext JS documentation of 'isDisabled'
   */
  public native function isDisabled():Boolean;

  /**
   * Sets the value of <code>autoDestroy</code>.
   * @param autoDestroy The new value.
   * @see #autoDestroy
   */
  public native function setAutoDestroy(autoDestroy:Boolean):void;

  /**
   * Sets the value of <code>element</code>.
   * @param element The new value.
   * @see #element
   */
  public native function setElement(element:*):void;

  /**
   * Sets the value of <code>groups</code>.
   * @param groups The new value.
   * @see #groups
   */
  public native function setGroups(groups:*):void;
}
}