package ext.drag {
import ext.mixin.Observable;

[Native("Ext.drag.Source", require)]
/**
 * @see ext.drag.events.DragSource_info_eventEvent.BEFORE_DRAG_START
 * @eventType ext.drag.events.DragSource_info_eventEvent.BEFORE_DRAG_START
 */
[Event(name='onBeforeDragStart', type='ext.drag.events.DragSource_info_eventEvent')]
/**
 * @see ext.drag.events.DragSource_info_eventEvent.DRAG_CANCEL
 * @eventType ext.drag.events.DragSource_info_eventEvent.DRAG_CANCEL
 */
[Event(name='onDragCancel', type='ext.drag.events.DragSource_info_eventEvent')]
/**
 * @see ext.drag.events.DragSource_info_eventEvent.DRAG_END
 * @eventType ext.drag.events.DragSource_info_eventEvent.DRAG_END
 */
[Event(name='onDragEnd', type='ext.drag.events.DragSource_info_eventEvent')]
/**
 * @see ext.drag.events.DragSource_info_eventEvent.DRAG_MOVE
 * @eventType ext.drag.events.DragSource_info_eventEvent.DRAG_MOVE
 */
[Event(name='onDragMove', type='ext.drag.events.DragSource_info_eventEvent')]
/**
 * @see ext.drag.events.DragSource_info_eventEvent.DRAG_START
 * @eventType ext.drag.events.DragSource_info_eventEvent.DRAG_START
 */
[Event(name='onDragStart', type='ext.drag.events.DragSource_info_eventEvent')]
/**
 * A wrapper around a DOM element that allows it to be dragged.
 * <p><b><i>Constraining</i></b></p>
 * <p>The →<code>constrain</code> config gives various options for limiting drag, for example:</p>
 * <ul>
 * <li>Vertical or horizontal only</li>
 * <li>Minimum/maximum x/y values.</li>
 * <li>Snap to grid</li>
 * <li>Constrain to an element or region.</li>
 * </ul>
 * <p>See →<code>ext.drag.DragConstraint</code> for detailed options.</p>
 * <pre>
 *  new Ext.drag.Source({
 *      element: dragEl,
 *      constrain: {
 *          // Drag only vertically in 30px increments
 *          vertical: true,
 *          snap: {
 *              y: 30
 *          }
 *      }
 *  });
 * </pre>
 * <p><b><i>Data</i></b></p>
 * <p>Data representing the underlying drag is driven by the →<code>describe()</code> method. This
 * method is called once at the beginning of the drag. It should populate the info object with data
 * using the →<code>ext.drag.DragInfo.setData()</code> method. It accepts 2 arguments.</p>
 * <ul>
 * <li>The <code>type</code> is used to indicate to <i>targets</i> (→<code>ext.drag.DragTarget</code>) the type(s) of data being
 * provided. This allows the <i>target</i> (→<code>ext.drag.DragTarget</code>) to decide whether it is able to
 * interact with the source. All types added are available in →<code>ext.drag.DragInfo.types</code>.</li>
 * <li>The value can be a static value, or a function reference. In the latter case, the function
 * is evaluated when the data is requested.</li>
 * </ul>
 * <p>The →<code>ext.drag.DragInfo.getData()</code> method may be called once the drop completes. The data for the
 * relevant type is retrieved. All values from this method return a →<code>ext.Promise</code> to allow
 * for consistency when dealing with synchronous and asynchronous data.</p>
 * <p><b><i>Proxy</i></b></p>
 * <p>A →<code>proxy</code> is an element that follows the mouse cursor during a drag. This may be the
 * →<code>element</code>, a newly created element, or none at all (if the purpose is to just track
 * the cursor).</p>
 * <p>See <i>for details</i> (→<code>ext.drag.proxy.NoneDragProxy</code>).</p>
 * <pre>
 *  var data = [{
 *      id: 1,
 *      name: 'Adam'
 *  }, {
 *      id: 2,
 *      name: 'Barbara'
 *  }, {
 *      id: 3,
 *      name: 'Charlie'
 *  }];
 *
 *  var tpl = new Ext.XTemplate(
 *      '&lt;div class="container"&gt;',
 *          '&lt;tpl for="."&gt;',
 *              '&lt;div class="child" data-id="{id}"&gt;{name}&lt;/div&gt;',
 *          '&lt;/tpl&gt;',
 *      '&lt;/div&gt;'
 *  );
 *
 *  var el = tpl.append(Ext.getBody(), data);
 *
 *  new Ext.drag.Source({
 *      element: el,
 *      handle: '.child',
 *      proxy: {
 *          type: 'placeholder',
 *          getElement: function(info) {
 *              return Ext.getBody().createChild({
 *                  cls: 'foo',
 *                  html: info.eventTarget.innerHTML
 *              });
 *          }
 *      }
 *  });
 * </pre>
 * <p><b><i>Handle</i></b></p>
 * <p>A →<code>handle</code> is a CSS selector that allows certain child elements of the →<code>element</code>
 * to begin a drag. This is useful in 2 case:</p>
 * <ul>
 * <li>Where only a certain part of the element should trigger a drag, but the whole element should
 * move.</li>
 * <li>When there are several repeated elements that may represent objects.</li>
 * </ul>
 * <p>In the example below, each child element becomes draggable and
 * the describe method is used to extract the id from the DOM element.</p>
 * <pre>
 *  var data = [{
 *      id: 1,
 *      name: 'Adam'
 *  }, {
 *      id: 2,
 *      name: 'Barbara'
 *  }, {
 *      id: 3,
 *      name: 'Charlie'
 *  }];
 *
 *  var tpl = new Ext.XTemplate(
 *      '&lt;div class="container"&gt;',
 *          '&lt;tpl for="."&gt;',
 *              '&lt;div class="child" data-id="{id}"&gt;{name}&lt;/div&gt;',
 *          '&lt;/tpl&gt;',
 *      '&lt;/div&gt;'
 *  );
 *
 *  var el = tpl.append(Ext.getBody(), data);
 *
 *  new Ext.drag.Source({
 *      element: el,
 *      handle: '.child',
 *      describe: function(info) {
 *          info.setData('item', Ext.fly(info.eventTarget).getAttribute('data-id'));
 *      }
 *  });
 * </pre>
 * @see #constrain
 * @see ext.drag.DragConstraint
 * @see #describe()
 * @see ext.drag.DragInfo#setData()
 * @see ext.drag.DragTarget
 * @see ext.drag.DragInfo#types
 * @see ext.drag.DragInfo#getData()
 * @see ext.Promise
 * @see #proxy
 * @see #element
 * @see ext.drag.proxy.NoneDragProxy
 * @see #handle
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html Original Ext JS documentation of 'Ext.drag.Source'
 */
public class DragSource extends DragItem {
  /**
   * @inheritDoc
   */
  public function DragSource(config:Observable = null) {
    super();
  }

  [ExtConfig]
  [Bindable]
  /**
   * A css class to add to the →<code>element</code> while dragging is
   * active.
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-activeCls Original Ext JS documentation of 'activeCls'
   * @see #getActiveCls()
   * @see #setActiveCls()
   */
  public native function get activeCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set activeCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> to always begin a drag with longpress. <code>false</code> to
   * never drag with longpress. If a string (or strings) are passed, it should
   * correspond to the pointer event type that should initiate a a drag on
   * longpress. See →<code>ext.event.Event.pointerType</code> for available types.
   * @default false
   * @see ext.event.Event#pointerType
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-activeOnLongPress Original Ext JS documentation of 'activeOnLongPress'
   * @see #getActiveOnLongPress()
   * @see #setActiveOnLongPress()
   */
  public native function get activeOnLongPress():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set activeOnLongPress(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Adds constraining behavior for this drag source. See →<code>ext.drag.DragConstraint</code> for
   * configuration options. As a shortcut, a →<code>ext.util.Region</code>
   * or →<code>ext.dom.Element</code> may be passed, which will be mapped to the
   * appropriate configuration on the constraint.
   * @default null
   * @see ext.drag.DragConstraint
   * @see ext.util.Region
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-constrain Original Ext JS documentation of 'constrain'
   * @see #getConstrain()
   * @see #setConstrain()
   */
  public native function get constrain():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set constrain(value:*):void;

  [ExtConfig("describe")]
  /**
   * See →<code>describe()</code>.
   * @see #describe()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-describe Original Ext JS documentation of 'describe'
   */
  public native function get describe_():Function;

  [ExtConfig("describe")]
  /**
   * @private
   */
  public native function set describe_(value:Function):void;

  /**
   * <code>true</code> if this source is currently dragging.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#property-dragging Original Ext JS documentation of 'dragging'
   */
  public native function get dragging():Boolean;

  /**
   * @private
   */
  public native function set dragging(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * A CSS selector to identify child elements of the →<code>element</code> that will cause
   * a drag to be activated. If this is not specified, the entire →<code>element</code> will
   * be draggable.
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-handle Original Ext JS documentation of 'handle'
   * @see #getHandle()
   * @see #setHandle()
   */
  public native function get handle():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set handle(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * The proxy to show while this element is dragging. This may be
   * the alias, a config, or instance of a proxy.
   * <p>See →<code>ext.drag.proxy.NoneDragProxy</code>, →<code>ext.drag.proxy.OriginalDragProxy</code>,
   * →<code>ext.drag.proxy.PlaceholderDragProxy</code>.</p>
   * @default 'original'
   * @see ext.drag.proxy.NoneDragProxy
   * @see ext.drag.proxy.OriginalDragProxy
   * @see ext.drag.proxy.PlaceholderDragProxy
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-proxy Original Ext JS documentation of 'proxy'
   * @see #getProxy()
   * @see #setProxy()
   */
  public native function get proxy():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set proxy(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * <code>true</code> (or an animation configuration) to animate the →<code>proxy</code> (which may be
   * the →<code>element</code>) back to the original position after drag.
   * @default false
   * @see #proxy
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#cfg-revert Original Ext JS documentation of 'revert'
   * @see #getRevert()
   * @see #setRevert()
   */
  public native function get revert():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set revert(value:*):void;

  /**
   * Called before a drag starts. Return <code>false</code> to veto the drag.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param The drag info.
   * @return <code>false</code> to veto the drag.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-beforeDragStart Original Ext JS documentation of 'beforeDragStart'
   */
  protected native function beforeDragStart(The:DragInfo):Boolean;

  /**
   * Sets up the underlying data that describes the drag. This method
   * is called once at the start of the drag operation.
   * <p>Data should be set on the <i>info</i> (→<code>ext.drag.DragInfo</code>) using the
   * →<code>ext.drag.DragInfo.setData()</code> method. See
   * →<code>ext.drag.DragInfo.setData()</code> for more information.</p>
   * <p>This method should not be called by user code.</p>
   * @param info The drag info.
   * @see ext.drag.DragInfo
   * @see ext.drag.DragInfo#setData()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-describe Original Ext JS documentation of 'describe'
   */
  protected native function describe(info:DragInfo):void;

  /**
   * Returns the value of <code>activeCls</code>.
   * @see #activeCls
   */
  public native function getActiveCls():String;

  /**
   * Returns the value of <code>activeOnLongPress</code>.
   * @see #activeOnLongPress
   */
  public native function getActiveOnLongPress():*;

  /**
   * Returns the value of <code>constrain</code>.
   * @see #constrain
   */
  public native function getConstrain():*;

  /**
   * Returns the value of <code>handle</code>.
   * @see #handle
   */
  public native function getHandle():String;

  /**
   * Returns the value of <code>proxy</code>.
   * @see #proxy
   */
  public native function getProxy():*;

  /**
   * Returns the value of <code>revert</code>.
   * @see #revert
   */
  public native function getRevert():*;

  /**
   * Checks whether this source is actively dragging.
   * @return <code>true</code> if this source is dragging.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-isDragging Original Ext JS documentation of 'isDragging'
   */
  public native function isDragging():Boolean;

  /**
   * Called when a drag is cancelled.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-onDragCancel Original Ext JS documentation of 'onDragCancel'
   */
  protected native function onDragCancel():void;

  /**
   * Called when a drag ends.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-onDragEnd Original Ext JS documentation of 'onDragEnd'
   */
  protected native function onDragEnd():void;

  /**
   * Called for each move in a drag.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-onDragMove Original Ext JS documentation of 'onDragMove'
   */
  protected native function onDragMove():void;

  /**
   * Called when a drag starts.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#method-onDragStart Original Ext JS documentation of 'onDragStart'
   */
  protected native function onDragStart():void;

  /**
   * Sets the value of <code>activeCls</code>.
   * @param activeCls The new value.
   * @see #activeCls
   */
  public native function setActiveCls(activeCls:String):void;

  /**
   * Sets the value of <code>activeOnLongPress</code>.
   * @param activeOnLongPress The new value.
   * @see #activeOnLongPress
   */
  public native function setActiveOnLongPress(activeOnLongPress:*):void;

  /**
   * Sets the value of <code>constrain</code>.
   * @param constrain The new value.
   * @see #constrain
   */
  public native function setConstrain(constrain:*):void;

  /**
   * Sets the value of <code>handle</code>.
   * @param handle The new value.
   * @see #handle
   */
  public native function setHandle(handle:String):void;

  /**
   * Sets the value of <code>proxy</code>.
   * @param proxy The new value.
   * @see #proxy
   */
  public native function setProxy(proxy:*):void;

  /**
   * Sets the value of <code>revert</code>.
   * @param revert The new value.
   * @see #revert
   */
  public native function setRevert(revert:*):void;
}
}