package ext.drag {
import ext.mixin.Observable;

[Native("Ext.drag.Target", require)]
/**
 * @see ext.drag.events.DragTarget_infoEvent.BEFORE_DROP
 * @eventType ext.drag.events.DragTarget_infoEvent.BEFORE_DROP
 */
[Event(name='onBeforeDrop', type='ext.drag.events.DragTarget_infoEvent')]
/**
 * @see ext.drag.events.DragTarget_infoEvent.DRAG_ENTER
 * @eventType ext.drag.events.DragTarget_infoEvent.DRAG_ENTER
 */
[Event(name='onDragEnter', type='ext.drag.events.DragTarget_infoEvent')]
/**
 * @see ext.drag.events.DragTarget_infoEvent.DRAG_LEAVE
 * @eventType ext.drag.events.DragTarget_infoEvent.DRAG_LEAVE
 */
[Event(name='onDragLeave', type='ext.drag.events.DragTarget_infoEvent')]
/**
 * @see ext.drag.events.DragTarget_infoEvent.DRAG_MOVE
 * @eventType ext.drag.events.DragTarget_infoEvent.DRAG_MOVE
 */
[Event(name='onDragMove', type='ext.drag.events.DragTarget_infoEvent')]
/**
 * @see ext.drag.events.DragTarget_infoEvent.DROP
 * @eventType ext.drag.events.DragTarget_infoEvent.DROP
 */
[Event(name='onDrop', type='ext.drag.events.DragTarget_infoEvent')]
/**
 * A wrapper around a DOM element that allows it to receive drops.
 * <p><b><i>Validity of drag operations</i></b></p>
 * <p>There are certain conditions that govern whether a <i>source</i> (→<code>ext.drag.DragSource</code>)
 * and a target can interact. By default (without configuration), all
 * <i>sources</i> (→<code>ext.drag.DragSource</code>) and targets can interact with each other, the conditions
 * are evaluated in this order:</p>
 * <p><i>Disabled State (→<code>isDisabled()</code>)</i></p>
 * <p>If the target is disabled, the <i>source</i> (→<code>ext.drag.DragSource</code>)
 * cannot interact with it.</p>
 * <p><i>Groups (→<code>groups</code>)</i></p>
 * <p>Both the <i>source</i> (→<code>ext.drag.DragSource</code>) and target can belong to multiple groups.
 * They may interact if:</p>
 * <ul>
 * <li>Neither has a group</li>
 * <li>Both have one (or more) of the same group</li>
 * </ul>
 * <p><i>Accept (→<code>accepts()</code>)</i></p>
 * <p>This method is called each time a <i>source</i> (→<code>ext.drag.DragSource</code>) enters this
 * target. If the method returns <code>false</code>, the drag is not considered valid.</p>
 * <p><b><i>Asynchronous drop processing</i></b></p>
 * <p>When the drop completes, the →<code>event:onDrop</code> event will fire, however the underlying data
 * may not be ready to be consumed. By returning a →<code>ext.Promise</code> from the data,
 * it allows either:</p>
 * <ul>
 * <li>The data to be fetched (either from a remote source or generated if expensive).</li>
 * <li>Any validation to take place before the drop is finalized.</li>
 * </ul>
 * <p>Once the promise is <i>resolved</i> (→<code>ext.Promise.resolve()</code>) or <i>rejected</i> (→<code>ext.Promise.resolve()</code>),
 * further processing can be completed.</p>
 * <p>Validation example:</p>
 * <pre>
 *  var confirmSource = new Ext.drag.Source({
 *      element: dragEl,
 *      describe: function(info) {
 *          // Provide the data up front
 *          info.setData('records', theRecords);
 *      }
 *  });
 *
 *  var confirmTarget = new Ext.drag.Target({
 *      element: dropEl,
 *      listeners: {
 *          drop: function(target, info) {
 *              Ext.MessageBox.confirm('Really', 'Are you sure?', function(btn) {
 *                  if (btn === 'yes') {
 *                      info.getData('records').then(function(data) {
 *                          // Process the data
 *                      });
 *                  }
 *              });
 *          }
 *      }
 *  });
 * </pre>
 * <p>Remote data example:</p>
 * <pre>
 *  var fetchSource = new Ext.drag.Source({
 *      element: dragEl,
 *      // The resulting drag data will be a binary blob
 *      // of image data, we don't want to fetch it up front, so
 *      // pass a callback to be executed when data is requested.
 *      describe: function(info) {
 *          info.setData('image', function() {
 *              return Ext.Ajax.request({
 *                  url: 'data.json'
 *                  // some options
 *              }).then(function(result) {
 *                  var imageData;
 *                  // Do some post-processing
 *                  return imageData;
 *              }, function() {
 *                  return Ext.Promise.reject('Something went wrong!');
 *              });
 *          });
 *      }
 *  });
 *
 *  var fetchTarget = new Ext.drag.Target({
 *      element: dropEl,
 *      accepts: function(info) {
 *          return info.types.indexOf('image') &gt; -1;
 *      },
 *      listeners: {
 *          drop: function(target, info) {
 *              info.getData('image').then(function() {
 *                  // All good, show the image
 *              }, function() {
 *                  // Handle failure case
 *              });
 *          }
 *      }
 *  });
 * </pre>
 * @see ext.drag.DragSource
 * @see #isDisabled()
 * @see #groups
 * @see #accepts()
 * @see #event:onDrop
 * @see ext.Promise
 * @see ext.Promise#resolve()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html Original Ext JS documentation of 'Ext.drag.Target'
 */
public class DragTarget extends DragItem {
  /**
   * @inheritDoc
   */
  public function DragTarget(config:Observable = null) {
    super();
  }

  [ExtConfig("accepts")]
  /**
   * See →<code>accepts()</code>.
   * @see #accepts()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#cfg-accepts Original Ext JS documentation of 'accepts'
   */
  public native function get accepts_():Function;

  [ExtConfig("accepts")]
  /**
   * @private
   */
  public native function set accepts_(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * A class to add to the →<code>element</code> when an
   * invalid drag is over this target.
   * @default ''
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#cfg-invalidCls Original Ext JS documentation of 'invalidCls'
   * @see #getInvalidCls()
   * @see #setInvalidCls()
   */
  public native function get invalidCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set invalidCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A class to add to the →<code>element</code> when an
   * invalid drag is over this target.
   * @default ''
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#cfg-validCls Original Ext JS documentation of 'validCls'
   * @see #getValidCls()
   * @see #setValidCls()
   */
  public native function get validCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set validCls(value:String):void;

  /**
   * Called each time a <i>source</i> (→<code>ext.drag.DragSource</code>) enters this target.
   * Allows this target to indicate whether it will interact with
   * the given drag. Determined after →<code>isDisabled()</code> and
   * →<code>groups</code> checks. If either of the aforementioned conditions
   * means the target is not valid, this will not be called.
   * <p>Defaults to returning <code>true</code>.</p>
   * @param info The drag info.
   * @return <code>true</code> if the drag is valid for this target.
   * @see ext.drag.DragSource
   * @see #isDisabled()
   * @see #groups
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-accepts Original Ext JS documentation of 'accepts'
   */
  protected native function accepts(info:DragInfo):Boolean;

  /**
   * Called before a drag finishes on this target. Return <code>false</code> to veto
   * the drop.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info The drag info.
   * @return <code>false</code> to veto the drop.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-beforeDrop Original Ext JS documentation of 'beforeDrop'
   */
  protected native function beforeDrop(info:DragInfo):Boolean;

  /**
   * Disable the current item to disallow it from participating
   * in drag/drop operations.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-disable Original Ext JS documentation of 'disable'
   */
  override public native function disable():void;

  /**
   * Enable the current item to allow it to participate in
   * drag/drop operations.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-enable Original Ext JS documentation of 'enable'
   */
  override public native function enable():void;

  /**
   * Returns the value of <code>invalidCls</code>.
   * @see #invalidCls
   */
  public native function getInvalidCls():String;

  /**
   * Returns the value of <code>validCls</code>.
   * @see #validCls
   */
  public native function getValidCls():String;

  /**
   * Called when a drag enters this target.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info The drag info.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-onDragEnter Original Ext JS documentation of 'onDragEnter'
   */
  protected native function onDragEnter(info:DragInfo):void;

  /**
   * Called when a source leaves this target.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info The drag info.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-onDragLeave Original Ext JS documentation of 'onDragLeave'
   */
  protected native function onDragLeave(info:DragInfo):void;

  /**
   * Called when a drag is moved while inside this target.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info The drag info.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-onDragMove Original Ext JS documentation of 'onDragMove'
   */
  protected native function onDragMove(info:DragInfo):void;

  /**
   * Called when a drag is dropped on this target.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info The drag info.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Target.html#method-onDrop Original Ext JS documentation of 'onDrop'
   */
  protected native function onDrop(info:DragInfo):void;

  /**
   * Sets the value of <code>invalidCls</code>.
   * @param invalidCls The new value.
   * @see #invalidCls
   */
  public native function setInvalidCls(invalidCls:String):void;

  /**
   * Sets the value of <code>validCls</code>.
   * @param validCls The new value.
   * @see #validCls
   */
  public native function setValidCls(validCls:String):void;
}
}