package ext.drag.events {
import ext.drag.DragInfo;
import ext.drag.DragSource;
import ext.event.Event;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.drag.events.DragSource_info_eventEvent")]
public class DragSource_info_eventEvent extends FlExtEvent {
  /**
   * Fires before drag starts on this source. Return <code>false</code> to cancel the drag.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#event-beforedragstart Original Ext JS documentation of 'beforedragstart'
   * @see ext.drag.DragSource
   * @eventType onBeforeDragStart
   */
  public static const BEFORE_DRAG_START:String = "onBeforeDragStart";
  /**
   * Fires when a drag is cancelled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#event-dragcancel Original Ext JS documentation of 'dragcancel'
   * @see ext.drag.DragSource
   * @eventType onDragCancel
   */
  public static const DRAG_CANCEL:String = "onDragCancel";
  /**
   * Fires when the drag ends on this source.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#event-dragend Original Ext JS documentation of 'dragend'
   * @see ext.drag.DragSource
   * @eventType onDragEnd
   */
  public static const DRAG_END:String = "onDragEnd";
  /**
   * Fires continuously as this source is dragged.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#event-dragmove Original Ext JS documentation of 'dragmove'
   * @see ext.drag.DragSource
   * @eventType onDragMove
   */
  public static const DRAG_MOVE:String = "onDragMove";
  /**
   * Fires when the drag starts on this source.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.Source.html#event-dragstart Original Ext JS documentation of 'dragstart'
   * @see ext.drag.DragSource
   * @eventType onDragStart
   */
  public static const DRAG_START:String = "onDragStart";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "info", "event", "eOpts"];

  public function DragSource_info_eventEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The event.
   */
  public native function get event():Event;

  /**
   * The drag info.
   */
  public native function get info():DragInfo;

  /**
   * This source.
   */
  public native function get source():DragSource;
}
}