package ext.drag.proxy {
import ext.Base;
import ext.dom.Element;
import ext.drag.DragInfo;
import ext.mixin.IFactoryable;

[Native("Ext.drag.proxy.None", require)]
/**
 * A base class for drag proxies that are shown to represent the
 * dragged item during a drag.
 * <p>Default implementations are:</p>
 * <ul>
 * <li>→<code>ext.drag.proxy.OriginalDragProxy</code>: Moves the original element.</li>
 * <li>→<code>ext.drag.proxy.PlaceholderDragProxy</code>: Creates a new element each drag.</li>
 * </ul>
 * <p>This implementation does not provide a proxy element, so it can be used
 * for cursor tracking only.</p>
 * @see ext.drag.proxy.OriginalDragProxy
 * @see ext.drag.proxy.PlaceholderDragProxy
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.None.html Original Ext JS documentation of 'Ext.drag.proxy.None'
 */
public class NoneDragProxy extends Base implements IFactoryable {
  /**
   * @inheritDoc
   */
  public native function get factoryConfig():Object;

  /**
   * @inheritDoc
   */
  public native function set factoryConfig(value:Object):void;

  /**
   * Perform any cleanup required. This is called as the drag ends.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.None.html#method-cleanup Original Ext JS documentation of 'cleanup'
   */
  protected native function cleanup():void;

  /**
   * Get the proxy element for the drag source. This is called as
   * the drag starts. This element may be cached on the instance and
   * reused.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info Drag info
   * @return The element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.None.html#method-getElement Original Ext JS documentation of 'getElement'
   */
  protected native function getElement(info:DragInfo):Element;

  /**
   * Called when the target changes for the active drag. This may
   * mean the target is now <code>null</code>.
   * <p class="template-method"><i>This is a template method, a hook into the functionality of this class. Feel free to override it in child classes.</i></p>
   * @param info Drag info
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.None.html#method-update Original Ext JS documentation of 'update'
   */
  protected native function update(info:DragInfo):void;
}
}