package ext.drag.proxy {
import ext.dom.Element;
import ext.drag.DragInfo;

[Native("Ext.drag.proxy.Placeholder", require)]
/**
 * A drag proxy that creates a new element to follow the cursor.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html Original Ext JS documentation of 'Ext.drag.proxy.Placeholder'
 */
public class PlaceholderDragProxy extends NoneDragProxy {
  [ExtConfig]
  [Bindable]
  /**
   * A class for this proxy.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#cfg-cls Original Ext JS documentation of 'cls'
   * @see #getCls()
   * @see #setCls()
   */
  public native function get cls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set cls(value:String):void;

  [ArrayElementType("Number")]
  [ExtConfig]
  [Bindable]
  /**
   * Determines the position of the proxy in relation
   * to the cursor.
   * @default [
   *     12,
   *     20
   * ]
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#cfg-cursorOffset Original Ext JS documentation of 'cursorOffset'
   * @see #getCursorOffset()
   * @see #setCursorOffset()
   */
  public native function get cursorOffset():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set cursorOffset(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The html for this proxy.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#cfg-html Original Ext JS documentation of 'html'
   * @see #getHtml()
   * @see #setHtml()
   */
  public native function get html():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set html(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A class to add to this proxy when over an
   * invalid <i>target</i> (→<code>ext.drag.DragTarget</code>).
   * @default ''
   * @see ext.drag.DragTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#cfg-invalidCls Original Ext JS documentation of 'invalidCls'
   * @see #getInvalidCls()
   * @see #setInvalidCls()
   */
  public native function get invalidCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set invalidCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A class to add to this proxy when over a
   * valid <i>target</i> (→<code>ext.drag.DragTarget</code>).
   * @default ''
   * @see ext.drag.DragTarget
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#cfg-validCls Original Ext JS documentation of 'validCls'
   * @see #getValidCls()
   * @see #setValidCls()
   */
  public native function get validCls():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set validCls(value:String):void;

  /**
   * Perform any cleanup required. This is called as the drag ends.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#method-cleanup Original Ext JS documentation of 'cleanup'
   */
  override protected native function cleanup():void;

  /**
   * Returns the value of <code>cls</code>.
   * @see #cls
   */
  public native function getCls():String;

  [ArrayElementType("Number")]
  /**
   * Returns the value of <code>cursorOffset</code>.
   * @see #cursorOffset
   */
  public native function getCursorOffset():Array;

  /**
   * Get the proxy element for the drag source. This is called as
   * the drag starts. This element may be cached on the instance and
   * reused.
   * @param info Drag info
   * @return The element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.drag.proxy.Placeholder.html#method-getElement Original Ext JS documentation of 'getElement'
   */
  override protected native function getElement(info:DragInfo):Element;

  /**
   * Returns the value of <code>html</code>.
   * @see #html
   */
  public native function getHtml():String;

  /**
   * Returns the value of <code>invalidCls</code>.
   * @see #invalidCls
   */
  public native function getInvalidCls():String;

  /**
   * Returns the value of <code>validCls</code>.
   * @see #validCls
   */
  public native function getValidCls():String;

  /**
   * Sets the value of <code>cls</code>.
   * @param cls The new value.
   * @see #cls
   */
  public native function setCls(cls:String):void;

  [ArrayElementType("Number")]
  /**
   * Sets the value of <code>cursorOffset</code>.
   * @param cursorOffset The new value.
   * @see #cursorOffset
   */
  public native function setCursorOffset(cursorOffset:Array):void;

  /**
   * Sets the value of <code>html</code>.
   * @param html The new value.
   * @see #html
   */
  public native function setHtml(html:String):void;

  /**
   * Sets the value of <code>invalidCls</code>.
   * @param invalidCls The new value.
   * @see #invalidCls
   */
  public native function setInvalidCls(invalidCls:String):void;

  /**
   * Sets the value of <code>validCls</code>.
   * @param validCls The new value.
   * @see #validCls
   */
  public native function setValidCls(validCls:String):void;
}
}