package ext.draw {
[Native("Ext.draw.Container", require)]
/**
 * @see ext.draw.events.DrawContainer_sizeEvent.BODY_RESIZE
 * @eventType ext.draw.events.DrawContainer_sizeEvent.BODY_RESIZE
 */
[Event(name='onBodyResize', type='ext.draw.events.DrawContainer_sizeEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_CLICK
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_CLICK
 */
[Event(name='onSpriteClick', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_DBLCLICK
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_DBLCLICK
 */
[Event(name='onSpriteDblclick', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_DOWN
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_DOWN
 */
[Event(name='onSpriteMouseDown', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_MOVE
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_MOVE
 */
[Event(name='onSpriteMouseMove', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_OUT
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_OUT
 */
[Event(name='onSpriteMouseOut', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_OVER
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_OVER
 */
[Event(name='onSpriteMouseOver', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_UP
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_MOUSE_UP
 */
[Event(name='onSpriteMouseUp', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * @see ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_TAP
 * @eventType ext.draw.events.DrawContainer_sprite_eventEvent.SPRITE_TAP
 */
[Event(name='onSpriteTap', type='ext.draw.events.DrawContainer_sprite_eventEvent')]
/**
 * The container that holds and manages instances of the →<code>ext.draw.Surface</code>
 * in which <i>sprites</i> (→<code>ext.draw.sprite.Sprite</code>) are rendered. Draw containers are
 * used as the foundation for all of the chart classes but may also be created directly
 * in order to create custom drawings.
 * <p><b>Example:</b></p>
 * <pre>
 * var drawContainer = Ext.create('Ext.draw.Container', {
 *     renderTo: Ext.getBody(),
 *     width:200,
 *     height:200,
 *     sprites: [{
 *         type: 'circle',
 *         fillStyle: '#79BB3F',
 *         r: 100,
 *         x: 100,
 *         y: 100
 *      }]
 * });
 *
 * // Uncomment to trigger a download of the painted circle.
 * // drawContainer.download({
 * //     filename: 'Circle',
 * //     url: 'http://svg.sencha.io' // Default server the image data is sent to.
 * // });
 * </pre>
 * <p>In the previous example we created a draw container and configured it with a single
 * sprite. The <i>type</i> of the sprite is <i>circle</i> (→<code>ext.draw.sprite.CircleSprite</code>), so if you
 * run this code you'll see a green circle.</p>
 * <p>You can attach sprite event listeners to the draw container with the help of the
 * →<code>ext.draw.plugin.SpriteEventsPlugin</code> plugin.</p>
 * <p>For more information on sprites, the core elements added to a draw container's
 * surface, refer to the Ext.draw.sprite.Sprite documentation.</p>
 * <p>For more information on surfaces, the interface owned by the draw container used to
 * manage all sprites, see the Ext.draw.Surface documentation.</p>
 * @see ext.draw.Surface
 * @see ext.draw.sprite.Sprite
 * @see ext.draw.sprite.CircleSprite
 * @see ext.draw.plugin.SpriteEventsPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html Original Ext JS documentation of 'Ext.draw.Container'
 */
public class DrawContainer extends DrawContainerBase {
  /**
   * @inheritDoc
   */
  public function DrawContainer(config:DrawContainer = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The default URL used by the →<code>download()</code> method.
   * @default undefined
   * @see #download()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#cfg-downloadServerUrl Original Ext JS documentation of 'downloadServerUrl'
   * @see #getDownloadServerUrl()
   * @see #setDownloadServerUrl()
   */
  public native function get downloadServerUrl():String;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set downloadServerUrl(value:String):void;

  [ExtConfig]
  /**
   * Defines the engine (type of surface) used to render draw container contents.
   * <p>The render engine is selected automatically depending on the platform used. Priority
   * is given to the →<code>ext.draw.engine.Canvas</code> engine due to its performance advantage.</p>
   * <p>You may also set the engine config to be <code>→ext.draw.engine.Svg</code> if so desired.</p>
   * @default "Ext.draw.engine.Canvas"
   * @see ext.draw.engine.Canvas
   * @see ext.draw.engine.Svg
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#cfg-engine Original Ext JS documentation of 'engine'
   */
  public native function get engine():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set engine(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * Defines a set of gradients that can be used as color properties
   * (fillStyle and strokeStyle, but not shadowColor) in sprites.
   * The gradients array is an array of objects with the following properties:
   * <ul>
   * <li><b>id</b> - string - The unique name of the gradient.</li>
   * <li><b>type</b> - string, optional - The type of the gradient. Available types are: 'linear',
   * 'radial'. Defaults to 'linear'.</li>
   * <li><b>angle</b> - number, optional - The angle of the gradient in degrees.</li>
   * <li><b>stops</b> - array - An array of objects with 'color' and 'offset' properties, where
   * 'offset' is a real number from 0 to 1.</li>
   * </ul>
   * <p>For example:</p>
   * <pre>
   * gradients: [{
   *     id: 'gradientId1',
   *     type: 'linear',
   *     angle: 45,
   *     stops: [{
   *         offset: 0,
   *         color: 'red'
   *     }, {
   *        offset: 1,
   *        color: 'yellow'
   *     }]
   * }, {
   *    id: 'gradientId2',
   *    type: 'radial',
   *    stops: [{
   *        offset: 0,
   *        color: '#555',
   *    }, {
   *        offset: 1,
   *        color: '#ddd',
   *    }]
   * }]
   * </pre>
   * <p>Then the sprites can use 'gradientId1' and 'gradientId2' by setting the color attributes
   * to those ids, for example:</p>
   * <pre>
   * sprite.setAttributes({
   *     fillStyle: 'url(#gradientId1)',
   *     strokeStyle: 'url(#gradientId2)'
   * });
   * </pre>
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#cfg-gradients Original Ext JS documentation of 'gradients'
   * @see #getGradients()
   * @see #setGradients()
   */
  public native function get gradients():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set gradients(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The resize function that can be configured to have a behavior,
   * e.g. resize draw surfaces based on new draw container dimensions.
   * The <code>→resizeHandler</code> function takes a single parameter -
   * the size object with <code>→width</code> and <code>→height</code> properties.
   * <p><b>Note:</b> Since resize events trigger →<code>renderFrame()</code> calls automatically,
   * return <code>false</code> from the resize function, if it also calls <code>→renderFrame()</code>,
   * to prevent double rendering.</p>
   * @see #resizeHandler
   * @see #width
   * @see #height
   * @see #renderFrame()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#cfg-resizeHandler Original Ext JS documentation of 'resizeHandler'
   * @see #getResizeHandler()
   * @see #setResizeHandler()
   */
  public native function get resizeHandler():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set resizeHandler(value:Function):void;

  [ExtConfig]
  [Bindable]
  /**
   * Defines a set of sprites to be added to the drawContainer surface.
   * <p>For example:</p>
   * <pre>
   *  sprites: [{
   *       type: 'circle',
   *       fillStyle: '#79BB3F',
   *       r: 100,
   *       x: 100,
   *       y: 100
   *  }]
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#cfg-sprites Original Ext JS documentation of 'sprites'
   * @see #getSprites()
   * @see #setSprites()
   */
  public native function get sprites():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sprites(value:Array):void;

  /**
   * Downloads an image or PDF of the chart / drawing or opens it in a separate
   * browser tab/window if the download can't be triggered. The exact behavior is
   * platform and browser specific. For more consistent results on mobile devices use
   * the →<code>preview()</code> method instead. This method doesn't work in IE8.
   * <p>Important: The default download mechanism sends image data to <code>http://svg.sencha.io</code>,
   * which is a server operated by Sencha. This can be changed by setting
   * the →<code>downloadServerUrl</code> config to the address of another server.</p>
   * <p>You can deploy your own server by using the code from the <code>server</code> directory
   * in the Charts package. The server is Node.js based and uses PhantomJS to
   * generate images and PDFs from received data.</p>
   * <p>The warning that the default download server is used can be suppressed
   * by explicitly setting the value of the →<code>downloadServerUrl</code> config
   * to <code>http://svg.sencha.io</code>.</p>
   * @param config The following config options are supported:
   * <ul>
   * <li><code>url:String</code> (optional) —
   * The url to post the data to. Defaults to
   * the value of the →<code>downloadServerUrl</code> config.
   * </li>
   * <li><code>format:String</code> (optional) —
   * The format of image to export. See the
   * →<code>supportedFormats</code>. Defaults to 'png' on the Sencha IO server.
   * Note that you can't export to 'svg' format if the →<code>ext.draw.engine.Canvas</code>
   * →<code>ext.draw.DrawContainer.engine</code> is used.
   * </li>
   * <li><code>width:Number</code> (optional) —
   * A width to send to the server for
   * configuring the image width. Defaults to natural image width on
   * the Sencha IO server.
   * </li>
   * <li><code>height:Number</code> (optional) —
   * A height to send to the server for
   * configuring the image height. Defaults to natural image height on
   * the Sencha IO server.
   * </li>
   * <li><code>filename:String</code> (optional) —
   * The filename of the downloaded image.
   * Defaults to 'chart' on the Sencha IO server. The config.format is used
   * as a filename extension.
   * </li>
   * <li><code>scale:Number</code> (optional) —
   * The scaling of the downloaded image.
   * Defaults to 1 on the Sencha IO server. The server will try to determine the natural
   * size of the image unless the width/height configs have been set. If the
   * →<code>ext.draw.engine.Canvas</code> →<code>ext.draw.DrawContainer.engine</code> is
   * used the natural image size will depend on the value of the window.devicePixelRatio.
   * For example, for devices with devicePixelRatio of 2 the produced image will be
   * two times larger than for devices with devicePixelRatio of 1 for the same drawing.
   * This is done so that the users with devices with HiDPI screens get a downloaded
   * image that looks as crisp on their device as the original drawing.
   * If you want image size to be consistent across devices with different device
   * pixel ratios, you can set the value of this config to 1/devicePixelRatio.
   * This parameter is ignored by the Sencha IO server if config.format is set to 'svg'.
   * </li>
   * <li><code>pdf:Object</code> (optional) —
   * PDF specific options.
   * This config is only used if config.format is set to 'pdf'.
   * The given object should be in either this format:
   * <pre>
   * {
   *   width: '200px',
   *   height: '300px',
   *   border: '0px'
   * }
   * </pre>
   * <p>or this format:</p>
   * <pre>
   * {
   *   format: 'A4',
   *   orientation: 'portrait',
   *   border: '1cm'
   * }
   * </pre>
   * <p>Supported dimension units are: 'mm', 'cm', 'in', 'px'. No unit means 'px'.
   * Supported formats are: 'A3', 'A4', 'A5', 'Legal', 'Letter', 'Tabloid'.
   * Orientation ('portrait', 'landscape') is optional and defaults to 'portrait'.</p>
   * </li>
   * <li><code>jpeg:Object</code> (optional) —
   * JPEG specific options.
   * This config is only used if config.format is set to 'jpeg'.
   * The given object should be in this format:
   * <pre>
   * {
   *   quality: 80
   * }
   * </pre>
   * <p>Where quality is an integer between 0 and 100.</p>
   * </li>
   * </ul>
   * @return True if request was successfully sent to the server.
   * @see #preview()
   * @see #downloadServerUrl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#method-download Original Ext JS documentation of 'download'
   * @see #supportedFormats
   * @see ext.draw.engine.Canvas
   * @see ext.draw.DrawContainer#engine
   */
  public native function download(config:Object = null):Boolean;

  /**
   * Returns the value of <code>downloadServerUrl</code>.
   * @see #downloadServerUrl
   */
  public native function getDownloadServerUrl():String;

  /**
   * Returns the value of <code>gradients</code>.
   * @see #gradients
   */
  public native function getGradients():Array;

  /**
   * Produces an image of the chart / drawing.
   * @param format Possible options are 'image' (the method will return an
   * Image object) and 'stream' (the method will return the image as a byte stream).
   * If missing, the data URI of the drawing's (or chart's) image will be returned.
   * Note: for an SVG based drawing/chart in IE/Edge browsers the method will always
   * return SVG markup instead of a data URI, as 'img' elements won't accept a data
   * URI anyway in those browsers.
   * @return
   * <ul>
   * <li><code>data:String</code> (optional) —
   * Image element, byte stream or DataURL.
   * </li>
   * <li><code>type:String</code> (optional) —
   * The type of the data (e.g. 'png' or 'svg').
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#method-getImage Original Ext JS documentation of 'getImage'
   */
  public native function getImage(format:String = null):Object;

  /**
   * Returns the value of <code>resizeHandler</code>.
   * @see #resizeHandler
   */
  public native function getResizeHandler():Function;

  /**
   * Returns the value of <code>sprites</code>.
   * @see #sprites
   */
  public native function getSprites():Array;

  /**
   * Get a surface by the given id or create one if it doesn't exist.
   * This will automatically call the →<code>resizeHandler</code>. Which
   * means that, if no custom resize handler has been provided, the
   * surface will be sized to match the container.
   * If the →<code>add()</code> method is used, it is the responsibility
   * of the user to call the →<code>handleResize()</code> method, to update
   * the size of all added surfaces.
   * @param id
   * @default "main"
   * @see #resizeHandler
   * @see #add()
   * @see #handleResize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#method-getSurface Original Ext JS documentation of 'getSurface'
   */
  public native function getSurface(id:String = "main", type:String = null):Surface;

  /**
   * Triggers the →<code>resizeHandler</code> with the size of the draw container
   * element as the parameter.
   * @see #resizeHandler
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#method-handleResize Original Ext JS documentation of 'handleResize'
   */
  public native function handleResize(size:*, instantly:*):void;

  /**
   * Displays an image of a Ext.draw.Container on screen.
   * On mobile devices this lets users tap-and-hold to bring up the menu
   * with image saving options.
   * Notes:
   * <ul>
   * <li>some browsers won't save the preview image if it's SVG based
   * (i.e. generated from a draw container that uses 'Ext.draw.engine.Svg' engine);</li>
   * <li>some platforms may not have the means of viewing successfully saved SVG images;</li>
   * <li>this method does not work on IE8.</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#method-preview Original Ext JS documentation of 'preview'
   */
  public native function preview():void;

  /**
   * Render all the surfaces in the container.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Container.html#method-renderFrame Original Ext JS documentation of 'renderFrame'
   */
  public native function renderFrame():void;

  /**
   * Sets the value of <code>downloadServerUrl</code>.
   * @param downloadServerUrl The new value.
   * @see #downloadServerUrl
   */
  public native function setDownloadServerUrl(downloadServerUrl:String):void;

  /**
   * Sets the value of <code>gradients</code>.
   * @param gradients The new value.
   * @see #gradients
   */
  public native function setGradients(gradients:Array):void;

  /**
   * Sets the value of <code>resizeHandler</code>.
   * @param resizeHandler The new value.
   * @see #resizeHandler
   */
  public native function setResizeHandler(resizeHandler:Function):void;

  /**
   * Sets the value of <code>sprites</code>.
   * @param sprites The new value.
   * @see #sprites
   */
  public native function setSprites(sprites:Array):void;
}
}