package ext.draw {
import ext.panel.Panel;

[Native("Ext.draw.ContainerBase", require)]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.ContainerBase.html Original Ext JS documentation of 'Ext.draw.ContainerBase'
 */
public class DrawContainerBase extends Panel {
  /**
   * @inheritDoc
   */
  public function DrawContainerBase(config:DrawContainerBase = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The text to place in the Preview image alt attribute.
   * @default 'Chart preview'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.ContainerBase.html#cfg-previewAltText Original Ext JS documentation of 'previewAltText'
   */
  public native function get previewAltText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set previewAltText(value:String):void;

  [ExtConfig]
  /**
   * The text to place in Preview Chart window title.
   * @default 'Chart Preview'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.ContainerBase.html#cfg-previewTitleText Original Ext JS documentation of 'previewTitleText'
   */
  public native function get previewTitleText():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set previewTitleText(value:String):void;
}
}