package ext.draw {
import ext.Base;

[Native("Ext.draw.Path", require)]
/**
 * Class representing a path.
 * Designed to be compatible with <a href="http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#canvaspathmethods">CanvasPathMethods</a>
 * and will hopefully be replaced by the browsers' implementation of the Path object.
 * <p><b>From override Ext.draw.overrides.hittest.Path:</b></p>
 * Adds hit testing and path intersection points methods to the Ext.draw.Path.
 * Included by the Ext.draw.PathUtil.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html Original Ext JS documentation of 'Ext.draw.Path'
 */
public class Path extends Base {
  /**
   * Create a path from pathString.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Path(pathString:String) {
    super();
  }

  /**
   * Create an circular arc.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-arc Original Ext JS documentation of 'arc'
   */
  public native function arc(x:Number, y:Number, radius:Number, startAngle:Number, endAngle:Number, anticlockwise:Number):void;

  /**
   * <a href="http://www.w3.org/TR/SVG/implnote.html#ArcImplementationNotes">http://www.w3.org/TR/SVG/implnote.html#ArcImplementationNotes</a>
   * @param rx
   * @param ry
   * @param rotation Differ from svg spec, this is radian.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-arcSvg Original Ext JS documentation of 'arcSvg'
   */
  public native function arcSvg(rx:Number, ry:Number, rotation:Number, fA:Number, fS:Number, x2:Number, y2:Number):void;

  /**
   * Create a elliptic arc curve compatible with SVG's arc to instruction.
   * <p>The curve start from (<code>x1</code>, <code>y1</code>) and ends at (<code>x2</code>, <code>y2</code>). The ellipse
   * has radius <code>rx</code> and <code>ry</code> and a rotation of <code>rotation</code>.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-arcTo Original Ext JS documentation of 'arcTo'
   */
  public native function arcTo(x1:Number, y1:Number, x2:Number, y2:Number, rx:Number = NaN, ry:Number = NaN, rotation:Number = NaN):void;

  /**
   * A cubic bezier curve to a position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-bezierCurveTo Original Ext JS documentation of 'bezierCurveTo'
   */
  public native function bezierCurveTo(cx1:Number, cy1:Number, cx2:Number, cy2:Number, x:Number, y:Number):void;

  /**
   * Clear the path.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Clone this path.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():Path;

  /**
   * Close this path with a straight line.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-closePath Original Ext JS documentation of 'closePath'
   */
  public native function closePath():void;

  /**
   * Create an elliptic arc.
   * <p>See <a href="http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#dom-context-2d-ellipse">the whatwg reference of ellipse</a>.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-ellipse Original Ext JS documentation of 'ellipse'
   */
  public native function ellipse(cx:Number, cy:Number, radiusX:Number, radiusY:Number, rotation:Number, startAngle:Number, endAngle:Number, anticlockwise:Number):void;

  /**
   * Reconstruct path from cubic bezier curve stripes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-fromStripes Original Ext JS documentation of 'fromStripes'
   */
  public native function fromStripes(stripes:Array):void;

  /**
   * Feed the path from svg path string.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-fromSvgString Original Ext JS documentation of 'fromSvgString'
   */
  public native function fromSvgString(pathString:String):void;

  /**
   * Get the bounding box of this matrix.
   * @param target Optional object to receive the result.
   * @return Object with x, y, width and height
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-getDimension Original Ext JS documentation of 'getDimension'
   */
  public native function getDimension(target:Object = null):Object;

  /**
   * Get the bounding box as if the path is transformed by a matrix.
   * @param matrix
   * @param target Optional object to receive the result.
   * @return An object with x, y, width and height.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-getDimensionWithTransform Original Ext JS documentation of 'getDimensionWithTransform'
   */
  public native function getDimensionWithTransform(matrix:Matrix, target:Object = null):Object;

  /**
   * Calculates the points where the given segment intersects the path.
   * If four parameters are given then the segment is considered to be a line segment,
   * where given parameters are the coordinates of the start and end points.
   * If eight parameters are given then the segment is considered to be
   * a cubic Bezier curve segment, where given parameters are the
   * coordinates of its edge points and control points.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-getSegmentIntersections Original Ext JS documentation of 'getSegmentIntersections'
   */
  public native function getSegmentIntersections(x1:*, y1:*, x2:*, y2:*, x3:*, y3:*, x4:*, y4:*):Array;

  /**
   * Tests whether the given point is inside the path.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-isPointInPath Original Ext JS documentation of 'isPointInPath'
   */
  public native function isPointInPath(x:Number, y:Number):Boolean;

  /**
   * Tests whether the given point is on the path.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-isPointOnPath Original Ext JS documentation of 'isPointOnPath'
   */
  public native function isPointOnPath(x:Number, y:Number):Boolean;

  /**
   * A straight line to a position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-lineTo Original Ext JS documentation of 'lineTo'
   */
  public native function lineTo(x:Number, y:Number):void;

  /**
   * Move to a position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-moveTo Original Ext JS documentation of 'moveTo'
   */
  public native function moveTo(x:Number, y:Number):void;

  /**
   * A quadratic bezier curve to a position.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-quadraticCurveTo Original Ext JS documentation of 'quadraticCurveTo'
   */
  public native function quadraticCurveTo(cx:Number, cy:Number, x:Number, y:Number):void;

  /**
   * Draw a rectangle and close it.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-rect Original Ext JS documentation of 'rect'
   */
  public native function rect(x:Number, y:Number, width:Number, height:Number):void;

  /**
   * Return an svg path string for this path.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-toString Original Ext JS documentation of 'toString'
   */
  public native function toString():String;

  /**
   * Convert path to bezier curve stripes.
   * @param target The optional array to receive the result.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-toStripes Original Ext JS documentation of 'toStripes'
   */
  public native function toStripes(target:Array = null):Array;

  /**
   * Transform the current path by a matrix.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Path.html#method-transform Original Ext JS documentation of 'transform'
   */
  public native function transform(matrix:Matrix):void;
}
}