package ext.draw {
import ext.Base;

[Native("Ext.draw.Point", require)]
/**
 * A helper class to facilitate common operations on points and vectors.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html Original Ext JS documentation of 'Ext.draw.Point'
 */
public class Point extends Base {
  /**
   * Creates a flyweight Ext.draw.Point instance.
   * Takes the same parameters as the →<code>ext.draw.Point.constructor()</code>.
   * Do not hold the instance of the flyweight point.
   * @see ext.draw.Point#constructor()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#static-method-fly Original Ext JS documentation of 'fly'
   */
  public static native function fly(point:*):Point;

  /**
   * Creates a point.
   * <pre>
   * new Ext.draw.Point(3, 4);
   * new Ext.draw.Point(3); // both x and y equal 3
   * new Ext.draw.Point([3, 4]);
   * new Ext.draw.Point({x: 3, y: 4});
   * new Ext.draw.Point(p); // where `p` is a Ext.draw.Point instance.
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-constructor Original Ext JS documentation of 'constructor'
   */
  public function Point(x:*, y:*) {
    super();
  }

  /**
   * Returns a new point with absolute values of the x and y values of this point.
   * This point is not modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-abs Original Ext JS documentation of 'abs'
   */
  public native function abs(x:*, y:*):Point;

  /**
   * Adds another vector to this one and returns the resulting vector
   * without changing this vector.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(x:*, y:*):Point;

  /**
   * Returns a new point with ceiled x and y values. This point is not modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-ceil Original Ext JS documentation of 'ceil'
   */
  public native function ceil():Point;

  /**
   * Returns a copy of the point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-clone Original Ext JS documentation of 'clone'
   */
  public native function clone():Point;

  /**
   * Returns a vector which coordinates are the result of division of this vector's
   * coordinates by the given number. This vector is not modified.
   * This vector is not modified.
   * @param n The denominator.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-div Original Ext JS documentation of 'div'
   */
  public native function div(n:Number):Point;

  /**
   * Returns the dot product of this vector and the given vector.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-dot Original Ext JS documentation of 'dot'
   */
  public native function dot(x:*, y:*):Number;

  /**
   * Checks whether coordinates of the point match those of the point provided.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-equals Original Ext JS documentation of 'equals'
   */
  public native function equals(x:*, y:*):Boolean;

  /**
   * Returns a new point with floored x and y values. This point is not modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-floor Original Ext JS documentation of 'floor'
   */
  public native function floor():Point;

  /**
   * Returns the vector from the point perpendicular to the line (shortest distance).
   * Where line is specified using two points or the coordinates of those points.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-getDistanceToLine Original Ext JS documentation of 'getDistanceToLine'
   */
  public native function getDistanceToLine(p1:Point, p2:Point):Point;

  /**
   * Checks if both x and y coordinates of the point are valid numbers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-isNumber Original Ext JS documentation of 'isNumber'
   */
  public native function isNumber():Boolean;

  /**
   * Checks if both x and y coordinates of the point are zero.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-isZero Original Ext JS documentation of 'isZero'
   */
  public native function isZero():Boolean;

  /**
   * Returns the result of scalar multiplication of this vector by the given factor.
   * This vector is not modified.
   * @param n The factor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-mul Original Ext JS documentation of 'mul'
   */
  public native function mul(n:Number):Point;

  /**
   * Normalizes the vector by changing its length to 1 without changing its angle.
   * The returned result is a normalized vector. This vector is not modified.
   * @param factor Multiplication factor. Defaults to 1.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-normalize Original Ext JS documentation of 'normalize'
   */
  public native function normalize(factor:Number = 1):Point;

  /**
   * Rotates the point by the given angle. This point is not modified.
   * @param angle The rotation angle.
   * @param center The center of rotation (optional). Defaults to origin.
   * @return The rotated point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-rotate Original Ext JS documentation of 'rotate'
   */
  public native function rotate(angle:Number, center:Point = null):Point;

  /**
   * Returns a new point with rounded x and y values. This point is not modified.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-round Original Ext JS documentation of 'round'
   */
  public native function round():Point;

  /**
   * Sets coordinates of the point.
   * Takes the same parameters as the →<code>constructor()</code>.
   * @see #constructor()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-set Original Ext JS documentation of 'set'
   */
  public native function set(x:*, y:*):void;

  /**
   * Sets the angle of the vector (measured from the x-axis to the vector)
   * without changing its length.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-setAngle Original Ext JS documentation of 'setAngle'
   */
  public native function setAngle(angle:Number):void;

  /**
   * Sets the length of the vector without changing its angle.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-setLength Original Ext JS documentation of 'setLength'
   */
  public native function setLength(length:Number):void;

  /**
   * Sets both the angle and the length of the vector.
   * A point can be thought of as a vector pointing from the origin to the point's location.
   * This can also be interpreted as setting coordinates of a point in the polar
   * coordinate system.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-setPolar Original Ext JS documentation of 'setPolar'
   */
  public native function setPolar(angle:Number, length:Number):void;

  /**
   * Sets the x-coordinate of the point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-setX Original Ext JS documentation of 'setX'
   */
  public native function setX(x:Number):void;

  /**
   * Sets the y-coordinate of the point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-setY Original Ext JS documentation of 'setY'
   */
  public native function setY(y:Number):void;

  /**
   * Subtracts another vector from this one and returns the resulting vector
   * without changing this vector.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-sub Original Ext JS documentation of 'sub'
   */
  public native function sub(x:*, y:*):Point;

  /**
   * Transforms the point from one coordinate system to another
   * using the transformation matrix provided. This point is not modified.
   * @param matrix A trasformation matrix or its elements.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Point.html#method-transform Original Ext JS documentation of 'transform'
   */
  public native function transform(matrix:*):Point;
}
}