package ext.draw {
import ext.Base;

[Native]
/**
 * Singleton class that manages the animation pool.
 * <p>Type of singleton Animator.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html Original Ext JS documentation of 'Ext.draw.Animator'
 * @see ext.draw.#Animator ext.draw.Animator
 */
public class SAnimator extends Base {
  /**
   * Adds an animated object to the animation pool.
   * @param animation The animation descriptor to add to the pool.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(animation:Object):void;

  /**
   * Register a recursive callback that will be called at every frame.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-addFrameCallback Original Ext JS documentation of 'addFrameCallback'
   */
  public native function addFrameCallback(callback:Function, scope:Object):String;

  /**
   * Cross platform <code>→animationTime()</code> implementation.
   * @see SAnimator#animationTime()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-animationTime Original Ext JS documentation of 'animationTime'
   */
  public native function animationTime():Number;

  /**
   * Cancel a registered one-time callback
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-cancel Original Ext JS documentation of 'cancel'
   */
  public native function cancel(id:String):void;

  /**
   * Returns <code>true</code> or <code>false</code> whether it contains the given animation or not.
   * @param animation The animation to check for.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-contains Original Ext JS documentation of 'contains'
   */
  public native function contains(animation:Object):Boolean;

  /**
   * Returns <code>true</code> or <code>false</code> whether the pool is empty or not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-empty Original Ext JS documentation of 'empty'
   */
  public native function empty():Boolean;

  /**
   * Removes an animation from the pool.
   * TODO: This is broken when called within <code>→step()</code> method.
   * @param animation The animation to remove from the pool.
   * @see SAnimator#step()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(animation:Object):void;

  /**
   * Unregister a recursive callback.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-removeFrameCallback Original Ext JS documentation of 'removeFrameCallback'
   */
  public native function removeFrameCallback(id:String):void;

  /**
   * Register a one-time callback that will be called at the next frame.
   * @return The ID of the scheduled callback.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-schedule Original Ext JS documentation of 'schedule'
   */
  public native function schedule(callback:*, scope:Object):String;

  /**
   * Register a one-time callback that will be called at the next frame,
   * if that callback (with a matching function and scope) isn't already scheduled.
   * @return The ID of the scheduled callback or null, if that callback
   * has already been scheduled.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-scheduleIf Original Ext JS documentation of 'scheduleIf'
   */
  public native function scheduleIf(callback:*, scope:Object):*;

  /**
   * Given a frame time it will filter out finished animations from the pool.
   * @param frameTime The frame's start time, in milliseconds.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Animator.html#method-step Original Ext JS documentation of 'step'
   */
  public native function step(frameTime:Number):void;
}
}