package ext.draw {
import ext.Base;

[Native]
/**
 * Utility class providing mathematics functionalities through all the draw package.
 * <p>Type of singleton Draw.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html Original Ext JS documentation of 'Ext.draw.Draw'
 * @see ext.draw.#Draw ext.draw.Draw
 */
public class SDraw extends Base {
  /**
   * Converting radians to degrees.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-degrees Original Ext JS documentation of 'degrees'
   */
  public native function degrees(radian:Number):Number;

  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-isBBoxIntersect Original Ext JS documentation of 'isBBoxIntersect'
   */
  public native function isBBoxIntersect(bbox1:Object, bbox2:Object, padding:Number = NaN):Boolean;

  /**
   * Checks if a point is within a bounding box.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-isPointInBBox Original Ext JS documentation of 'isPointInBBox'
   */
  public native function isPointInBBox(x:*, y:*, bbox:*):Boolean;

  /**
   * Natural cubic spline interpolation.
   * This algorithm runs in linear time.
   * @param points Array of numbers.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-naturalSpline Original Ext JS documentation of 'naturalSpline'
   */
  public native function naturalSpline(points:Array):void;

  /**
   * Converting degrees to radians.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-rad Original Ext JS documentation of 'rad'
   */
  public native function rad(degrees:Number):Number;

  [Deprecated(replacement="identityFn", since="6.5.0")]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-reflectFn Original Ext JS documentation of 'reflectFn'
   */
  public native function reflectFn(a:*):*;

  /**
   * Given coordinates of the points, calculates coordinates of a Bezier curve
   * that goes through them.
   * @param dataX x-coordinates of the points.
   * @param dataY y-coordinates of the points.
   * @param value A value to control the smoothness of the curve.
   * @return Object holding two arrays, for x and y coordinates of the curve.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-smooth Original Ext JS documentation of 'smooth'
   */
  public native function smooth(dataX:*, dataY:*, value:*):Object;

  /**
   * Shorthand for →<code>naturalSpline()</code>
   * @see SDraw#naturalSpline()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Draw.html#method-spline Original Ext JS documentation of 'spline'
   */
  public native function spline(points:*):void;
}
}