package ext.draw {
import ext.Base;

[Native]
/**
 * Utility class to provide a way to <i>approximately</i> measure the dimension of text
 * without a drawing context.
 * <p>Type of singleton TextMeasurer.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.TextMeasurer.html Original Ext JS documentation of 'Ext.draw.TextMeasurer'
 * @see ext.draw.#TextMeasurer ext.draw.TextMeasurer
 */
public class STextMeasurer extends Base {
  [ExtConfig]
  /**
   * This singleton tries not to make use of the Ext.util.TextMetrics because it is
   * several times slower than TextMeasurer's own solution. TextMetrics is more precise
   * though, so if you have a case where the error is too big, you may want to set
   * this config to <code>true</code> to get perfect results at the expense of performance.
   * Note: defaults to <code>true</code> in IE8.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.TextMeasurer.html#cfg-precise Original Ext JS documentation of 'precise'
   */
  public native function get precise():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set precise(value:Boolean):void;

  /**
   * Measure a text with specific font.
   * This will split the text to lines and add up their size.
   * That may <i>not</i> be the exact size of the text as it is displayed.
   * @return An object with <code>width</code>, <code>height</code> and <code>sizes</code> properties.
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * <li><code>sizes:Object</code> (optional) —
   * Results of individual line measurements, in case of multiline
   * text.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.TextMeasurer.html#method-measureText Original Ext JS documentation of 'measureText'
   */
  public native function measureText(text:String, font:String):Object;

  /**
   * Measure a single-line text with specific font.
   * This will split the text into characters and add up their size.
   * That may <i>not</i> be the exact size of the text as it is displayed.
   * @return An object with <code>width</code> and <code>height</code> properties.
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.TextMeasurer.html#method-measureTextSingleLine Original Ext JS documentation of 'measureTextSingleLine'
   */
  public native function measureTextSingleLine(text:String, font:String):Object;
}
}