package ext.draw {
import ext.Base;

[Native("Ext.draw.SegmentTree", require)]
/**
 * This class we summarize the data and returns it when required.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.SegmentTree.html Original Ext JS documentation of 'Ext.draw.SegmentTree'
 */
public class SegmentTree extends Base {
  /**
   * Returns the minimum range of data that fits the given range and step size.
   * @return The aggregation information.
   * <ul>
   * <li><code>start:Number</code> (optional)</li>
   * <li><code>end:Number</code> (optional)</li>
   * <li><code>data:Object</code> (optional) —
   * The aggregated data
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.SegmentTree.html#method-getAggregation Original Ext JS documentation of 'getAggregation'
   */
  public native function getAggregation(min:Number, max:Number, estStep:Number):Object;

  /**
   * Sets the data of the segment tree.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.SegmentTree.html#method-setData Original Ext JS documentation of 'setData'
   */
  public native function setData(dataX:Number, dataOpen:Number, dataHigh:Number, dataLow:Number, dataClose:Number):void;
}
}