package ext.draw {
import ext.draw.sprite.Sprite;

[Native("Ext.draw.Surface", require)]
/**
 * A surface is an interface to render <i>sprites</i> (→<code>ext.draw.sprite.Sprite</code>) inside a
 * <i>draw container</i> (→<code>ext.draw.DrawContainer</code>). The surface API has methods to render
 * sprites, get sprite bounding boxes (dimensions), add sprites to the underlying DOM,
 * and more.
 * <p>A surface is automatically created when a draw container is created. By default,
 * this will be a surface with an <code>id</code> of "main" and will manage all sprites in the draw
 * container (unless the sprite configs specify a unique surface "id").</p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *     xtype: 'draw',
 *     renderTo: document.body,
 *     width: 400,
 *     height: 400,
 *     sprites: [{
 *         type: 'rect',
 *         surface: 'anim',  // a surface with id "anim" will be created automatically
 *         x: 50,
 *         y: 50,
 *         width: 100,
 *         height: 100,
 *         fillStyle: '#1F6D91'
 *     }]
 * });
 * </pre>
 * <p>The ability to have multiple surfaces is useful for performance (and battery life)
 * reasons. Because changes to sprite attributes cause the whole surface (and all
 * sprites in it) to re-render, it makes sense to group sprites by surface, so changes
 * to one group of sprites will only trigger the surface they are in to re-render.</p>
 * <p>One of the more useful methods is the →<code>add()</code> method used to add sprites to the
 * surface:</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var drawCt = Ext.create({
 *     xtype: 'draw',
 *     renderTo: document.body,
 *     width: 400,
 *     height: 400
 * });
 *
 * // If the surface name is not specified then 'main' will be used
 * var surface = drawCt.getSurface();
 *
 * surface.add({
 *     type: 'rect',
 *     x: 50,
 *     y: 50,
 *     width: 100,
 *     height: 100,
 *     fillStyle: '#1F6D91'
 * });
 *
 * surface.renderFrame();
 * </pre>
 * <p><b>Note:</b> Changes to the sprites on a surface will be not be reflected in the DOM
 * until you call the surface's →<code>ext.draw.Surface.renderFrame()</code>
 * method. This must be done after adding, removing, or modifying sprites in order to
 * see the changes on-screen.</p>
 * <p><b>From override Ext.draw.overrides.hittest.Surface:</b></p>
 * Adds hit testing methods to the Ext.draw.Surface.
 * Included by the Ext.draw.plugin.SpriteEvents.
 * @see ext.draw.sprite.Sprite
 * @see ext.draw.DrawContainer
 * @see #add()
 * @see ext.draw.Surface#renderFrame()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html Original Ext JS documentation of 'Ext.draw.Surface'
 */
public class Surface extends SurfaceBase {
  [Deprecated(replacement="sort", since="5.1.0")]
  /**
   * @return Sorted array.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#static-method-stableSort Original Ext JS documentation of 'stableSort'
   */
  public static native function stableSort(list:Array):Array;

  /**
   * @inheritDoc
   */
  public function Surface(config:Surface = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Background sprite config of the surface.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#cfg-background Original Ext JS documentation of 'background'
   * @see #getBackground()
   * @see #setBackground()
   */
  public native function get background():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set background(value:Object):void;

  /**
   * The reported device pixel density.
   * devicePixelRatio is only supported from IE11,
   * so we use deviceXDPI and logicalXDPI that are supported from IE6.
   * @default window.devicePixelRatio || window.screen.deviceXDPI / window.screen.logicalXDPI
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#property-devicePixelRatio Original Ext JS documentation of 'devicePixelRatio'
   */
  public native function get devicePixelRatio():*;

  /**
   * @private
   */
  public native function set devicePixelRatio(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * Indicates whether the surface needs to redraw.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#cfg-dirty Original Ext JS documentation of 'dirty'
   * @see #getDirty()
   * @see #setDirty()
   */
  public native function get dirty():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set dirty(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * If the surface is in the RTL mode, text will render with the RTL direction,
   * but the alignment and position of the text won't change by default.
   * Setting this config to 'true' will get text alignment and its position
   * within a surface mirrored.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#cfg-flipRtlText Original Ext JS documentation of 'flipRtlText'
   * @see #getFlipRtlText()
   * @see #setFlipRtlText()
   */
  public native function get flipRtlText():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set flipRtlText(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * Array of sprite instances.
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#cfg-items Original Ext JS documentation of 'items'
   * @see #getItems()
   * @see #setItems()
   */
  public native function get items():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set items(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The [x, y, width, height] rect of the surface related to its container.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#cfg-rect Original Ext JS documentation of 'rect'
   * @see #getRect()
   * @see #setRect()
   */
  public native function get rect():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set rect(value:Array):void;

  /**
   * Add a Sprite to the surface.
   * You can put any number of objects as the parameter.
   * See →<code>ext.draw.sprite.Sprite</code> for the configuration object to be passed
   * into this method.
   * <p>For example:</p>
   * <pre>
   * drawContainer.getSurface().add({
   *     type: 'circle',
   *     fill: '#ffc',
   *     radius: 100,
   *     x: 100,
   *     y: 100
   * });
   * drawContainer.renderFrame();
   * </pre>
   * @see ext.draw.sprite.Sprite
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(sprite:*):*;

  /**
   * Empty the surface content (without touching the sprites.)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Destroys the surface. This is done by removing all components from it and
   * also removing its reference to a DOM element.
   * <p>For example:</p>
   * <pre>
   *  drawContainer.surface.destroy();
   * </pre>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Flattens the given drawing surfaces into a single image
   * and returns an object containing the data (in the DataURL format)
   * and the type (e.g. 'png' or 'svg') of that image.
   * @param size The size of the final image.
   * <ul>
   * <li><code>width:Number</code> (optional)</li>
   * <li><code>height:Number</code> (optional)</li>
   * </ul>
   * @param surfaces The surfaces to flatten.
   * @return
   * <ul>
   * <li><code>data:String</code> (optional) —
   * The DataURL of the flattened image.
   * </li>
   * <li><code>type:String</code> (optional) —
   * The type of the image.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-flatten Original Ext JS documentation of 'flatten'
   */
  public native function flatten(size:Object, surfaces:Array):Object;

  /**
   * Get the sprite by id or index.
   * It will first try to find a sprite with the given id, otherwise will try to use the id
   * as an index.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-get Original Ext JS documentation of 'get'
   */
  public native function get(id:*):Sprite;

  /**
   * Return the minimal bounding box that contains all the sprites bounding boxes
   * in the given list of sprites.
   * @param sprites
   * @param isWithoutTransform
   * @default false
   * @return {{x: Number, y: Number, width: Number, height: Number}}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-getBBox Original Ext JS documentation of 'getBBox'
   */
  public native function getBBox(sprites:*, isWithoutTransform:Boolean = false):*;

  /**
   * Returns the value of <code>background</code>.
   * @see #background
   */
  public native function getBackground():Object;

  /**
   * Returns the value of <code>dirty</code>.
   * @see #dirty
   */
  public native function getDirty():Boolean;

  /**
   * Returns the value of <code>flipRtlText</code>.
   * @see #flipRtlText
   */
  public native function getFlipRtlText():Boolean;

  /**
   * Returns the value of <code>items</code>.
   * @see #items
   */
  public native function getItems():Array;

  /**
   * Returns the value of <code>rect</code>.
   * @see #rect
   */
  public native function getRect():Array;

  /**
   * Performs a hit test on all sprites in the surface, returning the first matching one.
   * @param point A two-item array containing x and y coordinates of the point
   * in surface coordinate system.
   * @param options Hit testing options.
   * @return A hit result object that contains more information about what
   * exactly was hit or null if nothing was hit.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-hitTest Original Ext JS documentation of 'hitTest'
   */
  public native function hitTest(point:Array, options:Object):Object;

  /**
   * Performs a hit test on all sprites in the surface, returning the first matching one.
   * Since hit testing is typically performed on mouse events, this convenience method
   * converts event's page coordinates to surface coordinates before calling →<code>hitTest()</code>.
   * @param event An event object.
   * @param options Hit testing options.
   * @return A hit result object that contains more information about what
   * exactly was hit or null if nothing was hit.
   * @see #hitTest()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-hitTestEvent Original Ext JS documentation of 'hitTestEvent'
   */
  public native function hitTestEvent(event:Object, options:Object):Object;

  /**
   * Invoked when a sprite is added to the surface.
   * @param sprite The sprite to be added.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-onAdd Original Ext JS documentation of 'onAdd'
   */
  protected native function onAdd(sprite:Sprite):void;

  /**
   * Remove a given sprite from the surface,
   * optionally destroying the sprite in the process.
   * You can also call the sprite's own <code>→remove()</code> method.
   * <p>For example:</p>
   * <pre>
   *  drawContainer.surface.remove(sprite);
   *  // or...
   *  sprite.remove();
   * </pre>
   * @param sprite A sprite instance or its ID.
   * @param isDestroy If <code>true</code>, the sprite will be destroyed.
   * @default false
   * @return Returns the removed/destroyed sprite or <code>null</code> otherwise.
   * @see #remove()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-remove Original Ext JS documentation of 'remove'
   */
  public native function remove(sprite:*, isDestroy:Boolean = false):Sprite;

  /**
   * Remove all sprites from the surface, optionally destroying the sprites in the process.
   * <p>For example:</p>
   * <pre>
   * drawContainer.getSurface('main').removeAll();
   * </pre>
   * @param isDestroy
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-removeAll Original Ext JS documentation of 'removeAll'
   */
  public native function removeAll(isDestroy:Boolean = false):void;

  /**
   * Triggers the re-rendering of the canvas.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-renderFrame Original Ext JS documentation of 'renderFrame'
   */
  public native function renderFrame():void;

  /**
   * Force the element to redraw.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-repaint Original Ext JS documentation of 'repaint'
   */
  public native function repaint():void;

  /**
   * Reset the matrix of the surface.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-resetTransform Original Ext JS documentation of 'resetTransform'
   */
  public native function resetTransform():void;

  /**
   * Round the number to align to the pixels on device.
   * @param num The number to align.
   * @return The resultant alignment.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-roundPixel Original Ext JS documentation of 'roundPixel'
   */
  public native function roundPixel(num:Number):Number;

  /**
   * Sets the value of <code>background</code>.
   * @param background The new value.
   * @see #background
   */
  public native function setBackground(background:Object):void;

  /**
   * Sets the value of <code>dirty</code>.
   * @param dirty The new value.
   * @see #dirty
   */
  public native function setDirty(dirty:Boolean):void;

  /**
   * Sets the value of <code>flipRtlText</code>.
   * @param flipRtlText The new value.
   * @see #flipRtlText
   */
  public native function setFlipRtlText(flipRtlText:Boolean):void;

  /**
   * Sets the value of <code>items</code>.
   * @param items The new value.
   * @see #items
   */
  public native function setItems(items:Array):void;

  /**
   * Sets the value of <code>rect</code>.
   * @param rect The new value.
   * @see #rect
   */
  public native function setRect(rect:Array):void;

  /**
   * Mark the surface to render after another surface is updated.
   * @param surface The surface to wait for.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.Surface.html#method-waitFor Original Ext JS documentation of 'waitFor'
   */
  public native function waitFor(surface:Surface):void;
}
}