package ext.draw.engine {
import ext.Widget;
import ext.draw.Surface;
import ext.draw.sprite.Sprite;

[Native("Ext.draw.engine.Canvas", require)]
/**
 * Provides specific methods to draw with 2D Canvas element.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html Original Ext JS documentation of 'Ext.draw.engine.Canvas'
 */
public class Canvas extends Surface {
  /**
   * @inheritDoc
   */
  public function Canvas(config:Widget = null) {
    super();
  }

  /**
   * A configuration object for Ext.Element.create() that is used to create the Element
   * template. Subclasses should avoid overriding this property and instead add elements
   * using →<code>template</code>.
   * <p>Supports all the standard options of a Ext.Element.create() config and adds 3
   * additional options:</p>
   * <ol>
   * <li>
   * <p><code>→reference</code> - this option specifies a name for Element references. These
   * references names become properties of the Widget instance and refer to Ext.Element
   * instances that were created using the template:</p>
   * <pre>
   *   element: {
   *       reference: 'element',
   *       children: [{
   *           reference: 'innerElement'
   *       }]
   *   }
   * </pre>
   * </li>
   * </ol>
   * <p>After construction of a widget the reference elements are accessible as follows:</p>
   * <pre>
   * var foo = new FooWidget(),
   *     innerEl = foo.innerElement; // an Ext.Element that wraps the innerElement
   * </pre>
   * <p>The reference attribute is optional, but all Widgets must have a <code>'element'</code>
   * reference on some element within the template (usually the outermost one).</p>
   * <ol start="2">
   * <li>
   * <p><code>→listeners</code> - a standard listeners object as specified by →<code>ext.mixin.Observable</code>.</p>
   * <pre>
   *   element: {
   *       reference: 'element',
   *       listeners: {
   *           click: 'onClick'
   *       },
   *       children: [{
   *           reference: 'innerElement',
   *           listeners: {
   *               click: 'onInnerClick'
   *           }
   *       }]
   *   }
   * </pre>
   * </li>
   * </ol>
   * <p>Since listeners cannot be attached without an Ext.Element reference the <code>→reference</code>
   * property MUST be specified in order to use <code>→listeners</code>.</p>
   * <p>The Widget instance is used as the scope for all listeners specified in this way,
   * so it is invalid to use the <code>scope</code> option in the <code>→listeners</code> config since it will
   * always be overwritten using <code>this</code>.</p>
   * <ol start="3">
   * <li><code>uiCls</code> - a suffix to be appended to the ui-specific CSS class for each <code>→ui</code>
   * for this widget. These ui classes are constructed by appending the <code>→ui</code> to each
   * <code>→classCls</code> or <code>→baseCls</code> for the widget. As such, <code>uiCls</code> should
   * never be used on the main <code>→element</code> reference, as its <code>uiCls</code> is computed automatically.</li>
   * </ol>
   * <p>For example, assume a widget is defined with a <code>→ui</code> of <code>'alt action'</code> and a
   * <code>uiCls</code> of <code>'inner-el'</code> on its <code>innerElement</code> reference element:</p>
   * <pre>
   *      Ext.define('Doodad', {
   *          extend: 'Ext.Widget',
   *          xtype: 'doodad',
   *
   *          classCls: 'x-doodad',
   *
   *          ui: 'alt action',
   *
   *          element: {
   *              reference: 'element',
   *
   *              children: [{
   *                  reference: 'innerElement',
   *                  cls: 'x-inner-el',
   *                  uiCls: 'inner-el'
   *              }]
   *          }
   *      });
   * </pre>
   * <p>This would result in the following markup when rendered:</p>
   * <pre>
   * &lt;div class="x-doodad x-doodad-alt x-doodad-action"&gt;
   *     &lt;div class="x-inner-el x-doodad-inner-el x-doodad-alt-inner-el x-doodad-action-inner-el"&gt;&lt;/div&gt;
   * &lt;/div&gt;
   * </pre>
   * <p>These additional classes can be used to style the reference element for a particular
   * ui; however, use of <code>uiCls</code> is not typically necessary or recommended. Reference
   * elements should usually be styled using simple descendant selectors:</p>
   * <pre>
   * .x-doodad-alt .x-inner-el {
   *     color: red;
   * }
   * </pre>
   * <p>When there is a possibility that widgets can be nested it is best to use direct
   * child selectors to avoid the possibility of selecting all descendants instead
   * of just the reference element for the intended widget:</p>
   * <pre>
   * .x-doodad-alt &gt; .x-inner-el {
   *     color: red;
   * }
   * </pre>
   * <p>Only use <code>uiCls</code> when there is a possibility of nesting, AND there may be a variable
   * number of elements between the main <code>→element</code> and the reference element in question.
   * For example, Ext.Container with docked items has a different number of elements
   * in between its <code>→element</code> and its <code>bodyElement</code> than a Container without docked items
   * because of the wrapping elements that are dynamically added to support docking.
   * To ensure it does not style all descendants it must use a <code>uiCls</code> to style its
   * <code>bodyElement</code>:</p>
   * <pre>
   * .x-container-alt-body-el {
   *     background: #fff;
   * }
   * </pre>
   * <p>Note that when <code>uiCls</code> is specified it also adds a class name that does not contain
   * the <code>→ui</code> using just the <code>→classCls</code> and/or <code>→baseCls</code> as the prefix. This class name
   * can be used for base-level styling that does not relate to any particular UI:</p>
   * <pre>
   * .x-container-body-el {
   *     position: relative;
   * }
   * </pre>
   * @default {
   *     reference: 'element',
   *     children: [
   *         {
   *             reference: 'bodyElement',
   *             style: {
   *                 width: '100%',
   *                 height: '100%',
   *                 position: 'relative'
   *             }
   *         }
   *     ]
   * }
   * @see #template
   * @see #reference
   * @see #listeners
   * @see ext.mixin.Observable
   * @see #ui
   * @see #classCls
   * @see #baseCls
   * @see #element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#property-element Original Ext JS documentation of 'element'
   */
  override public native function get element():Object;

  /**
   * @private
   */
  override public native function set element(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to have the Canvas use JavaScript Number instead of single precision floating point
   * for transforms.
   * <p>For example, when using data with big numbers to plot line series, the transformation
   * matrix of the canvas will have big elements. Due to the implementation of the SVGMatrix,
   * the elements are represented by 32-bits floats, which will work incorrectly.
   * To compensate for that, we enable the canvas context to perform all the transformations
   * in JavaScript.</p>
   * <p>Do not use this if you are not encountering 32-bit floating point errors problem,
   * since this will result in a performance penalty.</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#cfg-highPrecision Original Ext JS documentation of 'highPrecision'
   * @see #getHighPrecision()
   * @see #setHighPrecision()
   */
  public native function get highPrecision():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highPrecision(value:Boolean):void;

  /**
   * Empty the surface content (without touching the sprites.)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-clear Original Ext JS documentation of 'clear'
   */
  override public native function clear():void;

  /**
   * Clears the current transformation state on the surface.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-clearTransform Original Ext JS documentation of 'clearTransform'
   */
  public native function clearTransform():void;

  /**
   * Destroys the Canvas element and prepares it for Garbage Collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Returns the value of <code>highPrecision</code>.
   * @see #highPrecision
   */
  public native function getHighPrecision():Boolean;

  /**
   * Renders a single sprite into the surface.
   * Do not call it from outside <code>→renderFrame()</code> method.
   * @param sprite The Sprite to be rendered.
   * @return returns <code>false</code> to stop the rendering to continue.
   * @see #renderFrame()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-renderSprite Original Ext JS documentation of 'renderSprite'
   */
  public native function renderSprite(sprite:Sprite):Boolean;

  /**
   * Sets the value of <code>highPrecision</code>.
   * @param highPrecision The new value.
   * @see #highPrecision
   */
  public native function setHighPrecision(highPrecision:Boolean):void;

  /**
   * 2D Canvas context in IE (up to IE10, inclusive) doesn't support
   * the setLineDash method and the lineDashOffset property.
   * @param dashList An even number of non-negative numbers specifying a dash list.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-setLineDash Original Ext JS documentation of 'setLineDash'
   */
  public native function setLineDash(dashList:*):void;

  /**
   * @see #setLineDash()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-getLineDash Original Ext JS documentation of 'getLineDash'
   */
  public native function getLineDash():*;

  /**
   * Normally, a surface will have a single canvas.
   * However, on certain platforms/browsers there's a limit to how big a canvas can be.
   * 'splitThreshold' is used to determine maximum width/height of a single canvas element.
   * When a surface is wider/taller than the splitThreshold, extra canvas element(s)
   * will be created and tiled inside the surface.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Canvas.html#method-updateRect Original Ext JS documentation of 'updateRect'
   */
  public native function updateRect(rect:*):void;
}
}