package ext.draw.engine {
import ext.draw.Surface;
import ext.draw.sprite.Sprite;

[Native("Ext.draw.engine.Svg", require)]
/**
 * SVG engine.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html Original Ext JS documentation of 'Ext.draw.engine.Svg'
 */
public class Svg extends Surface {
  /**
   * @inheritDoc
   */
  public function Svg(config:Svg = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Nothing needs to be done in high precision mode.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html#cfg-highPrecision Original Ext JS documentation of 'highPrecision'
   * @see #getHighPrecision()
   * @see #setHighPrecision()
   */
  public native function get highPrecision():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set highPrecision(value:Boolean):void;

  /**
   * Empty the surface content (without touching the sprites.)
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html#method-clear Original Ext JS documentation of 'clear'
   */
  override public native function clear():void;

  /**
   * Clears the current transformation state on the surface.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html#method-clearTransform Original Ext JS documentation of 'clearTransform'
   */
  public native function clearTransform():void;

  /**
   * Creates a DOM element under the SVG namespace of the given type.
   * @param type The type of the SVG DOM element.
   * @return The created element.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html#method-createSvgNode Original Ext JS documentation of 'createSvgNode'
   */
  public native function createSvgNode(type:String):*;

  /**
   * Destroys the Canvas element and prepares it for Garbage Collection.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html#method-destroy Original Ext JS documentation of 'destroy'
   */
  override public native function destroy(...params):void;

  /**
   * Returns the value of <code>highPrecision</code>.
   * @see #highPrecision
   */
  public native function getHighPrecision():Boolean;

  /**
   * Renders a single sprite into the surface.
   * Do not call it from outside <code>→renderFrame()</code> method.
   * @param sprite The Sprite to be rendered.
   * @return returns <code>false</code> to stop the rendering to continue.
   * @see #renderFrame()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.Svg.html#method-renderSprite Original Ext JS documentation of 'renderSprite'
   */
  public native function renderSprite(sprite:Sprite):Boolean;

  /**
   * Sets the value of <code>highPrecision</code>.
   * @param highPrecision The new value.
   * @see #highPrecision
   */
  public native function setHighPrecision(highPrecision:Boolean):void;
}
}