package ext.draw.engine {
import ext.Base;

import js.HTMLElement;

[Native("Ext.draw.engine.SvgContext", require)]
/**
 * A class that imitates a canvas context but generates svg elements instead.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html Original Ext JS documentation of 'Ext.draw.engine.SvgContext'
 */
public class SvgContext extends Base {
  /**
   * Adds points to the subpath such that the arc described by the circumference of the circle
   * described by the arguments, starting at the given start angle and ending at the given
   * end angle, going in the given direction (defaulting to clockwise), is added to the path,
   * connected to the previous point by a straight line.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-arc Original Ext JS documentation of 'arc'
   */
  public native function arc(x:Number, y:Number, radius:Number, startAngle:Number, endAngle:Number, anticlockwise:Number):void;

  /**
   * Arc command using svg parameters.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-arcSvg Original Ext JS documentation of 'arcSvg'
   */
  public native function arcSvg(r1:Number, r2:Number, rotation:Number, large:Number, swipe:Number, x2:Number, y2:Number):void;

  /**
   * Adds an arc with the given control points and radius to the current subpath, connected
   * to the previous point by a straight line. If two radii are provided, the first controls
   * the width of the arc's ellipse, and the second controls the height. If only one is provided,
   * or if they are the same, the arc is from a circle. In the case of an ellipse, the rotation
   * argument controls the clockwise inclination of the ellipse relative to the x-axis.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-arcTo Original Ext JS documentation of 'arcTo'
   */
  public native function arcTo(x1:Number, y1:Number, x2:Number, y2:Number, radiusX:Number, radiusY:Number, rotation:Number):void;

  /**
   * Resets the current default path.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-beginPath Original Ext JS documentation of 'beginPath'
   */
  public native function beginPath():void;

  /**
   * Adds the given point to the current subpath, connected to the previous one by a cubic Bézier
   * curve with the given control points.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-bezierCurveTo Original Ext JS documentation of 'bezierCurveTo'
   */
  public native function bezierCurveTo(x1:Number, y1:Number, x2:Number, y2:Number, x3:Number, y3:Number):void;

  /**
   * Clears the context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-clear Original Ext JS documentation of 'clear'
   */
  public native function clear():void;

  /**
   * Marks the current subpath as closed, and starts a new subpath with a point the same
   * as the start and end of the newly closed subpath.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-closePath Original Ext JS documentation of 'closePath'
   */
  public native function closePath():void;

  /**
   * Returns an object that represents a linear gradient that paints along the line
   * given by the coordinates represented by the arguments.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-createLinearGradient Original Ext JS documentation of 'createLinearGradient'
   */
  public native function createLinearGradient(x0:Number, y0:Number, x1:Number, y1:Number):SvgContextGradient;

  /**
   * Returns a CanvasGradient object that represents a radial gradient that paints
   * along the cone given by the circles represented by the arguments.
   * If either of the radii are negative, throws an IndexSizeError exception.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-createRadialGradient Original Ext JS documentation of 'createRadialGradient'
   */
  public native function createRadialGradient(x0:Number, y0:Number, r0:Number, x1:Number, y1:Number, r1:Number):SvgContextGradient;

  /**
   * Draws the given image onto the canvas.
   * If the first argument isn't an img, canvas, or video element, throws a TypeMismatchError
   * exception. If the image has no image data, throws an InvalidStateError exception.
   * If the one of the source rectangle dimensions is zero, throws an IndexSizeError exception.
   * If the image isn't yet fully decoded, then nothing is drawn.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-drawImage Original Ext JS documentation of 'drawImage'
   */
  public native function drawImage(image:HTMLElement, sx:Number, sy:Number, sw:Number, sh:Number, dx:Number, dy:Number, dw:Number, dh:Number):void;

  /**
   * Adds points to the subpath such that the arc described by the circumference of the ellipse
   * described by the arguments, starting at the given start angle and ending at the given
   * end angle, going in the given direction (defaulting to clockwise), is added to the path,
   * connected to the previous point by a straight line.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-ellipse Original Ext JS documentation of 'ellipse'
   */
  public native function ellipse(x:Number, y:Number, radiusX:Number, radiusY:Number, rotation:Number, startAngle:Number, endAngle:Number, anticlockwise:Number):void;

  /**
   * Fills the subpaths of the current default path or the given path with the current fill style.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-fill Original Ext JS documentation of 'fill'
   */
  public native function fill():void;

  /**
   * Paints the given rectangle onto the canvas, using the current fill style.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-fillRect Original Ext JS documentation of 'fillRect'
   */
  public native function fillRect(x:Number, y:Number, width:Number, height:Number):void;

  /**
   * Note: After the method guarantees the transform matrix will be inverted.
   * @param attr The attribute object
   * @param transformFillStroke Indicate whether to transform fill and stroke.
   * If this is not given, then uses <code>attr.transformFillStroke</code> instead.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-fillStroke Original Ext JS documentation of 'fillStroke'
   */
  protected native function fillStroke(attr:Object, transformFillStroke:Boolean = false):void;

  /**
   * Fills the given text at the given position. If a maximum width is provided, the text
   * will be scaled to fit that width if necessary.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-fillText Original Ext JS documentation of 'fillText'
   */
  public native function fillText(text:String, x:Number, y:Number):void;

  /**
   * Adds the given point to the current subpath, connected to the previous one by a straight
   * line.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-lineTo Original Ext JS documentation of 'lineTo'
   */
  public native function lineTo(x:Number, y:Number):void;

  /**
   * Creates a new subpath with the given point.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-moveTo Original Ext JS documentation of 'moveTo'
   */
  public native function moveTo(x:Number, y:Number):void;

  /**
   * Adds a new closed subpath to the path, representing the given rectangle.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-rect Original Ext JS documentation of 'rect'
   */
  public native function rect(x:Number, y:Number, width:Number, height:Number):void;

  /**
   * Pops the state stack and restores the state.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-restore Original Ext JS documentation of 'restore'
   */
  public native function restore():void;

  /**
   * Rotates the current context coordinates (that is, a transformation matrix).
   * @param angle The rotation angle, in radians.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-rotate Original Ext JS documentation of 'rotate'
   */
  public native function rotate(angle:Number):void;

  /**
   * Pushes the context state to the state stack.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-save Original Ext JS documentation of 'save'
   */
  public native function save():void;

  /**
   * Scales the current context by the specified horizontal (x) and vertical (y) factors.
   * @param x The horizontal scaling factor, where 1 equals unity or 100% scale.
   * @param y The vertical scaling factor.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-scale Original Ext JS documentation of 'scale'
   */
  public native function scale(x:Number, y:Number):void;

  /**
   * Changes the transformation matrix to the matrix given by the arguments as described below.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-setTransform Original Ext JS documentation of 'setTransform'
   */
  public native function setTransform(xx:Number, yx:Number, xy:Number, yy:Number, dx:Number, dy:Number):void;

  /**
   * Strokes the subpaths of the current default path or the given path with the current
   * stroke style.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-stroke Original Ext JS documentation of 'stroke'
   */
  public native function stroke():void;

  /**
   * Paints the box that outlines the given rectangle onto the canvas, using the current
   * stroke style.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-strokeRect Original Ext JS documentation of 'strokeRect'
   */
  public native function strokeRect(x:Number, y:Number, width:Number, height:Number):void;

  /**
   * Strokes the given text at the given position. If a maximum width is provided, the text
   * will be scaled to fit that width if necessary.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-strokeText Original Ext JS documentation of 'strokeText'
   */
  public native function strokeText(text:String, x:Number, y:Number):void;

  /**
   * Changes the transformation matrix to apply the matrix given by the arguments
   * as described below.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-transform Original Ext JS documentation of 'transform'
   */
  public native function transform(xx:Number, yx:Number, xy:Number, yy:Number, dx:Number, dy:Number):void;

  /**
   * Specifies values to move the origin point in a canvas.
   * @param x The value to add to horizontal (or x) coordinates.
   * @param y The value to add to vertical (or y) coordinates.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.html#method-translate Original Ext JS documentation of 'translate'
   */
  public native function translate(x:Number, y:Number):void;
}
}