package ext.draw.engine {
import ext.Base;

[Native("Ext.draw.engine.SvgContext.Gradient", require)]
/**
 * A class that implements native CanvasGradient interface
 * (https://developer.mozilla.org/en/docs/Web/API/CanvasGradient)
 * and a <code>→toString()</code> method that returns the ID of the gradient.
 * @see #toString()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.Gradient.html Original Ext JS documentation of 'Ext.draw.engine.SvgContext.Gradient'
 */
public class SvgContextGradient extends Base {
  /**
   * Adds a color stop with the given color to the gradient at the given offset. 0.0 is the offset
   * at one end of the gradient, 1.0 is the offset at the other end.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.engine.SvgContext.Gradient.html#method-addColorStop Original Ext JS documentation of 'addColorStop'
   */
  public native function addColorStop(offset:Number, color:String):void;
}
}