package ext.draw.gradient {
import ext.Base;
import ext.draw.engine.SvgContext;

[Native("Ext.draw.gradient.Gradient", require)]
/**
 * Creates a gradient.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Gradient.html Original Ext JS documentation of 'Ext.draw.gradient.Gradient'
 */
public class Gradient extends Base {
  [ExtConfig]
  [Bindable]
  /**
   * Defines the stops of the gradient.
   * @default []
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Gradient.html#cfg-stops Original Ext JS documentation of 'stops'
   * @see #getStops()
   * @see #setStops()
   */
  public native function get stops():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set stops(value:Array):void;

  /**
   * Generates the gradient for the given context.
   * @param ctx The context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Gradient.html#method-generateGradient Original Ext JS documentation of 'generateGradient'
   */
  protected native function generateGradient(ctx:SvgContext, bbox:Object = null):*;

  /**
   * Returns the value of <code>stops</code>.
   * @see #stops
   */
  public native function getStops():Array;

  /**
   * Sets the value of <code>stops</code>.
   * @param stops The new value.
   * @see #stops
   */
  public native function setStops(stops:Array):void;
}
}