package ext.draw.gradient {
import ext.draw.engine.SvgContext;

[Native("Ext.draw.gradient.Linear", require)]
/**
 * Linear gradient.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'circle',
 *        cx: 100,
 *        cy: 100,
 *        r: 100,
 *        fillStyle: {
 *            type: 'linear',
 *            degrees: 180,
 *            stops: [{
 *                offset: 0,
 *                color: '#1F6D91'
 *            }, {
 *                offset: 1,
 *                color: '#90BCC9'
 *            }]
 *        }
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Linear.html Original Ext JS documentation of 'Ext.draw.gradient.Linear'
 */
public class LinearGradient extends Gradient {
  [ExtConfig]
  [Bindable]
  /**
   * The angle of rotation of the gradient in degrees.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Linear.html#cfg-degrees Original Ext JS documentation of 'degrees'
   * @see #getDegrees()
   * @see #setDegrees()
   */
  public native function get degrees():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set degrees(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The angle of rotation of the gradient in radians.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Linear.html#cfg-radians Original Ext JS documentation of 'radians'
   * @see #getRadians()
   * @see #setRadians()
   */
  public native function get radians():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set radians(value:Number):void;

  /**
   * Generates the gradient for the given context.
   * @param ctx The context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Linear.html#method-generateGradient Original Ext JS documentation of 'generateGradient'
   */
  override protected native function generateGradient(ctx:SvgContext, bbox:Object = null):*;

  /**
   * Returns the value of <code>degrees</code>.
   * @see #degrees
   */
  public native function getDegrees():Number;

  /**
   * Returns the value of <code>radians</code>.
   * @see #radians
   */
  public native function getRadians():Number;

  /**
   * Sets the value of <code>degrees</code>.
   * @param degrees The new value.
   * @see #degrees
   */
  public native function setDegrees(degrees:Number):void;

  /**
   * Sets the value of <code>radians</code>.
   * @param radians The new value.
   * @see #radians
   */
  public native function setRadians(radians:Number):void;
}
}