package ext.draw.gradient {
import ext.draw.engine.SvgContext;

[Native("Ext.draw.gradient.Radial", require)]
/**
 * Radial gradient.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'circle',
 *        cx: 100,
 *        cy: 100,
 *        r: 100,
 *        fillStyle: {
 *            type: 'radial',
 *            start: {
 *                x: 0,
 *                y: 0,
 *                r: 0
 *            },
 *            end: {
 *                x: 0,
 *                y: 0,
 *                r: 1
 *            },
 *            stops: [{
 *                offset: 0,
 *                color: '#90BCC9'
 *            }, {
 *                offset: 1,
 *                color: '#1F6D91'
 *            }]
 *        }
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Radial.html Original Ext JS documentation of 'Ext.draw.gradient.Radial'
 */
public class RadialGradient extends Gradient {
  [ExtConfig]
  [Bindable]
  /**
   * The ending circle of the gradient.
   * @default {
   *     x: 0,
   *     y: 0,
   *     r: 1
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Radial.html#cfg-end Original Ext JS documentation of 'end'
   * @see #getEnd()
   * @see #setEnd()
   */
  public native function get end():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set end(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * The starting circle of the gradient.
   * @default {
   *     x: 0,
   *     y: 0,
   *     r: 0
   * }
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Radial.html#cfg-start Original Ext JS documentation of 'start'
   * @see #getStart()
   * @see #setStart()
   */
  public native function get start():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set start(value:Object):void;

  /**
   * Generates the gradient for the given context.
   * @param ctx The context.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.gradient.Radial.html#method-generateGradient Original Ext JS documentation of 'generateGradient'
   */
  override protected native function generateGradient(ctx:SvgContext, bbox:Object = null):*;

  /**
   * Returns the value of <code>end</code>.
   * @see #end
   */
  public native function getEnd():Object;

  /**
   * Returns the value of <code>start</code>.
   * @see #start
   */
  public native function getStart():Object;

  /**
   * Sets the value of <code>end</code>.
   * @param end The new value.
   * @see #end
   */
  public native function setEnd(end:Object):void;

  /**
   * Sets the value of <code>start</code>.
   * @param start The new value.
   * @see #start
   */
  public native function setStart(start:Object):void;
}
}