package ext.draw.modifier {

[Native("Ext.draw.modifier.Animation", require)]
/**
 * The Animation modifier.
 * <p>Sencha Charts allow users to use transitional animation on sprites. Simply set the duration
 * and easing in the animation modifier, then all the changes to the sprites will be animated.</p>
 * <p><b>Example:</b></p>
 * <pre>
 * var drawCt = Ext.create({
 *     xtype: 'draw',
 *     renderTo: document.body,
 *     width: 400,
 *     height: 400,
 *     sprites: [{
 *         type: 'rect',
 *         x: 50,
 *         y: 50,
 *         width: 100,
 *         height: 100,
 *         fillStyle: '#1F6D91'
 *     }]
 * });
 *
 * var rect = drawCt.getSurface().getItems()[0];
 *
 * rect.setAnimation({
 *     duration: 1000,
 *     easing: 'elasticOut'
 * });
 *
 * Ext.defer(function () {
 *     rect.setAttributes({
 *         width: 250
 *     });
 * }, 500);
 * </pre>
 * <p>Also, you can use different durations and easing functions on different attributes by using
 * →<code>customDurations</code> and →<code>customEasings</code>.</p>
 * <p>By default, an animation modifier will be created during the initialization of a sprite.
 * You can get the animation modifier of a sprite via its
 * →<code>ext.draw.sprite.Sprite.getAnimation()</code> method.</p>
 * @see #customDurations
 * @see #customEasings
 * @see ext.draw.sprite.Sprite#getAnimation()
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html Original Ext JS documentation of 'Ext.draw.modifier.Animation'
 */
public class AnimationModifier extends Modifier {
  /**
   * @inheritDoc
   */
  public function AnimationModifier(config:AnimationModifier = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * Overrides the default duration for defined attributes.
   * E.g.:
   * <pre>
   * // Assuming the sprite the modifier is applied to is a 'circle'.
   * customDurations: {
   *     r: 1000,
   *     'fillStyle,strokeStyle': 2000,
   *     'cx,cy': 1000
   * }
   * </pre>
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#cfg-customDurations Original Ext JS documentation of 'customDurations'
   * @see #getCustomDurations()
   * @see #setCustomDurations()
   */
  public native function get customDurations():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set customDurations(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Overrides the default easing function for defined attributes.
   * E.g.:
   * <pre>
   * // Assuming the sprite the modifier is applied to is a 'circle'.
   * customEasings: {
   *     r: 'easeOut',
   *     'fillStyle,strokeStyle': 'linear',
   *     'cx,cy': function (p, n) {
   *         p = 1 - p;
   *         n = n || 1.616;
   *         return 1 - p &#42; p &#42; ((n + 1) &#42; p - n);
   *     }
   * }
   * </pre>
   * @default {}
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#cfg-customEasings Original Ext JS documentation of 'customEasings'
   * @see #getCustomEasings()
   * @see #setCustomEasings()
   */
  public native function get customEasings():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set customEasings(value:Object):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default duration time (ms).
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#cfg-duration Original Ext JS documentation of 'duration'
   * @see #getDuration()
   * @see #setDuration()
   */
  public native function get duration():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set duration(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * Default easing function.
   * @default Ext.identityFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#cfg-easing Original Ext JS documentation of 'easing'
   * @see #getEasing()
   * @see #setEasing()
   */
  public native function get easing():Function;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set easing(value:Function):void;

  /**
   * Remove special easings on the given attributes.
   * @param attrs The source attributes.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#method-clearDurationOn Original Ext JS documentation of 'clearDurationOn'
   */
  public native function clearDurationOn(attrs:Object):void;

  /**
   * Remove special easings on the given attributes.
   * @param attrs The source attribute(s).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#method-clearEasingOn Original Ext JS documentation of 'clearEasingOn'
   */
  public native function clearEasingOn(attrs:*):void;

  /**
   * Returns the value of <code>customDurations</code>.
   * @see #customDurations
   */
  public native function getCustomDurations():Object;

  /**
   * Returns the value of <code>customEasings</code>.
   * @see #customEasings
   */
  public native function getCustomEasings():Object;

  /**
   * Returns the value of <code>duration</code>.
   * @see #duration
   */
  public native function getDuration():Number;

  /**
   * Returns the value of <code>easing</code>.
   * @see #easing
   */
  public native function getEasing():Function;

  /**
   * Sets the value of <code>customDurations</code>.
   * @param customDurations The new value.
   * @see #customDurations
   */
  public native function setCustomDurations(customDurations:Object):void;

  /**
   * Sets the value of <code>customEasings</code>.
   * @param customEasings The new value.
   * @see #customEasings
   */
  public native function setCustomEasings(customEasings:Object):void;

  /**
   * Sets the value of <code>duration</code>.
   * @param duration The new value.
   * @see #duration
   */
  public native function setDuration(duration:Number):void;

  /**
   * Set special duration on the given attributes. E.g.:
   * <pre>
   * rectSprite.getAnimation().setDurationOn('height', 2000);
   * </pre>
   * @param attrs The source attributes.
   * @param duration The special duration.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#method-setDurationOn Original Ext JS documentation of 'setDurationOn'
   */
  public native function setDurationOn(attrs:*, duration:Number):void;

  /**
   * Sets the value of <code>easing</code>.
   * @param easing The new value.
   * @see #easing
   */
  public native function setEasing(easing:Function):void;

  /**
   * Set special easings on the given attributes. E.g.:
   * <pre>
   * circleSprite.getAnimation().setEasingOn('r', 'elasticIn');
   * </pre>
   * @param attrs The source attribute(s).
   * @param easing The special easings.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#method-setEasingOn Original Ext JS documentation of 'setEasingOn'
   */
  public native function setEasingOn(attrs:*, easing:String):void;

  /**
   * Stop all animations affected by this modifier.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Animation.html#method-stop Original Ext JS documentation of 'stop'
   */
  public native function stop():void;
}
}