package ext.draw.modifier {

[Native("Ext.draw.modifier.Highlight", require)]
/**
 * Highlight is a modifier that will override sprite attributes
 * with →<code>ext.draw.modifier.HighlightModifier.style</code> attributes
 * when sprite's <code>highlighted</code> attribute is true.
 * @see ext.draw.modifier.HighlightModifier#style
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Highlight.html Original Ext JS documentation of 'Ext.draw.modifier.Highlight'
 */
public class HighlightModifier extends Modifier {
  /**
   * @inheritDoc
   */
  public function HighlightModifier(config:HighlightModifier = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * 'true' if the highlight is applied.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Highlight.html#cfg-enabled Original Ext JS documentation of 'enabled'
   * @see #getEnabled()
   * @see #setEnabled()
   */
  public native function get enabled():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set enabled(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The style attributes of the highlight modifier.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Highlight.html#cfg-style Original Ext JS documentation of 'style'
   * @see #getStyle()
   * @see #setStyle()
   */
  public native function get style():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set style(value:Object):void;

  /**
   * Returns the value of <code>enabled</code>.
   * @see #enabled
   */
  public native function getEnabled():Boolean;

  /**
   * Returns the value of <code>style</code>.
   * @see #style
   */
  public native function getStyle():Object;

  /**
   * Sets the value of <code>enabled</code>.
   * @param enabled The new value.
   * @see #enabled
   */
  public native function setEnabled(enabled:Boolean):void;

  /**
   * Sets the value of <code>style</code>.
   * @param style The new value.
   * @see #style
   */
  public native function setStyle(style:Object):void;
}
}