package ext.draw.modifier {
import ext.draw.sprite.Sprite;
import ext.mixin.Observable;

[Native("Ext.draw.modifier.Modifier", require)]
/**
 * Each sprite has a stack of modifiers. The resulting attributes of sprite is
 * the content of the stack top. When setting attributes to a sprite,
 * changes will be pushed-down though the stack of modifiers and pop-back the
 * additive changes; When modifier is triggered to change the attribute of a
 * sprite, it will pop-up the changes to the top.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Modifier.html Original Ext JS documentation of 'Ext.draw.modifier.Modifier'
 */
public class Modifier extends Observable {
  /**
   * @inheritDoc
   */
  public function Modifier(config:Modifier = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The sprite to which the modifier belongs.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.modifier.Modifier.html#cfg-sprite Original Ext JS documentation of 'sprite'
   * @see #getSprite()
   * @see #setSprite()
   */
  public native function get sprite():Sprite;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set sprite(value:Sprite):void;

  /**
   * Returns the value of <code>sprite</code>.
   * @see #sprite
   */
  public native function getSprite():Sprite;

  /**
   * Sets the value of <code>sprite</code>.
   * @param sprite The new value.
   * @see #sprite
   */
  public native function setSprite(sprite:Sprite):void;
}
}