package ext.draw.plugin {
import ext.plugin.AbstractPlugin;

[Native("Ext.draw.plugin.SpriteEvents", require)]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_CLICK
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_CLICK
 */
[Event(name='onSpriteClick', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_DBLCLICK
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_DBLCLICK
 */
[Event(name='onSpriteDblclick', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_DOWN
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_DOWN
 */
[Event(name='onSpriteMouseDown', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_MOVE
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_MOVE
 */
[Event(name='onSpriteMouseMove', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_OUT
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_OUT
 */
[Event(name='onSpriteMouseOut', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_OVER
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_OVER
 */
[Event(name='onSpriteMouseOver', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_UP
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_MOUSE_UP
 */
[Event(name='onSpriteMouseUp', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * @see ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_TAP
 * @eventType ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent.SPRITE_TAP
 */
[Event(name='onSpriteTap', type='ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent')]
/**
 * A draw container <i>plugin</i> (→<code>ext.plugin.AbstractPlugin</code>) that adds ability to listen
 * to sprite events. For example:
 * <pre>
 * var drawContainer = Ext.create('Ext.draw.Container', {
 *      plugins: {
 *          spriteevents: true
 *      },
 *      renderTo: Ext.getBody(),
 *      width: 200,
 *      height: 200,
 *      sprites: [{
 *           type: 'circle',
 *           fillStyle: '#79BB3F',
 *           r: 50,
 *           x: 100,
 *           y: 100
 *      }],
 *      listeners: {
 *          spriteclick: function (item, event) {
 *              var sprite = item &amp;&amp; item.sprite;
 *              if (sprite) {
 *                  sprite.setAttributes({fillStyle: 'red'});
 *                    sprite.getSurface().renderFrame();
 *              }
 *          }
 *      }
 * });
 * </pre>
 * @see ext.plugin.AbstractPlugin
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html Original Ext JS documentation of 'Ext.draw.plugin.SpriteEvents'
 */
public class SpriteEventsPlugin extends AbstractPlugin {
  /**
   * @inheritDoc
   */
  public function SpriteEventsPlugin(config:SpriteEventsPlugin = null) {
    super(config);
  }
}
}