package ext.draw.plugin.events {
import js.Event;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.draw.plugin.events.SpriteEventsPlugin_sprite_eventEvent")]
public class SpriteEventsPlugin_sprite_eventEvent extends FlExtEvent {
  /**
   * Fires when a click event occurs on a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spriteclick Original Ext JS documentation of 'spriteclick'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteClick
   */
  public static const SPRITE_CLICK:String = "onSpriteClick";
  /**
   * Fires when a double click event occurs on a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritedblclick Original Ext JS documentation of 'spritedblclick'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteDblclick
   */
  public static const SPRITE_DBLCLICK:String = "onSpriteDblclick";
  /**
   * Fires when a mousedown event occurs on a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritemousedown Original Ext JS documentation of 'spritemousedown'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteMouseDown
   */
  public static const SPRITE_MOUSE_DOWN:String = "onSpriteMouseDown";
  /**
   * Fires when the mouse is moved on a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritemousemove Original Ext JS documentation of 'spritemousemove'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteMouseMove
   */
  public static const SPRITE_MOUSE_MOVE:String = "onSpriteMouseMove";
  /**
   * Fires when the mouse exits a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritemouseout Original Ext JS documentation of 'spritemouseout'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteMouseOut
   */
  public static const SPRITE_MOUSE_OUT:String = "onSpriteMouseOut";
  /**
   * Fires when the mouse enters a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritemouseover Original Ext JS documentation of 'spritemouseover'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteMouseOver
   */
  public static const SPRITE_MOUSE_OVER:String = "onSpriteMouseOver";
  /**
   * Fires when a mouseup event occurs on a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritemouseup Original Ext JS documentation of 'spritemouseup'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteMouseUp
   */
  public static const SPRITE_MOUSE_UP:String = "onSpriteMouseUp";
  /**
   * Fires when a tap event occurs on a sprite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.plugin.SpriteEvents.html#event-spritetap Original Ext JS documentation of 'spritetap'
   * @see ext.draw.plugin.SpriteEventsPlugin
   * @eventType onSpriteTap
   */
  public static const SPRITE_TAP:String = "onSpriteTap";
  public static const __PARAMETER_SEQUENCE__:Array = ["sprite", "event", "eOpts"];

  public function SpriteEventsPlugin_sprite_eventEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  public native function get event():Event;

  public native function get sprite():Object;
}
}