package ext.draw.sprite {

[Native("Ext.draw.sprite.Arrow", require)]
/**
 * A sprite that represents an arrow.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'arrow',
 *        translationX: 100,
 *        translationY: 100,
 *        size: 40,
 *        fillStyle: '#30BDA7'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Arrow.html Original Ext JS documentation of 'Ext.draw.sprite.Arrow'
 */
public class ArrowSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function ArrowSprite(config:ArrowSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The size of the sprite.
   * Meant to be comparable to the size of a circle sprite with the same radius.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Arrow.html#cfg-size Original Ext JS documentation of 'size'
   */
  public native function get size():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set size(value:Number):void;
}
}