package ext.draw.sprite {

[Native("Ext.draw.sprite.Circle", require)]
/**
 * A sprite that represents a circle.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'circle',
 *        cx: 100,
 *        cy: 100,
 *        r: 50,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Circle.html Original Ext JS documentation of 'Ext.draw.sprite.Circle'
 */
public class CircleSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function CircleSprite(config:CircleSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The center coordinate of the sprite on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Circle.html#cfg-cx Original Ext JS documentation of 'cx'
   */
  public native function get cx():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cx(value:Number):void;

  [ExtConfig]
  /**
   * The center coordinate of the sprite on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Circle.html#cfg-cy Original Ext JS documentation of 'cy'
   */
  public native function get cy():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cy(value:Number):void;

  [ExtConfig]
  /**
   * The radius of the sprite.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Circle.html#cfg-r Original Ext JS documentation of 'r'
   */
  public native function get r():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set r(value:Number):void;
}
}