package ext.draw.sprite {
import ext.draw.Surface;
import ext.mixin.Observable;

[Native("Ext.draw.sprite.Composite", require)]
/**
 * Represents a group of sprites.
 * Composite's sprites are rendered in the order they've been added to the Composite.
 * The rendering order of composite sprites themselves is determined by the value of
 * their zIndex attribute, just like with any other sprite.
 * Every sprite that is added to the Composite is removed from whatever Surface/Composite
 * it belongs to.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Composite.html Original Ext JS documentation of 'Ext.draw.sprite.Composite'
 */
public class CompositeSprite extends Sprite {
  /**
   * @inheritDoc
   */
  public function CompositeSprite(config:CompositeSprite = null) {
    super();
  }

  [Deprecated(replacement="addSprite", since="6.2.1")]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Composite.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(sprite:*):void;

  [Deprecated(replacement="addSprite", since="6.2.1")]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Composite.html#method-addAll Original Ext JS documentation of 'addAll'
   */
  public native function addAll(sprites:*):void;

  /**
   * Adds sprite(s) to the composite.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Composite.html#method-addSprite Original Ext JS documentation of 'addSprite'
   */
  public native function addSprite(sprite:*):*;

  /**
   * Renders all sprites contained in the composite to the surface.
   * @param surface A draw container surface.
   * @param ctx A context object that is API compatible with the native
   * <a href="https://developer.mozilla.org/en/docs/Web/API/CanvasRenderingContext2D">CanvasRenderingContext2D</a>.
   * @param surfaceClipRect The clip rect: [left, top, width, height].
   * Not to be confused with the <code>surface.getRect()</code>, which represents the location
   * and size of the surface in a draw container, in draw container coordinates.
   * The clip rect on the other hand represents the portion of the surface that is being
   * rendered, in surface coordinates.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Composite.html#method-render Original Ext JS documentation of 'render'
   */
  override public native function render(surface:Surface, ctx:Object, surfaceClipRect:Array):*;

  /**
   * Updates the bounding box of the composite, which contains the bounding box of all sprites
   * in the composite.
   * @param plain Target object.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Composite.html#method-updatePlainBBox Original Ext JS documentation of 'updatePlainBBox'
   */
  override protected native function updatePlainBBox(plain:Object):void;
}
}