package ext.draw.sprite {

[Native("Ext.draw.sprite.Cross", require)]
/**
 * A sprite that represents a cross.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'cross',
 *        translationX: 100,
 *        translationY: 100,
 *        size: 40,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Cross.html Original Ext JS documentation of 'Ext.draw.sprite.Cross'
 */
public class CrossSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function CrossSprite(config:CrossSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The size of the sprite.
   * Meant to be comparable to the size of a circle sprite with the same radius.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Cross.html#cfg-size Original Ext JS documentation of 'size'
   */
  public native function get size():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set size(value:Number):void;
}
}