package ext.draw.sprite {

[Native("Ext.draw.sprite.Ellipse", require)]
/**
 * A sprite that represents an ellipse.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'ellipse',
 *        cx: 100,
 *        cy: 100,
 *        rx: 80,
 *        ry: 50,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Ellipse.html Original Ext JS documentation of 'Ext.draw.sprite.Ellipse'
 */
public class EllipseSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function EllipseSprite(config:EllipseSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The rotation of the sprite about its axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Ellipse.html#cfg-axisRotation Original Ext JS documentation of 'axisRotation'
   */
  public native function get axisRotation():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set axisRotation(value:Number):void;

  [ExtConfig]
  /**
   * The center coordinate of the sprite on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Ellipse.html#cfg-cx Original Ext JS documentation of 'cx'
   */
  public native function get cx():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cx(value:Number):void;

  [ExtConfig]
  /**
   * The center coordinate of the sprite on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Ellipse.html#cfg-cy Original Ext JS documentation of 'cy'
   */
  public native function get cy():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set cy(value:Number):void;

  [ExtConfig]
  /**
   * The radius of the sprite on the x-axis.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Ellipse.html#cfg-rx Original Ext JS documentation of 'rx'
   */
  public native function get rx():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set rx(value:Number):void;

  [ExtConfig]
  /**
   * The radius of the sprite on the y-axis.
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Ellipse.html#cfg-ry Original Ext JS documentation of 'ry'
   */
  public native function get ry():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ry(value:Number):void;
}
}