package ext.draw.sprite {

[Native("Ext.draw.sprite.EllipticalArc", require)]
/**
 * A sprite that represents an elliptical arc.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'ellipticalArc',
 *        cx: 100,
 *        cy: 100,
 *        rx: 80,
 *        ry: 50,
 *        fillStyle: '#1F6D91',
 *        startAngle: 0,
 *        endAngle: Math.PI,
 *        anticlockwise: true
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.EllipticalArc.html Original Ext JS documentation of 'Ext.draw.sprite.EllipticalArc'
 */
public class EllipticalArcSprite extends EllipseSprite {
  /**
   * @inheritDoc
   */
  public function EllipticalArcSprite(config:EllipticalArcSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * Determines whether or not the arc
   * is drawn clockwise.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.EllipticalArc.html#cfg-anticlockwise Original Ext JS documentation of 'anticlockwise'
   */
  public native function get anticlockwise():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anticlockwise(value:Boolean):void;

  [ExtConfig]
  /**
   * The ending angle of the arc.
   * @default Math.PI&#42;2
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.EllipticalArc.html#cfg-endAngle Original Ext JS documentation of 'endAngle'
   */
  public native function get endAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endAngle(value:Number):void;

  [ExtConfig]
  /**
   * The beginning angle of the arc.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.EllipticalArc.html#cfg-startAngle Original Ext JS documentation of 'startAngle'
   */
  public native function get startAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startAngle(value:Number):void;
}
}