package ext.draw.sprite {

[Native("Ext.draw.sprite.Image", require)]
/**
 * A sprite that represents an image.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Image.html Original Ext JS documentation of 'Ext.draw.sprite.Image'
 */
public class ImageSprite extends RectSprite {
  /**
   * @inheritDoc
   */
  public function ImageSprite(config:ImageSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The height of the image.
   * For consistent image size on all devices the height must be explicitly set.
   * Otherwise the natural image height devided by the device pixel ratio
   * (for a crisp looking image) will be used as the height of the sprite.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Image.html#cfg-height Original Ext JS documentation of 'height'
   */
  override public native function get height():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set height(value:Number):void;

  [ExtConfig]
  /**
   * The image source of the sprite.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Image.html#cfg-src Original Ext JS documentation of 'src'
   */
  public native function get src():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set src(value:String):void;

  [ExtConfig]
  /**
   * The width of the image.
   * For consistent image size on all devices the width must be explicitly set.
   * Otherwise the natural image width devided by the device pixel ratio
   * (for a crisp looking image) will be used as the width of the sprite.
   * @default null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Image.html#cfg-width Original Ext JS documentation of 'width'
   */
  override public native function get width():Number;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set width(value:Number):void;
}
}