package ext.draw.sprite {

[Native("Ext.draw.sprite.Instancing", require)]
/**
 * Sprite that represents multiple instances based on the given template.
 * <p><b>From override Ext.draw.overrides.hittest.sprite.Instancing:</b></p>
 * Adds hit testing methods to the Ext.draw.sprite.Instancing.
 * Included by the Ext.draw.plugin.SpriteEvents.
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html Original Ext JS documentation of 'Ext.draw.sprite.Instancing'
 */
public class InstancingSprite extends Sprite {
  /**
   * @inheritDoc
   */
  public function InstancingSprite(config:InstancingSprite = null) {
    super(config);
  }

  [ExtConfig]
  [Bindable]
  /**
   * The instances of the →<code>template</code> sprite as configs of attributes.
   * @see #template
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#cfg-instances Original Ext JS documentation of 'instances'
   * @see #getInstances()
   * @see #setInstances()
   */
  public native function get instances():Array;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set instances(value:Array):void;

  [ExtConfig]
  [Bindable]
  /**
   * The sprite template used by all instances.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#cfg-template Original Ext JS documentation of 'template'
   * @see #getTemplate()
   * @see #setTemplate()
   */
  public native function get template():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  public native function set template(value:Object):void;

  /**
   * Creates a new sprite instance.
   * @param config The configuration of the instance.
   * @param bypassNormalization 'true' to bypass attribute normalization.
   * @param avoidCopy 'true' to avoid copying the <code>config</code> object.
   * @return The attributes of the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#method-add Original Ext JS documentation of 'add'
   */
  public native function add(config:Object, bypassNormalization:Boolean = false, avoidCopy:Boolean = false):Object;

  [Deprecated(replacement="add", since="6.2.0")]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#method-createInstance Original Ext JS documentation of 'createInstance'
   */
  public native function createInstance(config:*, bypassNormalization:*, avoidCopy:*):void;

  /**
   * Not supported.
   * @param isWithoutTransform Whether to calculate the bounding box
   * with the current transforms or not.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#method-getBBox Original Ext JS documentation of 'getBBox'
   */
  override public native function getBBox(isWithoutTransform:Boolean = false):void;

  /**
   * Returns the bounding box for the instance at the given index.
   * @param index The index of the instance.
   * @param isWithoutTransform 'true' to not apply sprite transforms
   * to the bounding box.
   * @return The bounding box for the instance.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#method-getBBoxFor Original Ext JS documentation of 'getBBoxFor'
   */
  public native function getBBoxFor(index:Number, isWithoutTransform:Boolean = false):Object;

  /**
   * Returns the value of <code>instances</code>.
   * @see #instances
   */
  public native function getInstances():Array;

  /**
   * Returns the value of <code>template</code>.
   * @see #template
   */
  public native function getTemplate():Object;

  /**
   * Performs a hit test on the instances of an instancing sprite.
   * @param point A two-item array containing x and y coordinates of the point.
   * @param options Hit testing options.
   * @return A hit result object that contains more information about what
   * exactly was hit or null if nothing was hit.
   * <ul>
   * <li><code>isInstance:Boolean</code> (optional) —
   * <code>true</code> if an instance was hit.
   * </li>
   * <li><code>sprite:ext.draw.sprite.InstancingSprite</code> (optional) —
   * The instancing sprite.
   * </li>
   * <li><code>template:ext.draw.sprite.Sprite</code> (optional) —
   * The template of the instancing sprite.
   * </li>
   * <li><code>instance:Object</code> (optional) —
   * The attributes of the instance.
   * </li>
   * <li><code>index:Number</code> (optional) —
   * The index of the instance.
   * </li>
   * </ul>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#method-hitTest Original Ext JS documentation of 'hitTest'
   */
  override public native function hitTest(point:Array, options:Object):Object;

  /**
   * Sets the attributes for the instance at the given index.
   * @param index the index of the instance
   * @param changes the attributes to change
   * @param bypassNormalization 'true' to avoid attribute normalization
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Instancing.html#method-setAttributesFor Original Ext JS documentation of 'setAttributesFor'
   */
  public native function setAttributesFor(index:Number, changes:Object, bypassNormalization:Boolean = false):void;

  /**
   * Sets the value of <code>instances</code>.
   * @param instances The new value.
   * @see #instances
   */
  public native function setInstances(instances:Array):void;

  /**
   * Sets the value of <code>template</code>.
   * @param template The new value.
   * @see #template
   */
  public native function setTemplate(template:Object):void;
}
}