package ext.draw.sprite {

[Native("Ext.draw.sprite.Line", require)]
/**
 * A sprite that represents a line.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'line',
 *        fromX: 20,
 *        fromY: 20,
 *        toX: 120,
 *        toY: 120,
 *        strokeStyle: '#1F6D91',
 *        lineWidth: 3
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Line.html Original Ext JS documentation of 'Ext.draw.sprite.Line'
 */
public class LineSprite extends Sprite {
  /**
   * @inheritDoc
   */
  public function LineSprite(config:LineSprite = null) {
    super(config);
  }
}
}