package ext.draw.sprite {

[Native("Ext.draw.sprite.Rect", require)]
/**
 * A sprite that represents a rectangle.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'rect',
 *        x: 50,
 *        y: 50,
 *        width: 100,
 *        height: 100,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Rect.html Original Ext JS documentation of 'Ext.draw.sprite.Rect'
 */
public class RectSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function RectSprite(config:RectSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The height of the sprite.
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Rect.html#cfg-height Original Ext JS documentation of 'height'
   */
  public native function get height():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set height(value:Number):void;

  [ExtConfig]
  /**
   * The radius of the rounded corners.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Rect.html#cfg-radius Original Ext JS documentation of 'radius'
   */
  public native function get radius():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set radius(value:Number):void;

  [ExtConfig]
  /**
   * The width of the sprite.
   * @default 8
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Rect.html#cfg-width Original Ext JS documentation of 'width'
   */
  public native function get width():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set width(value:Number):void;

  [ExtConfig]
  /**
   * The position of the sprite on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Rect.html#cfg-x Original Ext JS documentation of 'x'
   */
  public native function get x():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set x(value:Number):void;

  [ExtConfig]
  /**
   * The position of the sprite on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Rect.html#cfg-y Original Ext JS documentation of 'y'
   */
  public native function get y():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set y(value:Number):void;
}
}