package ext.draw.sprite {

[Native("Ext.draw.sprite.Sector", require)]
/**
 * A sprite representing a pie slice.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'sector',
 *        centerX: 100,
 *        centerY: 100,
 *        startAngle: -2.355,
 *        endAngle: -.785,
 *        endRho: 50,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html Original Ext JS documentation of 'Ext.draw.sprite.Sector'
 */
public class SectorSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function SectorSprite(config:SectorSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The center coordinate of the sprite on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-centerX Original Ext JS documentation of 'centerX'
   */
  public native function get centerX():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set centerX(value:Number):void;

  [ExtConfig]
  /**
   * The center coordinate of the sprite on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-centerY Original Ext JS documentation of 'centerY'
   */
  public native function get centerY():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set centerY(value:Number):void;

  [ExtConfig]
  /**
   * The ending angle of the sprite.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-endAngle Original Ext JS documentation of 'endAngle'
   */
  public native function get endAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endAngle(value:Number):void;

  [ExtConfig]
  /**
   * The ending point of the radius of the sprite.
   * @default 150
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-endRho Original Ext JS documentation of 'endRho'
   */
  public native function get endRho():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set endRho(value:Number):void;

  [ExtConfig]
  /**
   * The margin of the sprite from the center of pie.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-margin Original Ext JS documentation of 'margin'
   */
  public native function get margin():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set margin(value:Number):void;

  [ExtConfig]
  /**
   * The starting angle of the sprite.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-startAngle Original Ext JS documentation of 'startAngle'
   */
  public native function get startAngle():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startAngle(value:Number):void;

  [ExtConfig]
  /**
   * The starting point of the radius of the sprite.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Sector.html#cfg-startRho Original Ext JS documentation of 'startRho'
   */
  public native function get startRho():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set startRho(value:Number):void;
}
}