package ext.draw.sprite {

[Native("Ext.draw.sprite.Square", require)]
/**
 * A sprite that represents a square.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'square',
 *        x: 100,
 *        y: 100,
 *        size: 50,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Square.html Original Ext JS documentation of 'Ext.draw.sprite.Square'
 */
public class SquareSprite extends PathSprite {
  /**
   * @inheritDoc
   */
  public function SquareSprite(config:SquareSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The size of the sprite.
   * Meant to be comparable to the size of a circle sprite with the same radius.
   * @default 4
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Square.html#cfg-size Original Ext JS documentation of 'size'
   */
  public native function get size():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set size(value:Number):void;
}
}