package ext.draw.sprite {

[Native("Ext.draw.sprite.Text", require)]
/**
 * A sprite that represents text.
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create({
 *    xtype: 'draw',
 *    renderTo: document.body,
 *    width: 600,
 *    height: 400,
 *    sprites: [{
 *        type: 'text',
 *        x: 50,
 *        y: 50,
 *        text: 'Sencha',
 *        fontSize: 30,
 *        fillStyle: '#1F6D91'
 *    }]
 * });
 * </pre>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html Original Ext JS documentation of 'Ext.draw.sprite.Text'
 */
public class TextSprite extends Sprite {
  /**
   * Debug rendering options...
   * <p>debug: {
   * bbox: true // renders the bounding box of the text sprite
   * }</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#static-property-debug Original Ext JS documentation of 'debug'
   */
  public static native function get debug():*;

  /**
   * @private
   */
  public static native function set debug(value:*):void;

  /**
   * @inheritDoc
   */
  public function TextSprite(config:TextSprite = null) {
    super(config);
  }

  [ExtConfig]
  /**
   * The font displayed.
   * @default '10px sans-serif'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-font Original Ext JS documentation of 'font'
   */
  public native function get font():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set font(value:String):void;

  [ExtConfig]
  /**
   * The family of the font displayed.
   * @default 'sans-serif'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-fontFamily Original Ext JS documentation of 'fontFamily'
   */
  public native function get fontFamily():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fontFamily(value:String):void;

  [ExtConfig]
  /**
   * The size of the font displayed.
   * @default '10px'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-fontSize Original Ext JS documentation of 'fontSize'
   */
  public native function get fontSize():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fontSize(value:*):void;

  [ExtConfig]
  /**
   * The style of the font displayed. {normal, italic, oblique}
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-fontStyle Original Ext JS documentation of 'fontStyle'
   */
  public native function get fontStyle():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fontStyle(value:String):void;

  [ExtConfig]
  /**
   * The variant of the font displayed. {normal, small-caps}
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-fontVariant Original Ext JS documentation of 'fontVariant'
   */
  public native function get fontVariant():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fontVariant(value:String):void;

  [ExtConfig]
  /**
   * The weight of the font displayed. {normal, bold, bolder, lighter}
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-fontWeight Original Ext JS documentation of 'fontWeight'
   */
  public native function get fontWeight():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set fontWeight(value:String):void;

  [ExtConfig]
  /**
   * The text represented in the sprite.
   * @default ''
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-text Original Ext JS documentation of 'text'
   */
  public native function get text():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set text(value:String):void;

  [ExtConfig]
  /**
   * The alignment of the text displayed.
   * @default 'start'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-textAlign Original Ext JS documentation of 'textAlign'
   */
  public native function get textAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set textAlign(value:String):void;

  [ExtConfig]
  /**
   * The baseline of the text displayed.
   * {top, hanging, middle, alphabetic, ideographic, bottom}
   * @default "alphabetic"
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-textBaseline Original Ext JS documentation of 'textBaseline'
   */
  public native function get textBaseline():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set textBaseline(value:String):void;

  [ExtConfig]
  /**
   * The position of the sprite on the x-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-x Original Ext JS documentation of 'x'
   */
  public native function get x():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set x(value:Number):void;

  [ExtConfig]
  /**
   * The position of the sprite on the y-axis.
   * @default 0
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.draw.sprite.Text.html#cfg-y Original Ext JS documentation of 'y'
   */
  public native function get y():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set y(value:Number):void;
}
}